/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeAccess;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeTier;
import com.mayflower.steelhold.registry.ModSounds;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SafeBlock
extends FallingBlock
implements EntityBlock,
HasSafeTier {
    private final SafeTier tier;
    private static final Set<Long> FALLING_POS = new HashSet<Long>();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public SafeBlock(SafeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public SafeTier getTier() {
        return this.tier;
    }

    private int requiredToolLevelFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Integer)c.basicToolLevel.get();
            case SafeTier.REINFORCED -> (Integer)c.reinforcedToolLevel.get();
            case SafeTier.STEELHOLD -> (Integer)c.steelholdToolLevel.get();
            case SafeTier.VAULT -> (Integer)c.vaultToolLevel.get();
            case SafeTier.BANK -> (Integer)c.bankToolLevel.get();
        };
    }

    private boolean hasRequiredPickaxe(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        ItemStack held = player.m_21205_();
        if (!held.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return false;
        }
        Item item = held.m_41720_();
        if (!(item instanceof TieredItem)) {
            return false;
        }
        TieredItem tool = (TieredItem)item;
        int toolLevel = tool.m_43314_().m_6604_();
        int required = this.requiredToolLevelFromConfig();
        return toolLevel >= required;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!this.hasRequiredPickaxe(player)) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return this.hasRequiredPickaxe(player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!SafeAccess.canOpen(level, pos, player)) {
            String ownerName = "Unknown";
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                ownerName = be.getOwnerName(level);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udd12 Locked. Owner: " + ownerName + " \u2014 you need a key.")), true);
            level.m_5594_(null, pos, (SoundEvent)ModSounds.SAFE_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, pos, (SoundEvent)ModSounds.SAFE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)provider, (BlockPos)pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public SafeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SafeBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        if (FALLING_POS.contains(pos.m_121878_())) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        if (state.m_60734_() != newState.m_60734_() && (be = level.m_7702_(pos)) instanceof SafeBlockEntity) {
            SafeBlockEntity safeBe = (SafeBlockEntity)be;
            if (((Boolean)SteelholdConfig.COMMON.dropContentsOnBreak.get()).booleanValue()) {
                for (int i = 0; i < safeBe.getItems().getSlots(); ++i) {
                    ItemStack stack = safeBe.getItems().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    safeBe.getItems().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && placer instanceof Player) {
            Player p = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                if (be.getOwner() == null) {
                    be.setOwner(p.m_20148_());
                }
                be.getSafeId();
            }
        }
    }

    public float m_7325_() {
        if (!((Boolean)SteelholdConfig.COMMON.explosionCanBreakSafes.get()).booleanValue()) {
            return 5000.0f;
        }
        return super.m_7325_();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            return;
        }
        if (pos.m_123342_() < level.m_141937_()) {
            return;
        }
        CompoundTag beTag = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockEntity) {
            SafeBlockEntity be = (SafeBlockEntity)blockEntity;
            beTag = be.m_187482_();
        }
        FALLING_POS.add(pos.m_121878_());
        FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
        if (beTag != null) {
            falling.f_31944_ = beTag;
        }
        FALLING_POS.remove(pos.m_121878_());
    }
}

