/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeAccess;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeTier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TallSafeBlock
extends Block
implements EntityBlock,
HasSafeTier {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private final SafeTier tier;

    public TallSafeBlock(SafeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public SafeTier getTier() {
        return this.tier;
    }

    private int requiredToolLevelFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Integer)c.basicToolLevel.get();
            case SafeTier.REINFORCED -> (Integer)c.reinforcedToolLevel.get();
            case SafeTier.STEELHOLD -> (Integer)c.steelholdToolLevel.get();
            case SafeTier.VAULT -> (Integer)c.vaultToolLevel.get();
            case SafeTier.BANK -> (Integer)c.bankToolLevel.get();
        };
    }

    private double hardnessFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicHardness.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedHardness.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdHardness.get();
            case SafeTier.VAULT -> (Double)c.vaultHardness.get();
            case SafeTier.BANK -> (Double)c.bankHardness.get();
        };
    }

    private double resistanceFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicResistance.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedResistance.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdResistance.get();
            case SafeTier.VAULT -> (Double)c.vaultResistance.get();
            case SafeTier.BANK -> (Double)c.bankResistance.get();
        };
    }

    private boolean hasRequiredPickaxe(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        ItemStack held = player.m_21205_();
        if (!held.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return false;
        }
        Item item = held.m_41720_();
        if (!(item instanceof TieredItem)) {
            return false;
        }
        TieredItem tool = (TieredItem)item;
        int toolLevel = tool.m_43314_().m_6604_();
        int required = this.requiredToolLevelFromConfig();
        return toolLevel >= required;
    }

    @Nullable
    public SafeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return new SafeBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (pos.m_123342_() >= level.m_151558_() - 1) {
            return null;
        }
        if (!level.m_8055_(pos.m_7494_()).m_60629_(ctx)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        BlockPos above = pos.m_7494_();
        level.m_7731_(above, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (placer instanceof Player) {
            Player p = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                if (be.getOwner() == null) {
                    be.setOwner(p.m_20148_());
                }
                be.getSafeId();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos basePos;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockEntity blockEntity = level.m_7702_(basePos);
        if (!(blockEntity instanceof SafeBlockEntity)) {
            return InteractionResult.CONSUME;
        }
        SafeBlockEntity be = (SafeBlockEntity)blockEntity;
        if (!SafeAccess.canOpen(level, basePos, player)) {
            String ownerName = be.getOwnerName(level);
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udd12 Locked. Owner: " + ownerName + " \u2014 you need a key.")), true);
            return InteractionResult.CONSUME;
        }
        NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)be, (BlockPos)basePos);
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity;
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            BlockPos otherPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
            BlockState otherState = level.m_8055_(otherPos);
            if (otherState.m_60734_() == this) {
                level.m_7471_(otherPos, false);
            }
            if (!level.f_46443_ && half == DoubleBlockHalf.LOWER && (blockEntity = level.m_7702_(pos)) instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                for (int i = 0; i < be.getItems().getSlots(); ++i) {
                    ItemStack stack = be.getItems().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    be.getItems().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!this.hasRequiredPickaxe(player)) {
            return 0.0f;
        }
        float hardness = (float)this.hardnessFromConfig();
        return hardness <= 0.0f ? 0.0f : super.m_5880_(state, player, level, pos) * (10.0f / hardness);
    }

    public float m_7325_() {
        return (float)this.resistanceFromConfig();
    }
}

