/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeAccess;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeTier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class WideTallSafeBlock
extends Block
implements EntityBlock,
HasSafeTier {
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final SafeTier tier;

    public WideTallSafeBlock(SafeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PART, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public SafeTier getTier() {
        return this.tier;
    }

    @Nullable
    public SafeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)PART) == 0 ? new SafeBlockEntity(pos, state) : null;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos origin = ctx.m_8083_();
        Level level = ctx.m_43725_();
        Direction facing = ctx.m_8125_().m_122424_();
        for (BlockPos p : WideTallSafeBlock.getAllPositions(origin, facing)) {
            if (p.m_123342_() >= level.m_151558_()) {
                return null;
            }
            if (level.m_8055_(p).m_60629_(ctx)) continue;
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PART, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)facing);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        List<BlockPos> positions = WideTallSafeBlock.getAllPositions(pos, facing);
        for (int part = 0; part < positions.size(); ++part) {
            BlockPos p = positions.get(part);
            if (p.equals((Object)pos)) continue;
            level.m_7731_(p, (BlockState)((BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(part))).m_61124_((Property)FACING, (Comparable)facing), 3);
        }
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                if (be.getOwner() == null) {
                    be.setOwner(player.m_20148_());
                }
                be.getSafeId();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos controllerPos = this.findControllerPos(level, pos);
        if (controllerPos == null) {
            return InteractionResult.CONSUME;
        }
        if (!SafeAccess.canOpen(level, controllerPos, player)) {
            String ownerName = "Unknown";
            BlockEntity blockEntity = level.m_7702_(controllerPos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                ownerName = be.getOwnerName(level);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udd12 Locked. Owner: " + ownerName + " \u2014 you need a key.")), true);
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(controllerPos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)provider, (BlockPos)controllerPos);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        Direction facing;
        BlockPos controllerPos;
        if (state.m_60734_() == newState.m_60734_()) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        if ((Integer)state.m_61143_((Property)PART) == 0) {
            controllerPos = pos;
            facing = (Direction)state.m_61143_((Property)FACING);
        } else {
            controllerPos = this.findControllerPos(level, pos);
            if (controllerPos == null) {
                super.m_6810_(state, level, pos, newState, movedByPiston);
                return;
            }
            BlockState controllerState = level.m_8055_(controllerPos);
            if (controllerState.m_60734_() != this) {
                super.m_6810_(state, level, pos, newState, movedByPiston);
                return;
            }
            facing = (Direction)controllerState.m_61143_((Property)FACING);
        }
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)PART) == 0 && ((Boolean)SteelholdConfig.COMMON.dropContentsOnBreak.get()).booleanValue() && (blockEntity = level.m_7702_(controllerPos)) instanceof SafeBlockEntity) {
            SafeBlockEntity be = (SafeBlockEntity)blockEntity;
            for (int i = 0; i < be.getItems().getSlots(); ++i) {
                ItemStack stack = be.getItems().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)controllerPos.m_123341_(), (double)controllerPos.m_123342_(), (double)controllerPos.m_123343_(), (ItemStack)stack);
                be.getItems().setStackInSlot(i, ItemStack.f_41583_);
            }
        }
        for (BlockPos p : WideTallSafeBlock.getAllPositions(controllerPos, facing)) {
            if (p.equals((Object)pos) || level.m_8055_(p).m_60734_() != this) continue;
            level.m_7471_(p, false);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING});
    }

    private static List<BlockPos> getAllPositions(BlockPos origin, Direction facing) {
        Direction right = facing.m_122428_();
        ArrayList<BlockPos> out = new ArrayList<BlockPos>(4);
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                out.add(origin.m_6630_(y).m_5484_(right, x));
            }
        }
        return out;
    }

    @Nullable
    private BlockPos findControllerPos(Level level, BlockPos clickedPos) {
        for (int dy = -1; dy <= 0; ++dy) {
            for (int dx = -1; dx <= 0; ++dx) {
                BlockPos candidate = clickedPos.m_7918_(dx, dy, 0);
                BlockState st = level.m_8055_(candidate);
                if (!(st.m_60734_() instanceof WideTallSafeBlock) || (Integer)st.m_61143_((Property)PART) != 0) continue;
                return candidate;
            }
        }
        for (BlockPos p : BlockPos.m_121940_((BlockPos)clickedPos.m_7918_(-1, -1, -1), (BlockPos)clickedPos.m_7918_(1, 1, 1))) {
            BlockState st = level.m_8055_(p);
            if (!(st.m_60734_() instanceof WideTallSafeBlock) || (Integer)st.m_61143_((Property)PART) != 0) continue;
            return p.m_7949_();
        }
        return null;
    }
}

