/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.capsawimtacticalgearrework.client.NVGKeyHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class NVGOverlayRenderer {
    private static final ResourceLocation NVG_OVERLAY = new ResourceLocation("caps_awim_tactical_gear_rework:textures/screens/nvg_overlay.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        if (!NVGOverlayRenderer.shouldRenderNVGOverlay(mc)) {
            return;
        }
        NVGOverlayRenderer.renderNVGOverlay(event.getGuiGraphics(), mc);
    }

    private static boolean shouldRenderNVGOverlay(Minecraft mc) {
        if (!NVGKeyHandler.isNVGActive()) {
            return false;
        }
        ItemStack helmet = mc.f_91074_.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41619_()) {
            NVGKeyHandler.setActive(false);
            return false;
        }
        boolean hasNVG = helmet.m_41784_().m_128471_("has_nvg");
        if (!hasNVG) {
            NVGKeyHandler.setActive(false);
            return false;
        }
        return true;
    }

    private static void renderNVGOverlay(GuiGraphics guiGraphics, Minecraft mc) {
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.7f, (float)0.0f, (float)0.7f);
        try {
            guiGraphics.m_280163_(NVG_OVERLAY, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        }
        catch (Exception e) {
            NVGOverlayRenderer.drawFallbackOverlay(guiGraphics, screenWidth, screenHeight);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawFallbackOverlay(GuiGraphics guiGraphics, int width, int height) {
        int color = 0x6600AA00;
        guiGraphics.m_280509_(0, 0, width, height, color);
        long time = System.currentTimeMillis() / 100L;
        for (int i = 0; i < 50; ++i) {
            int x = (int)((time + (long)(i * 73)) % (long)width);
            int y = (int)((time + (long)(i * 137)) % (long)height);
            int noiseColor = 0x22000000;
            guiGraphics.m_280509_(x, y, x + 1, y + 1, noiseColor);
        }
    }
}

