/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.capsawimtacticalgearrework.CapsAwimTacticalGearReworkMod;
import net.mcreator.capsawimtacticalgearrework.crafting.ArmorRecipes;
import net.mcreator.capsawimtacticalgearrework.crafting.CraftingRecipe;
import net.mcreator.capsawimtacticalgearrework.network.RepairArmorMessage;
import net.mcreator.capsawimtacticalgearrework.network.SelectRecipeMessage;
import net.mcreator.capsawimtacticalgearrework.network.SwitchToCustomizationMessage;
import net.mcreator.capsawimtacticalgearrework.world.inventory.ArmorCraftingMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArmorCraftingScreen
extends AbstractContainerScreen<ArmorCraftingMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("caps_awim_tactical_gear_rework:textures/screens/armor_crafting.png");
    private List<RecipeButton> recipeButtons = new ArrayList<RecipeButton>();
    private Button prevButton;
    private Button nextButton;
    private Button switchToCustomizationButton;
    private Button repairButton;
    private List<CraftingRecipe> allRecipes = new ArrayList<CraftingRecipe>();
    private int scrollOffset = 0;
    private final int RECIPES_PER_ROW = 6;
    private static final int RECIPE_ROW_Y = 20;
    private static final int RECIPE_BUTTON_SIZE = 20;
    private static final int RECIPE_BUTTON_SPACING = 2;
    private static final int RESULT_SLOT_X = 15;
    private static final int RESULT_SLOT_Y = 50;
    private static final int REPAIR_SLOT_X = 15;
    private static final int REPAIR_SLOT_Y = 86;
    private static final int RESOURCES_LEFT_X = 80;
    private static final int RESOURCES_RIGHT_X = 125;
    private static final int RESOURCES_Y = 45;
    private static final int REPAIR_COST_X = 40;
    private static final int REPAIR_COST_Y = 89;
    private static final int REPAIR_BUTTON_X = 15;
    private static final int REPAIR_BUTTON_Y = 106;
    private static final int REPAIR_BUTTON_WIDTH = 60;
    private static final int REPAIR_BUTTON_HEIGHT = 20;
    private static final int SWITCH_BUTTON_X = 175;
    private static final int SWITCH_BUTTON_Y = 5;
    private static final int SWITCH_BUTTON_WIDTH = 20;
    private static final int SWITCH_BUTTON_HEIGHT = 20;

    public ArmorCraftingScreen(ArmorCraftingMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 216;
        this.allRecipes = ArmorRecipes.getAllRecipes();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_7856_() {
        super.m_7856_();
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
            this.updateRecipeButtons();
        }).m_252987_(this.f_97735_ + 7, this.f_97736_ + 20, 15, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> {
            ++this.scrollOffset;
            this.updateRecipeButtons();
        }).m_252987_(this.f_97735_ + 155, this.f_97736_ + 20, 15, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.switchToCustomizationButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), button -> CapsAwimTacticalGearReworkMod.PACKET_HANDLER.sendToServer((Object)new SwitchToCustomizationMessage(((ArmorCraftingMenu)this.f_97732_).pos))).m_252987_(this.f_97735_ + 175, this.f_97736_ + 5, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.switchToCustomizationButton);
        this.repairButton = Button.m_253074_((Component)Component.m_237113_((String)"Repair"), button -> {
            if (((ArmorCraftingMenu)this.f_97732_).canRepair()) {
                CapsAwimTacticalGearReworkMod.PACKET_HANDLER.sendToServer((Object)new RepairArmorMessage(((ArmorCraftingMenu)this.f_97732_).pos));
            }
        }).m_252987_(this.f_97735_ + 15, this.f_97736_ + 106, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.repairButton);
        this.updateRecipeButtons();
        this.updateRepairButton();
    }

    private void updateRecipeButtons() {
        for (RecipeButton button : this.recipeButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        this.recipeButtons.clear();
        int startIndex = this.scrollOffset;
        int endIndex = Math.min(startIndex + 6, this.allRecipes.size());
        int firstButtonX = this.f_97735_ + 23;
        int buttonY = this.f_97736_ + 20;
        for (int i = startIndex; i < endIndex; ++i) {
            CraftingRecipe recipe = this.allRecipes.get(i);
            int buttonX = firstButtonX + (i - startIndex) * 22;
            RecipeButton button = new RecipeButton(buttonX, buttonY, 20, 20, recipe);
            this.recipeButtons.add(button);
            this.m_142416_((GuiEventListener)button);
        }
        this.prevButton.f_93624_ = this.scrollOffset > 0;
        this.nextButton.f_93624_ = endIndex < this.allRecipes.size();
    }

    private void updateRepairButton() {
        if (this.repairButton != null) {
            boolean canRepair;
            this.repairButton.f_93623_ = canRepair = ((ArmorCraftingMenu)this.f_97732_).canRepair();
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(GUI_TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        CraftingRecipe selected = ((ArmorCraftingMenu)this.f_97732_).getSelectedRecipe();
        if (selected != null) {
            this.renderRecipeInfo(guiGraphics, selected);
        }
        this.renderRepairInfo(guiGraphics);
    }

    private void renderRecipeInfo(GuiGraphics guiGraphics, CraftingRecipe recipe) {
        int resourceY = this.f_97736_ + 45 + 5;
        Inventory inventory = this.f_96541_.f_91074_.m_150109_();
        List<CraftingRecipe.IngredientEntry> ingredients = recipe.getIngredients();
        int half = (ingredients.size() + 1) / 2;
        for (int i = 0; i < ingredients.size(); ++i) {
            CraftingRecipe.IngredientEntry ingredient = ingredients.get(i);
            boolean hasEnough = ingredient.hasEnough(inventory);
            int color = hasEnough ? 0xFFFFFF : 0xFF5555;
            int resourceX = i < half ? this.f_97735_ + 80 : this.f_97735_ + 125;
            int currentY = resourceY + i % half * 16;
            guiGraphics.m_280480_(ingredient.getItem(), resourceX, currentY - 3);
            guiGraphics.m_280056_(this.f_96547_, "x" + ingredient.getCount(), resourceX + 18, currentY, color, false);
        }
    }

    private void renderRepairInfo(GuiGraphics guiGraphics) {
        ItemStack armorToRepair = ((ArmorCraftingMenu)this.f_97732_).getArmorToRepair();
        int repairCost = ((ArmorCraftingMenu)this.f_97732_).getRepairCost();
        if (!armorToRepair.m_41619_() && armorToRepair.m_41768_()) {
            int repairX = this.f_97735_ + 40;
            int repairY = this.f_97736_ + 89;
            guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42416_), repairX, repairY - 3);
            boolean hasResources = ((ArmorCraftingMenu)this.f_97732_).hasIronInInventory();
            int textColor = hasResources ? 0xFFFFFF : 0xFF5555;
            String costText = "x" + repairCost;
            guiGraphics.m_280056_(this.f_96547_, costText, repairX + 18, repairY, textColor, false);
        }
        this.updateRepairButton();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack armor;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.m_280137_(this.f_96547_, "Crafting and repairing armor", this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 5, 0xFFFFFF);
        if (this.switchToCustomizationButton.m_5953_((double)mouseX, (double)mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Go to customization"), mouseX, mouseY);
        }
        int repairSlotX = this.f_97735_ + 15;
        int repairSlotY = this.f_97736_ + 86;
        if (mouseX >= repairSlotX && mouseX < repairSlotX + 16 && mouseY >= repairSlotY && mouseY < repairSlotY + 16 && ((ArmorCraftingMenu)this.f_97732_).getArmorToRepair().m_41619_()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Place armor here for repair"), mouseX, mouseY);
        }
        if (!(armor = ((ArmorCraftingMenu)this.f_97732_).getArmorToRepair()).m_41619_() && armor.m_41768_()) {
            int costX = this.f_97735_ + 40;
            int costY = this.f_97736_ + 89;
            if (mouseX >= costX && mouseX < costX + 35 && mouseY >= costY - 3 && mouseY < costY + 13) {
                ArrayList<MutableComponent> tooltipComponents = new ArrayList<MutableComponent>();
                tooltipComponents.add(Component.m_237113_((String)"\u00a76Cost of repair"));
                tooltipComponents.add(Component.m_237113_((String)("Iron ingots: \u00a7e" + ((ArmorCraftingMenu)this.f_97732_).getRepairCost())));
                tooltipComponents.add(Component.m_237113_((String)""));
                tooltipComponents.add(Component.m_237113_((String)"\u00a77Price depends on:"));
                tooltipComponents.add(Component.m_237113_((String)"\u00a77- Armor material"));
                tooltipComponents.add(Component.m_237113_((String)"\u00a77- Wear levels"));
                tooltipComponents.add(Component.m_237113_((String)"\u00a77- Enchantments"));
                ArrayList formattedTooltip = new ArrayList();
                for (Component component : tooltipComponents) {
                    formattedTooltip.addAll(this.f_96547_.m_92923_((FormattedText)component, 200));
                }
                guiGraphics.m_280245_(this.f_96547_, formattedTooltip, mouseX, mouseY);
            }
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private class RecipeButton
    extends AbstractWidget {
        private final CraftingRecipe recipe;
        private boolean selected;

        public RecipeButton(int x, int y, int width, int height, CraftingRecipe recipe) {
            super(x, y, width, height, recipe.getResult().m_41786_());
            this.selected = false;
            this.recipe = recipe;
            this.selected = ((ArmorCraftingMenu)ArmorCraftingScreen.this.f_97732_).getSelectedRecipe() == recipe;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int color = this.selected ? -10066262 : -10066330;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, color);
            int borderColor = this.selected ? -7829300 : -7829368;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 1, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            ItemStack result = this.recipe.getResult();
            guiGraphics.m_280480_(result, this.m_252754_() + 2, this.m_252907_() + 2);
            boolean canCraft = this.recipe.canCraft(((ArmorCraftingScreen)ArmorCraftingScreen.this).f_96541_.f_91074_.m_150109_());
            if (canCraft) {
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 6, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 6, -11141291);
                guiGraphics.m_280056_(ArmorCraftingScreen.this.f_96547_, "\u2713", this.m_252754_() + this.f_93618_ - 5, this.m_252907_() + 1, -16777216, false);
            }
            if (this.m_5953_(mouseX, mouseY)) {
                guiGraphics.m_280557_(ArmorCraftingScreen.this.f_96547_, this.recipe.getResult().m_41786_(), mouseX, mouseY);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            for (RecipeButton button : ArmorCraftingScreen.this.recipeButtons) {
                button.selected = false;
            }
            this.selected = true;
            CapsAwimTacticalGearReworkMod.PACKET_HANDLER.sendToServer((Object)new SelectRecipeMessage(((ArmorCraftingMenu)((ArmorCraftingScreen)ArmorCraftingScreen.this).f_97732_).pos, this.recipe));
            ((ArmorCraftingMenu)ArmorCraftingScreen.this.f_97732_).selectRecipe(this.recipe);
        }

        protected void m_168797_(NarrationElementOutput output) {
            this.m_168802_(output);
        }
    }
}

