/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.capsawimtacticalgearrework.CapsAwimTacticalGearReworkMod;
import net.mcreator.capsawimtacticalgearrework.network.ApplyArmorStyleMessage;
import net.mcreator.capsawimtacticalgearrework.network.SwitchToCraftingMessage;
import net.mcreator.capsawimtacticalgearrework.world.inventory.ArmorCustomizationMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ArmorCustomizationScreen
extends AbstractContainerScreen<ArmorCustomizationMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("caps_awim_tactical_gear_rework:textures/screens/awd.png");
    private List<StyleButton> styleButtons = new ArrayList<StyleButton>();
    private int scrollOffset = 0;
    private Button scrollUpButton;
    private Button scrollDownButton;
    private Button applyButton;
    private int selectedStyleIndex = -1;
    private static final int LEFT_PANEL_X = 8;
    private static final int LEFT_PANEL_Y = 18;
    private static final int LEFT_PANEL_WIDTH = 70;
    private static final int LEFT_PANEL_HEIGHT = 54;
    private static final int CENTER_SLOT_X = 88;
    private static final int CENTER_SLOT_Y = 33;
    private static final int PREVIEW_PANEL_X = 130;
    private static final int PREVIEW_PANEL_Y = 18;
    private static final int PREVIEW_PANEL_WIDTH = 38;
    private static final int PREVIEW_PANEL_HEIGHT = 38;
    private static final int APPLY_BUTTON_X = 130;
    private static final int APPLY_BUTTON_Y = 60;
    private static final int APPLY_BUTTON_WIDTH = 38;
    private static final int APPLY_BUTTON_HEIGHT = 20;
    private int checkCounter = 0;
    private ItemStack lastArmorItem = ItemStack.f_41583_;
    private String[] lastAvailableStyles = new String[0];

    public ArmorCustomizationScreen(ArmorCustomizationMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    public void m_7856_() {
        super.m_7856_();
        this.scrollUpButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25b2"), button -> {
            if (this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            this.updateStyleButtons();
        }).m_252987_(this.f_97735_ + 8 + 70 - 12, this.f_97736_ + 18 + 2, 10, 10).m_253136_();
        this.scrollDownButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25bc"), button -> {
            ++this.scrollOffset;
            this.updateStyleButtons();
        }).m_252987_(this.f_97735_ + 8 + 70 - 12, this.f_97736_ + 18 + 54 - 12, 10, 10).m_253136_();
        this.m_142416_((GuiEventListener)this.scrollUpButton);
        this.m_142416_((GuiEventListener)this.scrollDownButton);
        this.applyButton = Button.m_253074_((Component)Component.m_237113_((String)"Apply"), button -> {
            if (this.selectedStyleIndex >= 0) {
                this.applySelectedStyle();
            }
        }).m_252987_(this.f_97735_ + 130, this.f_97736_ + 60, 38, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.applyButton);
        Button switchToCraftingButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2692"), button -> CapsAwimTacticalGearReworkMod.PACKET_HANDLER.sendToServer((Object)new SwitchToCraftingMessage(((ArmorCustomizationMenu)this.f_97732_).pos))).m_252987_(this.f_97735_ + 175, this.f_97736_ + 5, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)switchToCraftingButton);
        this.lastArmorItem = ((ArmorCustomizationMenu)this.f_97732_).getArmorItem().m_41777_();
        this.lastAvailableStyles = ((ArmorCustomizationMenu)this.f_97732_).getAvailableStyles();
        this.updateStyleButtons();
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.checkCounter;
        if (this.checkCounter >= 3) {
            this.checkCounter = 0;
            if (((ArmorCustomizationMenu)this.f_97732_).hasArmorChanged()) {
                boolean stylesChanged;
                ((ArmorCustomizationMenu)this.f_97732_).markAsUpdated();
                ItemStack currentArmor = ((ArmorCustomizationMenu)this.f_97732_).getArmorItem();
                String[] currentStyles = ((ArmorCustomizationMenu)this.f_97732_).getAvailableStyles();
                boolean armorChanged = !ItemStack.m_41728_((ItemStack)currentArmor, (ItemStack)this.lastArmorItem);
                boolean bl = stylesChanged = !this.arraysEqual(currentStyles, this.lastAvailableStyles);
                if (armorChanged || stylesChanged) {
                    this.lastArmorItem = currentArmor.m_41777_();
                    this.lastAvailableStyles = (String[])currentStyles.clone();
                    if (armorChanged) {
                        this.selectedStyleIndex = -1;
                        for (StyleButton button : this.styleButtons) {
                            button.selected = false;
                        }
                    }
                    this.updateStyleButtons();
                }
            }
        }
    }

    private boolean arraysEqual(String[] a1, String[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    private void updateStyleButtons() {
        int styleIndex;
        for (StyleButton button : this.styleButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        this.styleButtons.clear();
        String[] styles = ((ArmorCustomizationMenu)this.f_97732_).getAvailableStyles();
        ItemStack armor = ((ArmorCustomizationMenu)this.f_97732_).getArmorItem();
        if (styles.length == 0 || armor.m_41619_()) {
            this.scrollUpButton.f_93624_ = false;
            this.scrollDownButton.f_93624_ = false;
            this.applyButton.f_93624_ = false;
            this.selectedStyleIndex = -1;
            return;
        }
        this.scrollUpButton.f_93624_ = this.scrollOffset > 0;
        this.scrollDownButton.f_93624_ = this.scrollOffset + 3 < styles.length;
        this.applyButton.f_93624_ = true;
        int buttonY = this.f_97736_ + 18 + 5;
        int visibleCount = 3;
        int buttonHeight = 16;
        int buttonWidth = 55;
        for (int i = 0; i < Math.min(styles.length - this.scrollOffset, visibleCount) && (styleIndex = i + this.scrollOffset) < styles.length; ++i) {
            StyleButton button = new StyleButton(this.f_97735_ + 8 + 2, buttonY + i * buttonHeight, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)styles[styleIndex]), styleIndex);
            if (styleIndex == this.selectedStyleIndex) {
                button.selected = true;
            }
            this.styleButtons.add(button);
            this.m_142416_((GuiEventListener)button);
        }
        if (this.selectedStyleIndex >= styles.length) {
            this.selectedStyleIndex = -1;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(GUI_TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, 176, 166, 176, 166);
        guiGraphics.m_280509_(this.f_97735_ + 8, this.f_97736_ + 18, this.f_97735_ + 8 + 70, this.f_97736_ + 18 + 54, 0x22333333);
        guiGraphics.m_280509_(this.f_97735_ + 130, this.f_97736_ + 18, this.f_97735_ + 130 + 38, this.f_97736_ + 18 + 38, 0x22444444);
        guiGraphics.m_280509_(this.f_97735_ + 130, this.f_97736_ + 18, this.f_97735_ + 130 + 38, this.f_97736_ + 18 + 1, -10066330);
        guiGraphics.m_280509_(this.f_97735_ + 130, this.f_97736_ + 18, this.f_97735_ + 130 + 1, this.f_97736_ + 18 + 38, -10066330);
        guiGraphics.m_280509_(this.f_97735_ + 130 + 38 - 1, this.f_97736_ + 18, this.f_97735_ + 130 + 38, this.f_97736_ + 18 + 38, -10066330);
        guiGraphics.m_280509_(this.f_97735_ + 130, this.f_97736_ + 18 + 38 - 1, this.f_97735_ + 130 + 38, this.f_97736_ + 18 + 38, -10066330);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderRussianTitles(guiGraphics);
        if (this.selectedStyleIndex >= 0) {
            this.renderArmorPreview(guiGraphics);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderRussianTitles(GuiGraphics guiGraphics) {
        guiGraphics.m_280056_(this.f_96547_, "Styles:", this.f_97735_ + 8 + 5, this.f_97736_ + 18 - 10, 0xFFFFFF, false);
        guiGraphics.m_280056_(this.f_96547_, "Preview:", this.f_97735_ + 130 + 0, this.f_97736_ + 18 - 10, 0xFFFFFF, false);
    }

    private void renderArmorPreview(GuiGraphics guiGraphics) {
        String[] styles = ((ArmorCustomizationMenu)this.f_97732_).getAvailableStyles();
        if (this.selectedStyleIndex >= 0 && this.selectedStyleIndex < styles.length) {
            String protectionClass;
            String family;
            String newArmorId;
            String styleName = styles[this.selectedStyleIndex];
            ItemStack currentArmor = ((ArmorCustomizationMenu)this.f_97732_).getArmorItem();
            if (!currentArmor.m_41619_() && !(newArmorId = this.getArmorIdFromStyle(family = ((ArmorCustomizationMenu)this.f_97732_).getCurrentFamily(), protectionClass = ((ArmorCustomizationMenu)this.f_97732_).getCurrentProtectionClass(), this.selectedStyleIndex)).isEmpty()) {
                try {
                    ResourceLocation resource = new ResourceLocation("caps_awim_tactical_gear_rework", newArmorId + "_chestplate");
                    ItemStack previewArmor = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resource));
                    if (!previewArmor.m_41619_()) {
                        int iconX = this.f_97735_ + 130 + 11;
                        int iconY = this.f_97736_ + 18 + 8;
                        guiGraphics.m_280480_(previewArmor, iconX, iconY);
                        guiGraphics.m_280137_(this.f_96547_, styleName, this.f_97735_ + 130 + 19, this.f_97736_ + 18 + 38 - 10, 0xFFAA00);
                    }
                }
                catch (Exception e) {
                    guiGraphics.m_280137_(this.f_96547_, styleName, this.f_97735_ + 130 + 19, this.f_97736_ + 18 + 15, 0xFFAA00);
                }
            }
        }
    }

    private String getArmorIdFromStyle(String family, String protectionClass, int styleIndex) {
        if (family.equals("strelok") && protectionClass.equals("kz2")) {
            String[] variants = new String[]{"ak_1strelokfull", "ak_2_strelokfull", "mfouronestrelok", "mfourtwostrelok", "svdaronestrelok", "svdartwostrelok"};
            if (styleIndex >= 0 && styleIndex < variants.length) {
                return variants[styleIndex];
            }
        } else if (family.equals("strelok") && protectionClass.equals("kz1")) {
            String[] variants = new String[]{"kzoneakonestrelok", "kzoneaktwostrelok", "kzonesvdaronekbsgunslinger", "kzonesvdartwokbsstrelok", "kzmfouronekbsstrelok", "kzmfourtwokbsstrelok"};
            if (styleIndex >= 0 && styleIndex < variants.length) {
                return variants[styleIndex];
            }
        } else if (family.equals("morpeh") && protectionClass.equals("kz2")) {
            String[] variants = new String[]{"monemorpeh", "mtwomorpeh", "morpehakone", "aktwomorpeh", "svdaronemorpeh", "svdartwomorpeh"};
            if (styleIndex >= 0 && styleIndex < variants.length) {
                return variants[styleIndex];
            }
        } else if ((family.equals("morpeh") || family.equals("multicam")) && protectionClass.equals("kz1")) {
            String[] variants = new String[]{"kzmoneorpeh", "kzmtwomorpeh", "kzonemulticamakone", "kzonemulticamaktwo", "kzonemulticammone", "kzonemulticamsvdartwo"};
            if (styleIndex >= 0 && styleIndex < variants.length) {
                return variants[styleIndex];
            }
        }
        return "";
    }

    private void applySelectedStyle() {
        if (this.selectedStyleIndex >= 0 && !((ArmorCustomizationMenu)this.f_97732_).getArmorItem().m_41619_()) {
            try {
                CapsAwimTacticalGearReworkMod.PACKET_HANDLER.sendToServer((Object)new ApplyArmorStyleMessage(((ArmorCustomizationMenu)this.f_97732_).pos, this.selectedStyleIndex));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class StyleButton
    extends AbstractWidget {
        private final int styleIndex;
        private boolean selected;

        public StyleButton(int x, int y, int width, int height, Component message, int styleIndex) {
            super(x, y, width, height, message);
            this.selected = false;
            this.styleIndex = styleIndex;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int color = this.selected ? -10066262 : -10066330;
            int borderColor = this.selected ? -7829300 : -7829368;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, color);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 1, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            String text = this.m_6035_().getString();
            guiGraphics.m_280137_(ArmorCustomizationScreen.this.f_96547_, text, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, 0xFFFFFF);
        }

        public void m_5716_(double mouseX, double mouseY) {
            for (StyleButton button : ArmorCustomizationScreen.this.styleButtons) {
                button.selected = false;
            }
            this.selected = true;
            ArmorCustomizationScreen.this.selectedStyleIndex = this.styleIndex;
        }

        protected void m_168797_(NarrationElementOutput output) {
            this.m_168802_(output);
        }
    }
}

