/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.client.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public abstract class PlayerAnimatorCompatibleCurioRenderer
implements ICurioRenderer {
    private static final Map<String, Boolean> playerAnimatorAvailableCache = new HashMap<String, Boolean>();
    private static final Map<String, Method> playerAnimatorMethodsCache = new HashMap<String, Method>();

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        poseStack.m_85836_();
        if (this.isPlayerAnimatorInstalled() && slotContext.entity() instanceof Player) {
            this.applyPlayerAnimatorTransforms((Player)slotContext.entity(), poseStack, renderLayerParent);
        }
        this.customRender(stack, slotContext, poseStack, renderLayerParent, buffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        poseStack.m_85849_();
    }

    protected boolean isPlayerAnimatorInstalled() {
        String cacheKey = "playerAnimatorInstalled";
        if (!playerAnimatorAvailableCache.containsKey(cacheKey)) {
            try {
                Class.forName("dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry");
                playerAnimatorAvailableCache.put(cacheKey, true);
            }
            catch (ClassNotFoundException e) {
                playerAnimatorAvailableCache.put(cacheKey, false);
            }
        }
        return playerAnimatorAvailableCache.get(cacheKey);
    }

    protected <T extends LivingEntity, M extends EntityModel<T>> void applyPlayerAnimatorTransforms(Player player, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent) {
        EntityModel entityModel = renderLayerParent.m_7200_();
        if (entityModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)entityModel;
            try {
                AnimationData animData = this.getPlayerAnimationData(player);
                if (animData != null) {
                    this.applyBoneTransforms(humanoidModel, poseStack, animData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private AnimationData getPlayerAnimationData(Player player) throws Exception {
        Method getCurrentAnimationMethod;
        Object currentAnimation;
        Method getAnimatorMethod;
        Class<?> playerAnimatorAccess = Class.forName("dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess");
        String methodKey = "getPlayerAnimator";
        if (playerAnimatorMethodsCache.containsKey(methodKey)) {
            getAnimatorMethod = playerAnimatorMethodsCache.get(methodKey);
        } else {
            getAnimatorMethod = playerAnimatorAccess.getMethod("getPlayerAnimator", Player.class);
            playerAnimatorMethodsCache.put(methodKey, getAnimatorMethod);
        }
        Object playerAnimator = getAnimatorMethod.invoke(null, player);
        if (playerAnimator != null && (currentAnimation = (getCurrentAnimationMethod = playerAnimator.getClass().getMethod("getCurrentAnimation", new Class[0])).invoke(playerAnimator, new Object[0])) != null) {
            AnimationData data = new AnimationData();
            data.rightArmRotX = this.extractBoneRotation(currentAnimation, "rightArm", "x");
            data.rightArmRotY = this.extractBoneRotation(currentAnimation, "rightArm", "y");
            data.rightArmRotZ = this.extractBoneRotation(currentAnimation, "rightArm", "z");
            data.leftArmRotX = this.extractBoneRotation(currentAnimation, "leftArm", "x");
            data.leftArmRotY = this.extractBoneRotation(currentAnimation, "leftArm", "y");
            data.leftArmRotZ = this.extractBoneRotation(currentAnimation, "leftArm", "z");
            return data;
        }
        return null;
    }

    private float extractBoneRotation(Object animation, String boneName, String axis) throws Exception {
        try {
            Method getBoneMethod = animation.getClass().getMethod("getBone", String.class);
            Object bone = getBoneMethod.invoke(animation, boneName);
            if (bone != null) {
                Method getRotationMethod = bone.getClass().getMethod("get" + axis.toUpperCase() + "Rotation", new Class[0]);
                Object rotation = getRotationMethod.invoke(bone, new Object[0]);
                if (rotation instanceof Float) {
                    return ((Float)rotation).floatValue();
                }
                if (rotation instanceof Double) {
                    return ((Double)rotation).floatValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }

    private void applyBoneTransforms(HumanoidModel<?> model, PoseStack poseStack, AnimationData animData) {
        if (animData.rightArmRotX != 0.0f || animData.rightArmRotY != 0.0f || animData.rightArmRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102811_.m_104299_(poseStack);
            poseStack.m_252880_(0.0f, -0.375f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.rightArmRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.rightArmRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.rightArmRotZ));
            poseStack.m_85849_();
        }
        if (animData.leftArmRotX != 0.0f || animData.leftArmRotY != 0.0f || animData.leftArmRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102812_.m_104299_(poseStack);
            poseStack.m_252880_(0.0f, -0.375f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.leftArmRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.leftArmRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.leftArmRotZ));
            poseStack.m_85849_();
        }
        if (animData.rightLegRotX != 0.0f || animData.rightLegRotY != 0.0f || animData.rightLegRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102813_.m_104299_(poseStack);
            poseStack.m_252880_(0.0f, -0.75f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.rightLegRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.rightLegRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.rightLegRotZ));
            poseStack.m_85849_();
        }
        if (animData.leftLegRotX != 0.0f || animData.leftLegRotY != 0.0f || animData.leftLegRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102814_.m_104299_(poseStack);
            poseStack.m_252880_(0.0f, -0.75f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.leftLegRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.leftLegRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.leftLegRotZ));
            poseStack.m_85849_();
        }
        if (animData.bodyRotX != 0.0f || animData.bodyRotY != 0.0f || animData.bodyRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102810_.m_104299_(poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.bodyRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.bodyRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.bodyRotZ));
            poseStack.m_85849_();
        }
        if (animData.headRotX != 0.0f || animData.headRotY != 0.0f || animData.headRotZ != 0.0f) {
            poseStack.m_85836_();
            model.f_102808_.m_104299_(poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animData.headRotX));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animData.headRotY));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animData.headRotZ));
            poseStack.m_85849_();
        }
    }

    protected abstract <T extends LivingEntity, M extends EntityModel<T>> void customRender(ItemStack var1, SlotContext var2, PoseStack var3, RenderLayerParent<T, M> var4, MultiBufferSource var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12);

    private static class AnimationData {
        float rightArmRotX = 0.0f;
        float rightArmRotY = 0.0f;
        float rightArmRotZ = 0.0f;
        float leftArmRotX = 0.0f;
        float leftArmRotY = 0.0f;
        float leftArmRotZ = 0.0f;
        float rightLegRotX = 0.0f;
        float rightLegRotY = 0.0f;
        float rightLegRotZ = 0.0f;
        float leftLegRotX = 0.0f;
        float leftLegRotY = 0.0f;
        float leftLegRotZ = 0.0f;
        float bodyRotX = 0.0f;
        float bodyRotY = 0.0f;
        float bodyRotZ = 0.0f;
        float headRotX = 0.0f;
        float headRotY = 0.0f;
        float headRotZ = 0.0f;

        private AnimationData() {
        }
    }
}

