/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorWeightConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/tactical_gear_armor_weights.json");
    private static Map<String, Float> armorWeights = new HashMap<String, Float>();
    private static final Map<String, Float> DEFAULT_WEIGHTS;

    private static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, Float>>(){}.getType();
                Map<Object, Object> loaded = (Map<Object, Object>)GSON.fromJson((Reader)reader, type);
                armorWeights = loaded != null ? loaded : new HashMap<String, Float>(DEFAULT_WEIGHTS);
            }
            catch (IOException e) {
                System.err.println("[Tactical Gear] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430 \u0432\u0435\u0441\u043e\u0432: " + e.getMessage());
                armorWeights = new HashMap<String, Float>(DEFAULT_WEIGHTS);
                ArmorWeightConfig.saveConfig();
            }
        } else {
            armorWeights = new HashMap<String, Float>(DEFAULT_WEIGHTS);
            ArmorWeightConfig.saveConfig();
        }
    }

    private static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(armorWeights, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[Tactical Gear] \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0430 \u0432\u0435\u0441\u043e\u0432: " + e.getMessage());
        }
    }

    public static float getWeightForItem(String itemId) {
        String cleanId = itemId;
        if (itemId.contains(":")) {
            cleanId = itemId.substring(itemId.indexOf(":") + 1);
        }
        System.out.println("[CONFIG DEBUG] \u0418\u0449\u0435\u043c \u0432\u0435\u0441 \u0434\u043b\u044f: " + cleanId);
        if (armorWeights.containsKey(cleanId)) {
            float weight = armorWeights.get(cleanId).floatValue();
            System.out.println("[CONFIG DEBUG] \u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0442\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435! \u0412\u0435\u0441: " + weight * 100.0f + "%");
            return weight;
        }
        System.out.println("[CONFIG DEBUG] \u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0435\u0441\u0442\u044c \u043a\u043b\u044e\u0447\u0438:");
        boolean foundSimilar = false;
        for (String key : armorWeights.keySet()) {
            if (!key.contains("tarkov") && !cleanId.contains("tarkov")) continue;
            System.out.println("  - '" + key + "' = " + armorWeights.get(key).floatValue() * 100.0f + "%");
            foundSimilar = true;
        }
        if (!foundSimilar) {
            System.out.println("[CONFIG DEBUG] \u041d\u0435\u0442 \u043a\u043b\u044e\u0447\u0435\u0439 \u0441 'tarkov' \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435!");
        }
        return 0.0f;
    }

    public static float getWeightForItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (registryName != null) {
            return ArmorWeightConfig.getWeightForItem(registryName.toString());
        }
        return 0.0f;
    }

    public static void setWeightForItem(String itemId, float weight) {
        String cleanId = itemId;
        if (itemId.contains(":")) {
            cleanId = itemId.substring(itemId.indexOf(":") + 1);
        }
        armorWeights.put(cleanId, Float.valueOf(weight));
        ArmorWeightConfig.saveConfig();
    }

    public static Map<String, Float> getAllWeights() {
        return new HashMap<String, Float>(armorWeights);
    }

    public static void reloadConfig() {
        ArmorWeightConfig.loadConfig();
    }

    static {
        HashMap<String, Float> defaultWeights = new HashMap<String, Float>();
        defaultWeights.put("ak_1strelokfull_helmet", Float.valueOf(0.025f));
        defaultWeights.put("ak_2_strelokfull_helmet", Float.valueOf(0.025f));
        defaultWeights.put("svdaronestrelok_helmet", Float.valueOf(0.025f));
        defaultWeights.put("svdartwostrelok_helmet", Float.valueOf(0.025f));
        defaultWeights.put("morpehakone_helmet", Float.valueOf(0.025f));
        defaultWeights.put("aktwomorpeh_helmet", Float.valueOf(0.025f));
        defaultWeights.put("svdaronemorpeh_helmet", Float.valueOf(0.025f));
        defaultWeights.put("monemorpeh_helmet", Float.valueOf(0.025f));
        defaultWeights.put("blackspec_one_helmet", Float.valueOf(0.025f));
        defaultWeights.put("tarkovtwoone_helmet", Float.valueOf(0.025f));
        defaultWeights.put("russpecnazold_helmet", Float.valueOf(0.025f));
        defaultWeights.put("tarkov_f_ive_helmet", Float.valueOf(0.025f));
        defaultWeights.put("kzoneakonestrelok_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzoneaktwostrelok_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonesvdaronekbsgunslinger_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonesvdartwokbsstrelok_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonemulticamakone_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonemulticamaktwo_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonemulticammone_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonemulticamsvdartwo_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzonebundesfermone_helmet", Float.valueOf(0.015f));
        defaultWeights.put("tarkovone_helmet", Float.valueOf(0.015f));
        defaultWeights.put("tarkovtwo_helmet", Float.valueOf(0.015f));
        defaultWeights.put("tarkovfour_helmet", Float.valueOf(0.015f));
        defaultWeights.put("tarkovten_helmet", Float.valueOf(0.015f));
        defaultWeights.put("fsbalpha_helmet", Float.valueOf(0.015f));
        defaultWeights.put("goonknight_helmet", Float.valueOf(0.015f));
        defaultWeights.put("kzoneakonestrelok_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzoneaktwostrelok_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonesvdaronekbsgunslinger_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonesvdartwokbsstrelok_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzmfouronekbsstrelok_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzmfourtwokbsstrelok_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzmoneorpeh_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzmtwomorpeh_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonemulticamakone_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonemulticamaktwo_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonemulticammone_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonemulticamsvdartwo_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("kzonebundesfermone_chestplate", Float.valueOf(0.035f));
        defaultWeights.put("tarkovone_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("tarkovtwo_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("tarkovfour_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("tarkovten_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("fsbalpha_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("goonknight_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("tarkovnine_chestplate", Float.valueOf(0.015f));
        defaultWeights.put("ak_1strelokfull_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("ak_2_strelokfull_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("mfouronestrelok_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("mfourtwostrelok_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("svdaronestrelok_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("svdartwostrelok_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("monemorpeh_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("mtwomorpeh_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("morpehakone_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("aktwomorpeh_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("svdaronemorpeh_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("svdartwomorpeh_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("blackspec_one_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("tarkov_f_ive_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("tarkoveight_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("tarkovtwoone_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("russpecnazold_chestplate", Float.valueOf(0.05f));
        defaultWeights.put("ak_1strelokfull_leggings", Float.valueOf(0.015f));
        defaultWeights.put("morpehakone_leggings", Float.valueOf(0.015f));
        defaultWeights.put("blackspec_one_leggings", Float.valueOf(0.015f));
        defaultWeights.put("bootsone_boots", Float.valueOf(-0.015f));
        defaultWeights.put("tarkovtree", Float.valueOf(0.01f));
        defaultWeights.put("tarkovsix", Float.valueOf(0.01f));
        defaultWeights.put("tarkovseven", Float.valueOf(0.01f));
        DEFAULT_WEIGHTS = new HashMap<String, Float>(defaultWeights);
        ArmorWeightConfig.loadConfig();
    }
}

