/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CraftingRecipe {
    private final ItemStack result;
    private final List<IngredientEntry> ingredients;
    private final Map<String, Integer> stats;

    public CraftingRecipe(ItemStack result, List<IngredientEntry> ingredients) {
        this.result = result;
        this.ingredients = ingredients;
        this.stats = this.calculateStats(result);
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public List<IngredientEntry> getIngredients() {
        return new ArrayList<IngredientEntry>(this.ingredients);
    }

    public Map<String, Integer> getStats() {
        return new HashMap<String, Integer>(this.stats);
    }

    public boolean canCraft(Inventory inventory) {
        for (IngredientEntry ingredient : this.ingredients) {
            if (ingredient.hasEnough(inventory)) continue;
            return false;
        }
        return true;
    }

    public void consumeIngredients(Inventory inventory) {
        for (IngredientEntry ingredient : this.ingredients) {
            ingredient.consume(inventory);
        }
    }

    private Map<String, Integer> calculateStats(ItemStack armor) {
        LinkedHashMap<String, Integer> stats = new LinkedHashMap<String, Integer>();
        String armorId = armor.m_41720_().toString().toLowerCase();
        if (armorId.contains("kz2")) {
            stats.put("\u0417\u0430\u0449\u0438\u0442\u0430", 12);
            stats.put("\u041f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c", 450);
            stats.put("\u0412\u0435\u0441", 15);
        } else if (armorId.contains("kz1")) {
            stats.put("\u0417\u0430\u0449\u0438\u0442\u0430", 8);
            stats.put("\u041f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c", 300);
            stats.put("\u0412\u0435\u0441", 10);
        } else {
            stats.put("\u0417\u0430\u0449\u0438\u0442\u0430", 5);
            stats.put("\u041f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c", 200);
            stats.put("\u0412\u0435\u0441", 5);
        }
        return stats;
    }

    public static CraftingRecipe createRecipe(String resultId, Object ... ingredients) {
        ResourceLocation resource = new ResourceLocation("caps_awim_tactical_gear_rework", resultId);
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resource));
        ArrayList<IngredientEntry> ingredientList = new ArrayList<IngredientEntry>();
        for (int i = 0; i < ingredients.length; i += 2) {
            if (i + 1 >= ingredients.length) continue;
            ItemStack item = (ItemStack)ingredients[i];
            int count = (Integer)ingredients[i + 1];
            ingredientList.add(new IngredientEntry(item, count));
        }
        return new CraftingRecipe(result, ingredientList);
    }

    public static class IngredientEntry {
        private final ItemStack item;
        private final int count;

        public IngredientEntry(ItemStack item, int count) {
            this.item = item.m_41777_();
            this.count = count;
        }

        public ItemStack getItem() {
            return this.item.m_41777_();
        }

        public int getCount() {
            return this.count;
        }

        public boolean hasEnough(Inventory inventory) {
            int found = 0;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.item) || (found += stack.m_41613_()) < this.count) continue;
                return true;
            }
            return found >= this.count;
        }

        public void consume(Inventory inventory) {
            int remaining = this.count;
            for (int i = 0; i < inventory.m_6643_() && remaining > 0; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.item)) continue;
                int toTake = Math.min(stack.m_41613_(), remaining);
                stack.m_41774_(toTake);
                remaining -= toTake;
                if (!stack.m_41619_()) continue;
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }
}

