/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.integration.sound;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcreator.capsawimtacticalgearrework.CapsAwimTacticalGearReworkMod;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class GearSoundNetworkHandler {
    private static final Map<String, SoundEvent> SOUND_CACHE = new ConcurrentHashMap<String, SoundEvent>();

    @Nullable
    private static SoundEvent getCachedSound(String soundName) {
        SoundEvent cached = SOUND_CACHE.get(soundName);
        if (cached != null) {
            return cached;
        }
        ResourceLocation location = new ResourceLocation("caps_awim_tactical_gear_rework", soundName);
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location);
        SOUND_CACHE.put(soundName, sound);
        if (sound == null) {
            CapsAwimTacticalGearReworkMod.LOGGER.warn("Sound not found: {}", (Object)location);
        }
        return sound;
    }

    public static void clearSoundCache() {
        SOUND_CACHE.clear();
        CapsAwimTacticalGearReworkMod.LOGGER.info("Sound cache cleared");
    }

    public static void playSoundForAllPlayers(String soundName, double x, double y, double z, float volume, float pitch) {
        if (!FMLEnvironment.dist.isClient()) {
            CapsAwimTacticalGearReworkMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new PlayGearSoundPacket(soundName, x, y, z, volume, pitch));
        } else {
            SoundEvent sound;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null && (sound = GearSoundNetworkHandler.getCachedSound(soundName)) != null) {
                mc.f_91073_.m_6263_((Player)mc.f_91074_, x, y, z, sound, SoundSource.PLAYERS, volume, pitch);
            }
        }
    }

    public static void playSoundForPlayer(Player player, String soundName, double x, double y, double z, float volume, float pitch) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        double maxDistance = 16.0;
        CapsAwimTacticalGearReworkMod.PACKET_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, maxDistance, player.m_9236_().m_46472_())), (Object)new PlayGearSoundPacket(soundName, x, y, z, volume, pitch));
    }

    public static class PlayGearSoundPacket {
        private final String soundName;
        private final double x;
        private final double y;
        private final double z;
        private final float volume;
        private final float pitch;

        public PlayGearSoundPacket(String soundName, double x, double y, double z, float volume, float pitch) {
            this.soundName = soundName;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.pitch = pitch;
        }

        public static void encode(PlayGearSoundPacket msg, FriendlyByteBuf buffer) {
            buffer.m_130072_(msg.soundName, 50);
            buffer.writeDouble(msg.x);
            buffer.writeDouble(msg.y);
            buffer.writeDouble(msg.z);
            buffer.writeFloat(msg.volume);
            buffer.writeFloat(msg.pitch);
        }

        public static PlayGearSoundPacket decode(FriendlyByteBuf buffer) {
            return new PlayGearSoundPacket(buffer.m_130136_(50), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readFloat(), buffer.readFloat());
        }

        public static void handle(PlayGearSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null || mc.f_91074_ == null) {
                    return;
                }
                SoundEvent sound = GearSoundNetworkHandler.getCachedSound(msg.soundName);
                if (sound != null) {
                    mc.f_91073_.m_7785_(msg.x, msg.y, msg.z, sound, SoundSource.PLAYERS, msg.volume, msg.pitch, false);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

