/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.integration.sound;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.capsawimtacticalgearrework.integration.sound.GearSoundNetworkHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GearSoundSystem {
    private static final Map<UUID, PlayerSoundData> playerData = new ConcurrentHashMap<UUID, PlayerSoundData>();

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        PlayerSoundData data = GearSoundSystem.getOrCreateData(player);
        if (!data.hasArmor) {
            return;
        }
        if (data.armorSoundCooldown <= 0) {
            GearSoundSystem.playSound(player, "gear_jump_up", 0.5f, 0.9f);
            data.armorSoundCooldown = 10;
        }
        data.wasInAir = true;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null || event.player.m_213877_() || event.player.m_9236_() == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().m_5776_()) {
            GearSoundSystem.handleClientTick(event.player);
        } else {
            GearSoundSystem.handleServerTick(event.player);
        }
    }

    private static void handleServerTick(Player player) {
        PlayerSoundData data = GearSoundSystem.getOrCreateData(player);
        if (player.f_19797_ % 20 == 0) {
            data.hasArmor = GearSoundSystem.checkArmor(player);
        }
        if (!data.hasArmor) {
            return;
        }
        if (data.armorSoundCooldown > 0) {
            --data.armorSoundCooldown;
        }
        GearSoundSystem.handleLanding(player, data);
        GearSoundSystem.handleSteps(player, data);
    }

    private static void handleLanding(Player player, PlayerSoundData data) {
        boolean currentlyOnGround = player.m_20096_();
        if (data.wasInAir && currentlyOnGround && data.armorSoundCooldown <= 0) {
            GearSoundSystem.playSound(player, "gear_jump_land", 0.4f, 0.8f);
            data.armorSoundCooldown = 10;
        }
        data.wasInAir = !currentlyOnGround;
    }

    private static void handleSteps(Player player, PlayerSoundData data) {
        boolean isSneaking;
        double currentX = player.m_20185_();
        double currentZ = player.m_20189_();
        double dx = currentX - data.lastX;
        double dz = currentZ - data.lastZ;
        double distanceSq = dx * dx + dz * dz;
        data.updatePosition(currentX, currentZ);
        if (!player.m_20096_() || distanceSq < 1.0E-6) {
            return;
        }
        int currentTick = player.f_19797_;
        boolean isSprinting = player.m_20142_();
        int stepInterval = GearSoundSystem.getStepInterval(isSprinting, isSneaking = player.m_6047_());
        if (currentTick - data.lastStepTick > stepInterval && data.armorSoundCooldown <= 0) {
            String stepSound = GearSoundSystem.getStepSound(isSprinting, isSneaking);
            float volume = GearSoundSystem.getStepVolume(isSprinting, isSneaking);
            float pitch = data.stepSide == 0 ? 1.05f : 0.95f;
            GearSoundSystem.playSound(player, stepSound, volume, pitch);
            data.stepSide = data.stepSide == 0 ? 1 : 0;
            data.lastStepTick = currentTick;
            data.armorSoundCooldown = 3;
        }
    }

    private static String getStepSound(boolean isSprinting, boolean isSneaking) {
        if (isSneaking) {
            return "gear_step_quiet";
        }
        if (isSprinting) {
            return "gear_step_loud";
        }
        return "gear_step_normal";
    }

    private static float getStepVolume(boolean isSprinting, boolean isSneaking) {
        if (isSneaking) {
            return 0.2f;
        }
        if (isSprinting) {
            return 0.33f;
        }
        return 0.25f;
    }

    private static int getStepInterval(boolean isSprinting, boolean isSneaking) {
        if (isSneaking) {
            return 12;
        }
        if (isSprinting) {
            return 5;
        }
        return 8;
    }

    private static void playSound(Player player, String soundName, float volume, float pitch) {
        volume = Math.min(volume, 1.0f);
        GearSoundNetworkHandler.playSoundForPlayer(player, soundName, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), volume, pitch);
    }

    private static boolean checkArmor(Player player) {
        for (ItemStack armor : player.m_6168_()) {
            if (armor.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientTick(Player player) {
    }

    private static PlayerSoundData getOrCreateData(Player player) {
        return playerData.computeIfAbsent(player.m_20148_(), k -> new PlayerSoundData());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129921_() % 100 == 0) {
            playerData.entrySet().removeIf(entry -> event.getServer().m_6846_().m_11259_((UUID)entry.getKey()) == null);
        }
    }

    public static void playCustomSound(Player player, String soundName, float volume, float pitch) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        GearSoundSystem.playSound(player, soundName, volume, pitch);
    }

    public static boolean hasPlayerArmor(Player player) {
        PlayerSoundData data = playerData.get(player.m_20148_());
        return data != null && data.hasArmor;
    }

    private static class PlayerSoundData {
        int lastStepTick = 0;
        double lastX = 0.0;
        double lastZ = 0.0;
        boolean wasInAir = false;
        boolean hasArmor = false;
        int stepSide = 0;
        int armorSoundCooldown = 0;

        private PlayerSoundData() {
        }

        void updatePosition(double x, double z) {
            this.lastX = x;
            this.lastZ = z;
        }
    }
}

