/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.integration.weight;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.capsawimtacticalgearrework.config.ArmorWeightConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ArmorWeightSystem {
    private static final UUID WEIGHT_MODIFIER_UUID = UUID.fromString("123e4567-e89b-12d3-a456-426614174000");
    private static final String WEIGHT_MODIFIER_NAME = "tactical_gear_armor_weight";
    private static final Map<UUID, WeightCacheEntry> weightCache = new ConcurrentHashMap<UUID, WeightCacheEntry>();
    private static final boolean DEBUG = true;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_() || event.player == null) {
            return;
        }
        Player player = event.player;
        UUID playerId = player.m_20148_();
        int currentArmorHash = ArmorWeightSystem.quickArmorHash(player);
        WeightCacheEntry cached = weightCache.get(playerId);
        if (cached == null || cached.armorHash != currentArmorHash) {
            float totalWeight = ArmorWeightSystem.calculateTotalWeight(player);
            if (cached == null || Math.abs(cached.weight - totalWeight) > 0.001f) {
                ArmorWeightSystem.applyWeightEffect(player, totalWeight);
            }
            weightCache.put(playerId, new WeightCacheEntry(currentArmorHash, totalWeight));
        }
    }

    private static int quickArmorHash(Player player) {
        int hash = 1;
        for (ItemStack armor : player.m_6168_()) {
            hash = 31 * hash + System.identityHashCode(armor.m_41720_());
            if (armor.m_41619_()) continue;
            hash = 31 * hash + armor.m_41613_();
        }
        return hash;
    }

    private static float calculateTotalWeight(Player player) {
        float totalWeight = 0.0f;
        System.out.println("\n=== \u0420\u0410\u0421\u0427\u0415\u0422 \u0412\u0415\u0421\u0410 \u0414\u041b\u042f: " + player.m_7755_().getString() + " ===");
        for (ItemStack armor : player.m_6168_()) {
            ResourceLocation registryName;
            if (armor.m_41619_() || (registryName = ForgeRegistries.ITEMS.getKey((Object)armor.m_41720_())) == null) continue;
            String fullId = registryName.toString();
            String cleanId = registryName.m_135815_();
            System.out.println("\u041f\u0440\u0435\u0434\u043c\u0435\u0442: " + cleanId);
            float weight = ArmorWeightConfig.getWeightForItem(fullId);
            System.out.println("  \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0432\u0435\u0441: " + weight * 100.0f + "%");
            totalWeight += weight;
        }
        if (totalWeight > 0.0f) {
            System.out.println("\u0418\u0422\u041e\u0413\u041e: " + totalWeight * 100.0f + "%\n");
        }
        return Math.min(totalWeight, 0.15f);
    }

    private static void applyWeightEffect(Player player, float totalWeight) {
        AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
        if (movementSpeed == null) {
            return;
        }
        movementSpeed.m_22120_(WEIGHT_MODIFIER_UUID);
        if (totalWeight > 0.001f) {
            System.out.println("[DEBUG] \u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u043c \u0432\u0435\u0441 " + totalWeight * 100.0f + "% \u043a \u0438\u0433\u0440\u043e\u043a\u0443 " + player.m_7755_().getString());
        }
        if (totalWeight > 0.001f) {
            AttributeModifier weightModifier = new AttributeModifier(WEIGHT_MODIFIER_UUID, WEIGHT_MODIFIER_NAME, (double)(-totalWeight), AttributeModifier.Operation.MULTIPLY_TOTAL);
            movementSpeed.m_22125_(weightModifier);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        weightCache.remove(event.getEntity().m_20148_());
    }

    private static class WeightCacheEntry {
        final int armorHash;
        final float weight;

        WeightCacheEntry(int armorHash, float weight) {
            this.armorHash = armorHash;
            this.weight = weight;
        }
    }
}

