/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.item;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.capsawimtacticalgearrework.item.inventory.UniversalBackpackCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class BaseBackpackItem
extends Item
implements ICurioItem {
    private final int inventorySize;
    private final MenuCreator menuCreator;
    private final String displayName;

    public BaseBackpackItem(int inventorySize, MenuCreator menuCreator, String displayName) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
        this.inventorySize = inventorySize;
        this.menuCreator = menuCreator;
        this.displayName = displayName;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, final Player entity, final InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        ItemStack itemstack = (ItemStack)ar.m_19095_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)BaseBackpackItem.this.displayName);
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130064_(entity.m_20183_());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return BaseBackpackItem.this.menuCreator.create(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.m_130064_(entity.m_20183_());
                buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
            });
        }
        return ar;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag compound) {
        return new ICapabilitySerializable<CompoundTag>(){
            private UniversalBackpackCapability capability;

            private UniversalBackpackCapability getOrCreateCapability() {
                if (this.capability == null) {
                    if (stack.m_41782_() && stack.m_41783_().m_128441_("BackpackData")) {
                        CompoundTag savedData = stack.m_41783_().m_128469_("BackpackData");
                        this.capability = new UniversalBackpackCapability(BaseBackpackItem.this.getInventorySize());
                        this.capability.deserializeNBT(savedData);
                    } else {
                        this.capability = UniversalBackpackCapability.createForItem(stack, BaseBackpackItem.this.getInventorySize());
                    }
                }
                return this.capability;
            }

            private ItemStackHandler getItemHandler() {
                return this.getOrCreateCapability().getItemHandler();
            }

            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    return LazyOptional.of(this::getItemHandler).cast();
                }
                return LazyOptional.empty();
            }

            public CompoundTag serializeNBT() {
                UniversalBackpackCapability cap = this.getOrCreateCapability();
                CompoundTag nbt = cap.serializeNBT();
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128365_("BackpackData", (Tag)nbt.m_6426_());
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                UniversalBackpackCapability cap = this.getOrCreateCapability();
                cap.deserializeNBT(nbt);
            }
        };
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        CompoundTag backpackData = new CompoundTag();
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (handler instanceof UniversalBackpackCapability) {
                UniversalBackpackCapability backpackHandler = (UniversalBackpackCapability)handler;
                CompoundTag handlerNbt = backpackHandler.serializeNBT();
                for (String key : handlerNbt.m_128431_()) {
                    backpackData.m_128365_(key, handlerNbt.m_128423_(key).m_6426_());
                }
            }
        });
        for (String key : backpackData.m_128431_()) {
            nbt.m_128365_(key, backpackData.m_128423_(key).m_6426_());
        }
        nbt.m_128365_("BackpackData", (Tag)backpackData);
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.m_128441_("BackpackData")) {
            CompoundTag backpackData = nbt.m_128469_("BackpackData");
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof UniversalBackpackCapability) {
                    UniversalBackpackCapability backpackHandler = (UniversalBackpackCapability)handler;
                    backpackHandler.deserializeNBT(backpackData);
                }
            });
        }
    }

    public static void saveBackpackData(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BaseBackpackItem) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof UniversalBackpackCapability) {
                    UniversalBackpackCapability backpackHandler = (UniversalBackpackCapability)handler;
                    CompoundTag backpackNbt = backpackHandler.serializeNBT();
                    if (!stack.m_41782_()) {
                        stack.m_41751_(new CompoundTag());
                    }
                    stack.m_41783_().m_128365_("BackpackData", (Tag)backpackNbt);
                }
            });
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!prevStack.m_41619_() && prevStack.m_41720_() instanceof BaseBackpackItem) {
            BaseBackpackItem.saveBackpackData(prevStack);
        }
        BaseBackpackItem.saveBackpackData(stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        BaseBackpackItem.saveBackpackData(stack);
    }

    @FunctionalInterface
    public static interface MenuCreator {
        public AbstractContainerMenu create(int var1, Inventory var2, FriendlyByteBuf var3);
    }
}

