/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.item.inventory;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.capsawimtacticalgearrework.client.gui.InventorygreentacticalbackpackScreen;
import net.mcreator.capsawimtacticalgearrework.client.gui.InventorygreentacticalmediumbackpackScreen;
import net.mcreator.capsawimtacticalgearrework.init.CapsAwimTacticalGearReworkModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class UniversalBackpackCapability
implements ICapabilitySerializable<CompoundTag> {
    private final int inventorySize;
    private final LazyOptional<ItemStackHandler> inventory;
    private static final String INVENTORY_KEY = "BackpackInventory";
    private static final String SIZE_KEY = "BackpackSize";
    private static Set<Item> forbiddenItems = null;

    private static synchronized Set<Item> getForbiddenItems() {
        if (forbiddenItems == null) {
            forbiddenItems = new HashSet<Item>();
            try {
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.GREENTACTICALBACKPACK.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.BLACKTACTICALBACKPACK.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.SPORTSBAG.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.GREENHIKINGBACKPACK.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.MULTICAMHIKINGBACKPACK.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.URBANAHIKINGBACKPACK.get());
                forbiddenItems.add((Item)CapsAwimTacticalGearReworkModItems.BLACKHIKINGBACKPACK.get());
            }
            catch (Exception e) {
                System.err.println("Warning: Could not initialize backpack forbidden items: " + e.getMessage());
            }
        }
        return forbiddenItems;
    }

    private static boolean isBackpackItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        try {
            Item item = stack.m_41720_();
            String itemId = item.getCreatorModId(stack);
            if ("caps_awim_tactical_gear_rework".equals(itemId)) {
                String itemName = item.toString().toLowerCase();
                return itemName.contains("backpack") || itemName.contains("sportsbag");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public UniversalBackpackCapability(int size) {
        this.inventorySize = size;
        this.inventory = LazyOptional.of(this::createItemHandler);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemDropped(ItemTossEvent event) {
        ItemStack droppedItem = event.getEntity().m_32055_();
        if (UniversalBackpackCapability.isBackpackItem(droppedItem)) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof InventorygreentacticalmediumbackpackScreen || mc.f_91080_ instanceof InventorygreentacticalbackpackScreen) {
                mc.f_91074_.m_6915_();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return capability == ForgeCapabilities.ITEM_HANDLER ? this.inventory.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(SIZE_KEY, this.inventorySize);
        CompoundTag inventoryNBT = this.getItemHandler().serializeNBT();
        nbt.m_128365_(INVENTORY_KEY, (Tag)inventoryNBT);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_(INVENTORY_KEY, 10)) {
            this.getItemHandler().deserializeNBT(nbt.m_128469_(INVENTORY_KEY));
        }
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this.inventorySize){

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !UniversalBackpackCapability.isBackpackItem(stack);
            }

            public void setSize(int size) {
            }

            public void deserializeNBT(CompoundTag nbt) {
                try {
                    if (nbt.m_128425_("Items", 9)) {
                        ListTag tagList = nbt.m_128437_("Items", 10);
                        for (int i = 0; i < Math.min(tagList.size(), this.stacks.size()); ++i) {
                            CompoundTag itemTags = tagList.m_128728_(i);
                            int slot = itemTags.m_128451_("Slot");
                            if (slot < 0 || slot >= this.stacks.size()) continue;
                            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
                        }
                        this.onLoad();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error loading backpack inventory: " + e.getMessage());
                }
            }

            public CompoundTag serializeNBT() {
                ListTag nbtTagList = new ListTag();
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.m_128405_("Slot", i);
                    ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
                    nbtTagList.add((Object)itemTag);
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Items", (Tag)nbtTagList);
                nbt.m_128405_("Size", this.stacks.size());
                return nbt;
            }
        };
    }

    public ItemStackHandler getItemHandler() {
        return (ItemStackHandler)this.inventory.orElseThrow(() -> new RuntimeException("Item handler not available"));
    }

    public static UniversalBackpackCapability createForItem(ItemStack stack, int defaultSize) {
        CompoundTag itemNBT;
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if ((itemNBT = stack.m_41783_()).m_128441_(SIZE_KEY)) {
            int savedSize = itemNBT.m_128451_(SIZE_KEY);
            UniversalBackpackCapability capability = new UniversalBackpackCapability(savedSize);
            if (itemNBT.m_128441_(INVENTORY_KEY)) {
                capability.deserializeNBT(itemNBT);
            }
            return capability;
        }
        itemNBT.m_128405_(SIZE_KEY, defaultSize);
        return new UniversalBackpackCapability(defaultSize);
    }

    public static void saveToItemStack(ItemStack stack, UniversalBackpackCapability capability) {
        if (capability != null) {
            CompoundTag capabilityNBT = capability.serializeNBT();
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag itemNBT = stack.m_41783_();
            itemNBT.m_128405_(SIZE_KEY, capability.inventorySize);
            itemNBT.m_128365_(INVENTORY_KEY, (Tag)capabilityNBT.m_128469_(INVENTORY_KEY));
        }
    }
}

