#version 150

uniform sampler2D DiffuseSampler;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 color = texture(DiffuseSampler, texCoord);

    // Desaturate
    float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));
    vec3 desat = mix(color.rgb, vec3(gray), 0.6);

    // Cold blue tint
    desat *= vec3(0.55, 0.60, 0.75);

    // Fog / cloudiness from top
    float fog = smoothstep(0.2, 0.9, texCoord.y);
    desat = mix(desat, vec3(0.08, 0.08, 0.12), fog * 0.45);

    // Vignette
    float dist = distance(texCoord, vec2(0.5));
    desat *= smoothstep(0.9, 0.45, dist);

    fragColor = vec4(desat, color.a);
}
