/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.blocks;

import io.github.arkosammy12.creeperhealing.blocks.DoubleAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface AffectedBlock {
    public class_2338 getBlockPos();

    public class_2680 getBlockState();

    public class_5321<class_1937> getWorldRegistryKey();

    public class_3218 getWorld(MinecraftServer var1);

    public long getBlockTimer();

    public void tick(ExplosionEvent var1, MinecraftServer var2);

    public void setPlaced();

    public boolean isPlaced();

    public boolean canBePlaced(MinecraftServer var1);

    public SerializedAffectedBlock asSerialized();

    public static AffectedBlock newInstance(class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1937 world) {
        class_5321 worldRegistryKey = world.method_27983();
        long blockPlacementDelay = ConfigUtils.getBlockPlacementDelay();
        boolean restoreBlockNbt = ConfigUtils.getRawBooleanSetting(ConfigUtils.RESTORE_BLOCK_NBT);
        if (blockEntity != null && restoreBlockNbt) {
            return new SingleAffectedBlock(pos, state, (class_5321<class_1937>)worldRegistryKey, blockEntity.method_38242((class_7225.class_7874)world.method_30349()), blockPlacementDelay, false);
        }
        return new SingleAffectedBlock(pos, state, (class_5321<class_1937>)worldRegistryKey, null, blockPlacementDelay, false);
    }

    public static AffectedBlock newInstance(class_2338 firstHalfPos, class_2680 firstHalfState, @Nullable class_2586 firstHalfBlockEntity, class_2338 secondHalfPos, @Nullable class_2680 secondHalfState, @Nullable class_2586 secondHalfBlockEntity, class_1937 world) {
        class_5321 worldRegistryKey = world.method_27983();
        long blockPlacementDelay = ConfigUtils.getBlockPlacementDelay();
        boolean restoreBlockNbt = ConfigUtils.getRawBooleanSetting(ConfigUtils.RESTORE_BLOCK_NBT);
        if (firstHalfBlockEntity != null && secondHalfBlockEntity != null && restoreBlockNbt) {
            return new DoubleAffectedBlock(firstHalfPos, firstHalfState, firstHalfBlockEntity.method_38242((class_7225.class_7874)world.method_30349()), secondHalfPos, secondHalfState, secondHalfBlockEntity.method_38242((class_7225.class_7874)world.method_30349()), (class_5321<class_1937>)worldRegistryKey, blockPlacementDelay, false);
        }
        return new DoubleAffectedBlock(firstHalfPos, firstHalfState, null, secondHalfPos, secondHalfState, null, (class_5321<class_1937>)worldRegistryKey, blockPlacementDelay, false);
    }
}

