/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.managers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.arkosammy12.creeperhealing.CreeperHealing;
import io.github.arkosammy12.creeperhealing.blocks.AffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.AbstractExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.SerializedExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.factories.DefaultExplosionFactory;
import io.github.arkosammy12.creeperhealing.explosions.factories.ExplosionEventFactory;
import io.github.arkosammy12.creeperhealing.managers.ExplosionManager;
import io.github.arkosammy12.creeperhealing.util.ExplosionContext;
import io.github.arkosammy12.creeperhealing.util.ExplosionUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class DefaultExplosionManager
implements ExplosionManager {
    public static final class_2960 ID = class_2960.method_60655((String)"creeperhealing", (String)"default_explosion_manager");
    private static final Function<ExplosionContext, ExplosionEventFactory<?>> explosionContextToFactoryFunction = explosionContext -> {
        List<class_2338> indirectlyExplodedPositions = explosionContext.indirectlyAffectedPositions();
        Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities = explosionContext.affectedStatesAndBlockEntities();
        DefaultExplosionFactory explosionFactory = new DefaultExplosionFactory(affectedStatesAndBlockEntities, explosionContext.vanillaAffectedPositions(), indirectlyExplodedPositions, explosionContext.world());
        return explosionFactory;
    };
    private static final String SCHEDULED_EXPLOSIONS_FILE = "scheduled-explosions.json";
    private final Codec<DefaultExplosionManager> codec;
    private final List<ExplosionEvent> explosionEvents = new ArrayList<ExplosionEvent>();

    @Override
    public class_2960 getId() {
        return ID;
    }

    public DefaultExplosionManager(Codec<SerializedExplosionEvent> explosionSerializer) {
        this.codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)explosionSerializer).fieldOf("scheduled_explosions").forGetter(DefaultExplosionManager::getSerializedExplosionEvents)).apply((Applicative)instance, serializedExplosionEvents -> new DefaultExplosionManager((List<SerializedExplosionEvent>)serializedExplosionEvents, explosionSerializer)));
    }

    private DefaultExplosionManager(List<SerializedExplosionEvent> serializedExplosionEvents, Codec<SerializedExplosionEvent> explosionSerializer) {
        this(explosionSerializer);
        this.explosionEvents.addAll(serializedExplosionEvents.stream().map(SerializedExplosionEvent::asDeserialized).toList());
    }

    private List<SerializedExplosionEvent> getSerializedExplosionEvents() {
        return this.explosionEvents.stream().map(ExplosionEvent::asSerialized).collect(Collectors.toList());
    }

    @Override
    public Stream<ExplosionEvent> getExplosionEvents() {
        return this.explosionEvents.stream();
    }

    @Override
    public void onServerStarting(MinecraftServer server) {
        this.readExplosionEvents(server);
        this.updateAffectedBlocksTimers();
    }

    @Override
    public void onServerStopping(MinecraftServer server) {
        this.storeExplosionEvents(server);
        this.explosionEvents.clear();
    }

    @Override
    public Function<ExplosionContext, ExplosionEventFactory<?>> getExplosionContextToEventFactoryFunction() {
        return explosionContextToFactoryFunction;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.explosionEvents.isEmpty() || !server.method_54833().method_54751()) {
            return;
        }
        for (ExplosionEvent explosionEvent : this.explosionEvents) {
            explosionEvent.tick(server);
        }
        this.explosionEvents.removeIf(ExplosionEvent::isFinished);
    }

    @Override
    public <T extends ExplosionEvent> void addExplosionEvent(ExplosionEventFactory<T> explosionEventFactory) {
        T explosionEvent = explosionEventFactory.createExplosionEvent();
        if (explosionEvent == null) {
            return;
        }
        Set<ExplosionEvent> collidingExplosions = this.getCollidingExplosions((ExplosionEvent)explosionEvent, explosionEventFactory.getAffectedPositions());
        if (collidingExplosions.isEmpty()) {
            this.explosionEvents.add((ExplosionEvent)explosionEvent);
        } else {
            this.explosionEvents.removeIf(collidingExplosions::contains);
            collidingExplosions.add((ExplosionEvent)explosionEvent);
            this.explosionEvents.add(this.combineCollidingExplosions((ExplosionEvent)explosionEvent, collidingExplosions, explosionEventFactory));
        }
    }

    @Override
    public void storeExplosionEvents(MinecraftServer server) {
        Path savedExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve(SCHEDULED_EXPLOSIONS_FILE);
        DataResult encodedExplosions = this.codec.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.COMPRESSED), (Object)this);
        if (encodedExplosions.isError()) {
            CreeperHealing.LOGGER.error("Error storing creeper healing explosion(s): No value present!");
            return;
        }
        JsonElement encodedExplosionsJson = (JsonElement)encodedExplosions.getPartialOrThrow();
        Gson gson = new Gson();
        String jsonString = gson.toJson(encodedExplosionsJson);
        try (BufferedWriter bf = Files.newBufferedWriter(savedExplosionsFilePath, new OpenOption[0]);){
            bf.write(jsonString);
            CreeperHealing.LOGGER.info("Stored {} explosion event(s) to {}: ", (Object)this.explosionEvents.size(), (Object)savedExplosionsFilePath);
        }
        catch (Exception e) {
            CreeperHealing.LOGGER.error("Error storing explosion event(s): {}", (Object)e.toString());
        }
    }

    @Override
    public void readExplosionEvents(MinecraftServer server) {
        Path savedExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve(SCHEDULED_EXPLOSIONS_FILE);
        try {
            if (!Files.exists(savedExplosionsFilePath, new LinkOption[0])) {
                CreeperHealing.LOGGER.warn("Scheduled explosions file not found! Creating new one at {}", (Object)savedExplosionsFilePath);
                Files.createFile(savedExplosionsFilePath, new FileAttribute[0]);
                return;
            }
            try (BufferedReader br = Files.newBufferedReader(savedExplosionsFilePath);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)br);
                DataResult decodedExplosionManager = this.codec.parse((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.COMPRESSED), (Object)jsonElement);
                decodedExplosionManager.resultOrPartial(error -> CreeperHealing.LOGGER.error("Error reading scheduled explosions from file {}: {}", (Object)savedExplosionsFilePath, error)).ifPresent(decodedManager -> {
                    this.explosionEvents.addAll(decodedManager.explosionEvents);
                    CreeperHealing.LOGGER.info("Rescheduled {} explosion event(s)", (Object)decodedManager.explosionEvents.size());
                });
            }
        }
        catch (Exception e) {
            CreeperHealing.LOGGER.error("Error reading scheduled explosions from file {}: {}", (Object)savedExplosionsFilePath, (Object)e.toString());
        }
    }

    private Set<ExplosionEvent> getCollidingExplosions(ExplosionEvent newExplosionEvent, List<class_2338> affectedPositions) {
        int newExplosionRadius;
        class_2338 newExplosionCenter;
        LinkedHashSet<ExplosionEvent> collidingExplosions = new LinkedHashSet<ExplosionEvent>();
        if (newExplosionEvent instanceof AbstractExplosionEvent) {
            AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)newExplosionEvent;
            newExplosionCenter = abstractExplosionEvent.getCenter();
            newExplosionRadius = abstractExplosionEvent.getRadius();
        } else {
            newExplosionRadius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
            newExplosionCenter = ExplosionUtils.calculateCenter(affectedPositions);
        }
        for (ExplosionEvent explosionEvent : this.explosionEvents) {
            int currentExplosionRadius;
            class_2338 currentExplosionCenter;
            boolean hasStartedHealing = explosionEvent.getHealTimer() <= 0L;
            if (hasStartedHealing) continue;
            if (explosionEvent instanceof AbstractExplosionEvent) {
                AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)explosionEvent;
                currentExplosionCenter = abstractExplosionEvent.getCenter();
                currentExplosionRadius = abstractExplosionEvent.getRadius();
            } else {
                List<class_2338> currentAffectedPositions = explosionEvent.getAffectedBlocks().map(AffectedBlock::getBlockPos).toList();
                currentExplosionRadius = ExplosionUtils.getMaxExplosionRadius(currentAffectedPositions);
                currentExplosionCenter = ExplosionUtils.calculateCenter(currentAffectedPositions);
            }
            int combinedRadius = newExplosionRadius + currentExplosionRadius;
            double distanceBetweenCenters = Math.floor(Math.sqrt(newExplosionCenter.method_10262((class_2382)currentExplosionCenter)));
            if (!(distanceBetweenCenters <= (double)combinedRadius)) continue;
            collidingExplosions.add(explosionEvent);
        }
        return collidingExplosions;
    }

    private ExplosionEvent combineCollidingExplosions(ExplosionEvent newestExplosion, Set<ExplosionEvent> collidingExplosions, ExplosionEventFactory<?> explosionEventFactory) {
        List<AffectedBlock> combinedAffectedBlocks = collidingExplosions.stream().flatMap(ExplosionEvent::getAffectedBlocks).collect(Collectors.toList());
        Object combinedExplosionEvent = explosionEventFactory.createExplosionEvent(combinedAffectedBlocks, newestExplosion.getHealTimer(), ConfigUtils.getBlockPlacementDelay());
        return combinedExplosionEvent;
    }

    public void updateAffectedBlocksTimers() {
        for (ExplosionEvent explosionEvent : this.explosionEvents) {
            if (!(explosionEvent instanceof AbstractExplosionEvent)) continue;
            AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)explosionEvent;
            List<AffectedBlock> affectedBlocks = explosionEvent.getAffectedBlocks().toList();
            for (int i = abstractExplosionEvent.getBlockCounter() + 1; i < affectedBlocks.size(); ++i) {
                AffectedBlock currentAffectedBlock = affectedBlocks.get(i);
                if (!(currentAffectedBlock instanceof SingleAffectedBlock)) continue;
                SingleAffectedBlock singleAffectedBlock = (SingleAffectedBlock)currentAffectedBlock;
                singleAffectedBlock.setTimer(ConfigUtils.getBlockPlacementDelay());
            }
        }
    }
}

