/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.arkosammy12.creeperhealing.ExplosionManagerRegistrar;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.ducks.ExplosionImplDuck;
import io.github.arkosammy12.creeperhealing.explosions.ducks.ServerWorldDuck;
import io.github.arkosammy12.creeperhealing.managers.DefaultExplosionManager;
import io.github.arkosammy12.creeperhealing.util.EmptyWorld;
import io.github.arkosammy12.creeperhealing.util.ExcludedBlocks;
import io.github.arkosammy12.creeperhealing.util.ExplosionContext;
import io.github.arkosammy12.creeperhealing.util.ExplosionUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import net.minecraft.class_9892;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_9892.class})
public abstract class ExplosionImplMixin
implements class_1927,
ExplosionImplDuck {
    @Unique
    @Nullable
    private class_1937.class_7867 explosionSourceType = null;
    @Unique
    private final Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities = new HashMap<class_2338, class_3545<class_2680, class_2586>>();
    @Unique
    private final Set<class_2338> vanillaAffectedPositions = new HashSet<class_2338>();
    @Unique
    private final Set<class_2338> indirectlyAffectedPositions = new HashSet<class_2338>();

    @Shadow
    @Nullable
    public abstract class_1297 method_46406();

    @Shadow
    @Nullable
    public abstract class_1309 method_8347();

    @Shadow
    public abstract class_3218 method_64504();

    @Override
    public void creeperhealing$setExplosionSourceType(class_1937.class_7867 explosionSourceType) {
        this.explosionSourceType = explosionSourceType;
    }

    @Override
    public class_1937.class_7867 creeperhealing$getExplosionSourceType() {
        return this.explosionSourceType;
    }

    @Override
    public boolean creeperhealing$shouldHeal() {
        class_1937.class_7867 explosionSourceType;
        if (this.method_64504().method_8608()) {
            return false;
        }
        if (this.vanillaAffectedPositions.isEmpty()) {
            return false;
        }
        class_1937.class_7867 class_78672 = explosionSourceType = this.explosionSourceType;
        int n = 0;
        boolean shouldHeal = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MOB", "BLOCK", "TNT", "TRIGGER"}, (class_1937.class_7867)class_78672, n)) {
            case 0 -> {
                if (!ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_MOB_EXPLOSIONS)) {
                    yield false;
                }
                class_1309 causingEntity = this.method_8347();
                if (causingEntity == null) {
                    yield true;
                }
                String entityId = class_7923.field_41177.method_10221((Object)causingEntity.method_5864()).toString();
                List<? extends String> healMobExplosionsBlacklist = ConfigUtils.getRawStringListSetting(ConfigUtils.HEAL_MOB_EXPLOSIONS_BLACKLIST);
                if (!healMobExplosionsBlacklist.contains(entityId)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_BLOCK_EXPLOSIONS);
            case 2 -> ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_TNT_EXPLOSIONS);
            case 3 -> ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_TRIGGERED_EXPLOSIONS);
            default -> ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_OTHER_EXPLOSIONS);
        };
        return shouldHeal;
    }

    @ModifyReturnValue(method={"method_61740"}, at={@At(value="RETURN")})
    private List<class_2338> collectAffectedBlocks(List<class_2338> original) {
        if (this.method_64504().method_8608()) {
            return original;
        }
        this.vanillaAffectedPositions.addAll(ExplosionUtils.filterPositionsToHeal(original, pos -> this.method_64504().method_8320(pos)));
        this.checkForIndirectlyAffectedPositions();
        for (class_2338 pos2 : this.vanillaAffectedPositions) {
            this.affectedStatesAndBlockEntities.put(pos2, (class_3545<class_2680, class_2586>)new class_3545((Object)this.method_64504().method_8320(pos2), (Object)this.method_64504().method_8321(pos2)));
        }
        for (class_2338 pos2 : this.indirectlyAffectedPositions) {
            this.affectedStatesAndBlockEntities.put(pos2, (class_3545<class_2680, class_2586>)new class_3545((Object)this.method_64504().method_8320(pos2), (Object)this.method_64504().method_8321(pos2)));
        }
        return original;
    }

    @WrapMethod(method={"method_61732"})
    private void onDestroyBlocks(List<class_2338> positions, Operation<Void> original) {
        class_3218 serverWorld;
        block6: {
            block5: {
                ExplosionUtils.DROP_BLOCK_ITEMS.set(true);
                ExplosionUtils.DROP_CONTAINER_INVENTORY_ITEMS.set(true);
                class_3218 world = this.method_64504();
                if (!(world instanceof class_3218)) break block5;
                serverWorld = world;
                if (this.creeperhealing$shouldHeal()) break block6;
            }
            this.vanillaAffectedPositions.clear();
            this.affectedStatesAndBlockEntities.clear();
            this.indirectlyAffectedPositions.clear();
            original.call(new Object[]{positions});
            ExplosionUtils.DROP_BLOCK_ITEMS.set(true);
            ExplosionUtils.DROP_CONTAINER_INVENTORY_ITEMS.set(true);
            return;
        }
        ((ServerWorldDuck)serverWorld).creeperhealing$addAffectedPositions(this.vanillaAffectedPositions);
        ((ServerWorldDuck)serverWorld).creeperhealing$addAffectedPositions(this.indirectlyAffectedPositions);
        original.call(new Object[]{positions});
        ((ServerWorldDuck)serverWorld).creeperhealing$clearAffectedPositions();
        ExplosionUtils.DROP_BLOCK_ITEMS.set(true);
        ExplosionUtils.DROP_CONTAINER_INVENTORY_ITEMS.set(true);
        ArrayList<class_2338> filteredIndirectlyAffectedPositions = new ArrayList<class_2338>();
        for (class_2338 class_23382 : this.indirectlyAffectedPositions) {
            class_2680 newState;
            class_2680 class_26802;
            class_3545<class_2680, class_2586> class_35452 = this.affectedStatesAndBlockEntities.get(class_23382);
            if (class_35452 == null || ExcludedBlocks.isExcluded(class_26802 = (class_2680)class_35452.method_15442()) || Objects.equals(class_26802, newState = this.method_64504().method_8320(class_23382))) continue;
            filteredIndirectlyAffectedPositions.add(class_23382);
        }
        ArrayList<class_2338> filteredAffectedPositions = new ArrayList<class_2338>();
        for (class_2338 class_23383 : this.vanillaAffectedPositions) {
            class_2680 state;
            class_3545<class_2680, class_2586> class_35453 = this.affectedStatesAndBlockEntities.get(class_23383);
            if (class_35453 == null || ExcludedBlocks.isExcluded(state = (class_2680)class_35453.method_15442())) continue;
            filteredAffectedPositions.add(class_23383);
        }
        HashMap<class_2338, class_3545<class_2680, class_2586>> hashMap = new HashMap<class_2338, class_3545<class_2680, class_2586>>();
        for (Map.Entry<class_2338, class_3545<class_2680, class_2586>> entry : this.affectedStatesAndBlockEntities.entrySet()) {
            class_2338 entryPos = entry.getKey();
            if (!filteredAffectedPositions.contains(entryPos) && !filteredIndirectlyAffectedPositions.contains(entryPos)) continue;
            hashMap.put(entryPos, entry.getValue());
        }
        ExplosionContext explosionContext = new ExplosionContext(filteredAffectedPositions, filteredIndirectlyAffectedPositions, hashMap, serverWorld, this.explosionSourceType);
        ExplosionManagerRegistrar.getInstance().emitExplosionContext(DefaultExplosionManager.ID, explosionContext);
        this.vanillaAffectedPositions.clear();
        this.affectedStatesAndBlockEntities.clear();
        this.indirectlyAffectedPositions.clear();
    }

    @Unique
    private void checkForIndirectlyAffectedPositions() {
        ArrayList<class_2338> edgeAffectedPositions = new ArrayList<class_2338>();
        block0: for (class_2338 vanillaAffectedPosition : this.vanillaAffectedPositions) {
            if (this.method_64504().method_8320(vanillaAffectedPosition).method_26215()) continue;
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighborPos = vanillaAffectedPosition.method_10093(direction);
                class_2680 neighborState = this.method_64504().method_8320(neighborPos);
                if (neighborState.method_26215() || this.vanillaAffectedPositions.contains(neighborPos)) continue;
                edgeAffectedPositions.add(vanillaAffectedPosition);
                continue block0;
            }
        }
        EmptyWorld emptyWorld = new EmptyWorld((class_1937)this.method_64504());
        HashSet<class_2338> newPositions = new HashSet<class_2338>();
        for (class_2338 filteredPosition : edgeAffectedPositions) {
            this.checkNeighbors(512, filteredPosition, newPositions, emptyWorld);
        }
        this.indirectlyAffectedPositions.addAll(ExplosionUtils.filterPositionsToHeal(newPositions, pos -> this.method_64504().method_8320(pos)));
    }

    @Unique
    private void checkNeighbors(int maxCheckDepth, class_2338 currentPosition, Set<class_2338> newPositions, EmptyWorld emptyWorld) {
        if (maxCheckDepth <= 0) {
            return;
        }
        for (class_2350 neighborDirection : class_2350.values()) {
            class_2338 neighborPos = currentPosition.method_10093(neighborDirection);
            class_2680 neighborState = this.method_64504().method_8320(neighborPos);
            if (neighborState.method_26215() || neighborState.method_26184((class_4538)emptyWorld, neighborPos) || this.vanillaAffectedPositions.contains(neighborPos) || !newPositions.add(neighborPos)) continue;
            this.checkNeighbors(maxCheckDepth - 1, neighborPos, newPositions, emptyWorld);
        }
    }
}

