/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.util;

import io.github.arkosammy12.creeperhealing.CreeperHealing;
import io.github.arkosammy12.creeperhealing.ExplosionManagerRegistrar;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.AbstractExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.DaytimeExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import io.github.arkosammy12.creeperhealing.util.callbacks.DaylightCycleEvents;
import io.github.arkosammy12.creeperhealing.util.callbacks.SplashPotionCallbacks;
import io.github.arkosammy12.creeperhealing.util.callbacks.TimeCommandCallbacks;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1686;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class Events {
    private Events() {
        throw new AssertionError();
    }

    public static void registerEvents() {
        ServerTickEvents.END_SERVER_TICK.register(CreeperHealing.EXPLOSION_MANAGER::tick);
        DaylightCycleEvents.ON_NIGHT_SKIPPED.register(Events::onNightSkipped);
        SplashPotionCallbacks.ON_COLLISION.register(Events::onSplashPotionHit);
        ExplosionManagerRegistrar.getInstance().registerExplosionManager(CreeperHealing.EXPLOSION_MANAGER);
        TimeCommandCallbacks.ON_TIME_EXECUTE_SET.register(Events::onTimeCommand);
        TimeCommandCallbacks.ON_TIME_EXECUTE_ADD.register(Events::onTimeCommand);
    }

    private static void onNightSkipped(class_3218 world, BooleanSupplier shouldKeepTicking) {
        for (ExplosionEvent explosionEvent : CreeperHealing.EXPLOSION_MANAGER.getExplosionEvents().toList()) {
            if (!(explosionEvent instanceof DaytimeExplosionEvent)) continue;
            DaytimeExplosionEvent daytimeExplosionEvent = (DaytimeExplosionEvent)explosionEvent;
            daytimeExplosionEvent.setHealTimer(1L);
        }
    }

    private static void onSplashPotionHit(class_1686 potionEntity, class_1844 potionContentsComponent, class_239 hitResult, class_1937 world) {
        block12: {
            boolean healOnRegenerationPotion;
            boolean hasRegeneration;
            class_2338 potionHitPosition;
            block11: {
                Iterable statusEffectsIterable = potionContentsComponent.method_57397();
                ArrayList<class_1293> statusEffects = new ArrayList<class_1293>();
                for (class_1293 statusEffectInstance : statusEffectsIterable) {
                    statusEffects.add(statusEffectInstance);
                }
                switch (hitResult.method_17783()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_1332: {
                        class_2338 class_23382 = ((class_3965)hitResult).method_17777().method_10093(((class_3965)hitResult).method_17780());
                        break;
                    }
                    case field_1331: {
                        class_2338 class_23382 = ((class_3966)hitResult).method_17782().method_24515();
                        break;
                    }
                    case field_1333: {
                        class_2338 class_23382 = potionHitPosition = null;
                    }
                }
                if (potionHitPosition == null) {
                    return;
                }
                class_6880.class_6883 instantHealthEffect = class_1294.field_5915.method_40230().flatMap(key -> class_7923.field_41174.method_10223(key.method_29177())).orElse(null);
                if (instantHealthEffect == null) {
                    return;
                }
                boolean hasInstantHealth = statusEffects.stream().anyMatch(statusEffect -> statusEffect.method_55654((class_6880)instantHealthEffect));
                class_6880.class_6883 regenerationEffect = class_1294.field_5924.method_40230().flatMap(key -> class_7923.field_41174.method_10223(key.method_29177())).orElse(null);
                if (regenerationEffect == null) {
                    return;
                }
                hasRegeneration = statusEffects.stream().anyMatch(statusEffect -> statusEffect.method_55654((class_6880)regenerationEffect));
                boolean healOnHealingPotion = ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_ON_HEALING_POTION_SPLASH);
                healOnRegenerationPotion = ConfigUtils.getRawBooleanSetting(ConfigUtils.HEAL_ON_REGENERATION_POTION_SPLASH);
                if (!hasInstantHealth || !healOnHealingPotion) break block11;
                for (ExplosionEvent explosionEvent : CreeperHealing.EXPLOSION_MANAGER.getExplosionEvents().toList()) {
                    boolean potionHitExplosion = explosionEvent.getAffectedBlocks().anyMatch(affectedBlock -> affectedBlock.getBlockPos().equals((Object)potionHitPosition));
                    if (!potionHitExplosion || !(explosionEvent instanceof AbstractExplosionEvent)) continue;
                    AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)explosionEvent;
                    abstractExplosionEvent.setHealTimer(1L);
                    abstractExplosionEvent.getAffectedBlocks().forEach(affectedBlock -> {
                        if (affectedBlock instanceof SingleAffectedBlock) {
                            SingleAffectedBlock singleAffectedBlock = (SingleAffectedBlock)affectedBlock;
                            singleAffectedBlock.setTimer(1L);
                        }
                    });
                }
                break block12;
            }
            if (!hasRegeneration || !healOnRegenerationPotion) break block12;
            for (ExplosionEvent explosionEvent : CreeperHealing.EXPLOSION_MANAGER.getExplosionEvents().toList()) {
                boolean potionHitExplosion = explosionEvent.getAffectedBlocks().anyMatch(affectedBlock -> affectedBlock.getBlockPos().equals((Object)potionHitPosition));
                if (!potionHitExplosion || !(explosionEvent instanceof AbstractExplosionEvent)) continue;
                AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)explosionEvent;
                abstractExplosionEvent.setHealTimer(1L);
            }
        }
    }

    private static void onTimeCommand(class_2168 serverCommandSource, int time, int newTime) {
        for (ExplosionEvent explosionEvent : CreeperHealing.EXPLOSION_MANAGER.getExplosionEvents().toList()) {
            if (!(explosionEvent instanceof DaytimeExplosionEvent)) continue;
            DaytimeExplosionEvent daytimeExplosionEvent = (DaytimeExplosionEvent)explosionEvent;
            if (explosionEvent.getHealTimer() <= 0L) continue;
            daytimeExplosionEvent.setHealTimer(24000 - newTime);
        }
    }
}

