/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.monkeyutils.settings;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import io.github.arkosammy12.monkeyconfig.builders.NumberSettingBuilder;
import io.github.arkosammy12.monkeyconfig.settings.NumberSetting;
import io.github.arkosammy12.monkeyconfig.util.ElementPath;
import io.github.arkosammy12.monkeyutils.settings.CommandControllable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004B\u0015\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000f\u001a\u00028\u00002\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0012R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lio/github/arkosammy12/monkeyutils/settings/CommandNumberSetting;", "", "T", "Lio/github/arkosammy12/monkeyconfig/settings/NumberSetting;", "Lio/github/arkosammy12/monkeyutils/settings/CommandControllable;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Lio/github/arkosammy12/monkeyconfig/builders/NumberSettingBuilder;", "settingBuilder", "<init>", "(Lio/github/arkosammy12/monkeyconfig/builders/NumberSettingBuilder;)V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "", "argumentName", "getArgumentValue", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/Number;", "getByteArgumentType", "()Lcom/mojang/brigadier/arguments/ArgumentType;", "getShortArgumentType", "getIntegerArgumentType", "getLongArgumentType", "getFloatArgumentType", "getDoubleArgumentType", "getArgumentType", "argumentType", "Lio/github/arkosammy12/monkeyconfig/util/ElementPath;", "getCommandPath", "()Lio/github/arkosammy12/monkeyconfig/util/ElementPath;", "commandPath", "monkey-utils"})
public class CommandNumberSetting<T extends Number>
extends NumberSetting<T>
implements CommandControllable<T, ArgumentType<T>> {
    public CommandNumberSetting(@NotNull NumberSettingBuilder<T> settingBuilder) {
        Intrinsics.checkNotNullParameter(settingBuilder, (String)"settingBuilder");
        super(settingBuilder);
    }

    @Override
    @NotNull
    public ArgumentType<T> getArgumentType() throws IllegalArgumentException {
        ArgumentType<T> argumentType;
        Number number = (Number)this.getValue().getDefault();
        if (number instanceof Byte) {
            argumentType = this.getByteArgumentType();
        } else if (number instanceof Short) {
            argumentType = this.getShortArgumentType();
        } else if (number instanceof Integer) {
            argumentType = this.getIntegerArgumentType();
        } else if (number instanceof Long) {
            argumentType = this.getLongArgumentType();
        } else if (number instanceof Float) {
            argumentType = this.getFloatArgumentType();
        } else if (number instanceof Double) {
            argumentType = this.getDoubleArgumentType();
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + this.getValue().getDefault().getClass());
        }
        return argumentType;
    }

    @Override
    @NotNull
    public ElementPath getCommandPath() {
        return this.getPath();
    }

    @Override
    @NotNull
    public T getArgumentValue(@NotNull CommandContext<? extends class_2168> ctx, @NotNull String argumentName) {
        Number number;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Number number2 = (Number)this.getValue().getDefault();
        if (number2 instanceof Byte || number2 instanceof Short || number2 instanceof Integer) {
            number = IntegerArgumentType.getInteger(ctx, (String)argumentName);
        } else if (number2 instanceof Long) {
            number = LongArgumentType.getLong(ctx, (String)argumentName);
        } else if (number2 instanceof Float) {
            number = Float.valueOf(FloatArgumentType.getFloat(ctx, (String)argumentName));
        } else if (number2 instanceof Double) {
            number = DoubleArgumentType.getDouble(ctx, (String)argumentName);
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + this.getValue().getDefault().getClass());
        }
        return (T)number;
    }

    private final ArgumentType<T> getByteArgumentType() {
        int n = -128;
        Number number = this.getValue().getMinValue();
        int n2 = number != null ? number.intValue() : -128;
        int min = Math.max(n, n2);
        n2 = 127;
        Number number2 = this.getValue().getMaxValue();
        int n3 = number2 != null ? number2.intValue() : 127;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getShortArgumentType() {
        int n = Short.MIN_VALUE;
        Number number = this.getValue().getMinValue();
        int n2 = number != null ? number.intValue() : Short.MIN_VALUE;
        int min = Math.max(n, n2);
        n2 = Short.MAX_VALUE;
        Number number2 = this.getValue().getMaxValue();
        int n3 = number2 != null ? number2.intValue() : Short.MAX_VALUE;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getIntegerArgumentType() {
        int n = Integer.MIN_VALUE;
        Number number = this.getValue().getMinValue();
        int n2 = number != null ? number.intValue() : Integer.MIN_VALUE;
        int min = Math.max(n, n2);
        n2 = Integer.MAX_VALUE;
        Number number2 = this.getValue().getMaxValue();
        int n3 = number2 != null ? number2.intValue() : Integer.MAX_VALUE;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getLongArgumentType() {
        long l = Long.MIN_VALUE;
        Number number = this.getValue().getMinValue();
        long l2 = number != null ? number.longValue() : Long.MIN_VALUE;
        long min = Math.max(l, l2);
        l2 = Long.MAX_VALUE;
        Number number2 = this.getValue().getMaxValue();
        long l3 = number2 != null ? number2.longValue() : Long.MAX_VALUE;
        long max = Math.min(l2, l3);
        LongArgumentType longArgumentType = LongArgumentType.longArg((long)min, (long)max);
        Intrinsics.checkNotNull((Object)longArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)longArgumentType;
    }

    private final ArgumentType<T> getFloatArgumentType() {
        float f = Float.MIN_VALUE;
        Number number = this.getValue().getMinValue();
        float f2 = number != null ? number.floatValue() : Float.MIN_VALUE;
        float min = Math.max(f, f2);
        f2 = Float.MAX_VALUE;
        Number number2 = this.getValue().getMaxValue();
        float f3 = number2 != null ? number2.floatValue() : Float.MAX_VALUE;
        float max = Math.min(f2, f3);
        FloatArgumentType floatArgumentType = FloatArgumentType.floatArg((float)min, (float)max);
        Intrinsics.checkNotNull((Object)floatArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)floatArgumentType;
    }

    private final ArgumentType<T> getDoubleArgumentType() {
        double d = Double.MIN_VALUE;
        Number number = this.getValue().getMinValue();
        double d2 = number != null ? number.doubleValue() : Double.MIN_VALUE;
        double min = Math.max(d, d2);
        d2 = Double.MAX_VALUE;
        Number number2 = this.getValue().getMaxValue();
        double d3 = number2 != null ? number2.doubleValue() : Double.MAX_VALUE;
        double max = Math.min(d2, d3);
        DoubleArgumentType doubleArgumentType = DoubleArgumentType.doubleArg((double)min, (double)max);
        Intrinsics.checkNotNull((Object)doubleArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of io.github.arkosammy12.monkeyutils.settings.CommandNumberSetting>");
        return (ArgumentType)doubleArgumentType;
    }
}

