/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.arkosammy12.creeperhealing.CreeperHealing;
import io.github.arkosammy12.creeperhealing.blocks.AffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.DoubleAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public record DefaultSerializedAffectedBlock(String affectedBlockType, class_2338 pos, class_2680 state, @Nullable class_2487 nbt, @Nullable class_2338 secondHalfPos, @Nullable class_2680 secondHalfState, @Nullable class_2487 secondHalfNbt, class_5321<class_1937> worldRegistryKey, long blockTimer, boolean placed) implements SerializedAffectedBlock
{
    public static final Codec<SerializedAffectedBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("affected_block_type").forGetter(SerializedAffectedBlock::getAffectedBlockTypeName), (App)class_2338.field_25064.fieldOf("block_pos").forGetter(SerializedAffectedBlock::getBlockPos), (App)class_2680.field_24734.fieldOf("block_state").forGetter(SerializedAffectedBlock::getBlockState), (App)class_2487.field_25128.optionalFieldOf("nbt_data").forGetter(serializedAffectedBlock -> serializedAffectedBlock.getCustomData("nbt", class_2487.class)), (App)class_2338.field_25064.optionalFieldOf("second_half_pos").forGetter(serializedAffectedBlock -> serializedAffectedBlock.getCustomData("secondHalfPos", class_2338.class)), (App)class_2680.field_24734.optionalFieldOf("second_half_state").forGetter(serializedAffectedBlock -> serializedAffectedBlock.getCustomData("secondHalfState", class_2680.class)), (App)class_2487.field_25128.optionalFieldOf("second_half_nbt_data").forGetter(serializedAffectedBlock -> serializedAffectedBlock.getCustomData("secondHalfNbt", class_2487.class)), (App)class_1937.field_25178.fieldOf("world").forGetter(SerializedAffectedBlock::getWorldRegistryKey), (App)Codec.LONG.fieldOf("affected_block_timer").forGetter(SerializedAffectedBlock::getBlockTimer), (App)Codec.BOOL.fieldOf("is_placed").forGetter(SerializedAffectedBlock::isPlaced)).apply((Applicative)instance, (affectedBlockType, blockPos, blockState, optionalNbt, secondHalfPos, secondHalfState, optionalSecondHalfNbt, world, affectedBlockTimer, isPlaced) -> new DefaultSerializedAffectedBlock((String)affectedBlockType, (class_2338)blockPos, (class_2680)blockState, optionalNbt.orElse(null), secondHalfPos.orElse(null), secondHalfState.orElse(null), optionalSecondHalfNbt.orElse(null), (class_5321<class_1937>)world, (long)affectedBlockTimer, (boolean)isPlaced)));

    @Override
    public String getAffectedBlockTypeName() {
        return this.affectedBlockType;
    }

    @Override
    public class_2338 getBlockPos() {
        return this.pos;
    }

    @Override
    public class_2680 getBlockState() {
        return this.state;
    }

    @Override
    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    @Override
    public long getBlockTimer() {
        return this.blockTimer;
    }

    @Override
    public boolean isPlaced() {
        return this.placed;
    }

    @Override
    public <T> Optional<T> getCustomData(String name, Class<T> clazz) {
        class_2487 data;
        switch (name) {
            case "nbt": {
                class_2487 class_24872 = this.nbt;
                break;
            }
            case "secondHalfPos": {
                class_2487 class_24872 = this.secondHalfPos;
                break;
            }
            case "secondHalfState": {
                class_2487 class_24872 = this.secondHalfState;
                break;
            }
            case "secondHalfNbt": {
                class_2487 class_24872 = this.secondHalfNbt;
                break;
            }
            default: {
                CreeperHealing.LOGGER.warn("Tried to get unexpected property of name \"{}\" while serializing an affected block!", (Object)name);
                class_2487 class_24872 = data = null;
            }
        }
        if (clazz.isInstance(data)) {
            return Optional.of(data);
        }
        if (data == null) {
            return Optional.empty();
        }
        CreeperHealing.LOGGER.error("Unsuccessfully tried to cast property with name \"{}\" of type \"{}\" to \"{}\" while serializing an affected block!", new Object[]{name, data.getClass().getSimpleName(), clazz.getSimpleName()});
        return Optional.empty();
    }

    @Override
    public AffectedBlock asDeserialized() {
        return switch (this.affectedBlockType) {
            case "double_affected_block" -> new DoubleAffectedBlock(this.pos(), this.state(), this.nbt(), this.secondHalfPos(), this.secondHalfState(), this.secondHalfNbt(), this.worldRegistryKey(), this.getBlockTimer(), this.placed());
            default -> new SingleAffectedBlock(this.pos(), this.state(), this.worldRegistryKey(), this.nbt(), this.getBlockTimer(), this.placed());
        };
    }
}

