/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.blocks;

import io.github.arkosammy12.creeperhealing.blocks.AffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.DefaultSerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import io.github.arkosammy12.creeperhealing.util.ExplosionUtils;
import io.github.arkosammy12.monkeyconfig.base.Setting;
import io.github.arkosammy12.monkeyconfig.sections.maps.StringMapSection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleAffectedBlock
implements AffectedBlock {
    public static final String TYPE = "single_affected_block";
    private final class_2338 blockPos;
    private final class_2680 blockState;
    private final class_5321<class_1937> worldRegistryKey;
    @Nullable
    private final class_2487 nbt;
    private long timer;
    private boolean placed;

    protected SingleAffectedBlock(class_2338 blockPos, class_2680 blockState, class_5321<class_1937> registryKey, @Nullable class_2487 nbt, long timer, boolean placed) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.worldRegistryKey = registryKey;
        this.nbt = nbt;
        this.placed = placed;
        this.timer = timer;
    }

    public void setTimer(long delay) {
        this.timer = delay;
    }

    @Override
    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    @Override
    public class_3218 getWorld(@NotNull MinecraftServer server) {
        return server.method_3847(this.getWorldRegistryKey());
    }

    @Override
    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    @Override
    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    @Override
    public final void setPlaced() {
        this.placed = true;
    }

    @Override
    public boolean isPlaced() {
        return this.placed;
    }

    @Override
    public long getBlockTimer() {
        return this.timer;
    }

    @Override
    public void tick(ExplosionEvent explosionEvent, MinecraftServer server) {
        --this.timer;
        if (this.timer >= 0L) {
            return;
        }
        this.tryHealing(server, explosionEvent);
    }

    @Override
    public boolean canBePlaced(MinecraftServer server) {
        if (this.shouldForceHeal()) {
            return true;
        }
        return this.getBlockState().method_26184((class_4538)this.getWorld(server), this.getBlockPos());
    }

    @Override
    public SerializedAffectedBlock asSerialized() {
        return new DefaultSerializedAffectedBlock(this.getAffectedBlockType(), this.blockPos, this.blockState, this.nbt, null, null, null, this.worldRegistryKey, this.timer, this.placed);
    }

    protected String getAffectedBlockType() {
        return TYPE;
    }

    protected void tryHealing(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        boolean healNbt;
        this.setPlaced();
        class_2680 state = this.getBlockState();
        class_2338 pos = this.getBlockPos();
        class_3218 world = this.getWorld(server);
        boolean stateReplaced = false;
        String blockIdentifier = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        StringMapSection replaceMapSection = ConfigUtils.getRawStringMapSection(ConfigUtils.REPLACE_MAP);
        Setting replaceMapValue = replaceMapSection.get(blockIdentifier);
        if (replaceMapValue != null && !this.shouldForceHeal()) {
            state = ((class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)((String)replaceMapValue.getValue().getRaw())))).method_34725(state);
            stateReplaced = true;
        }
        if (!this.shouldHealBlock((class_1937)world)) {
            return;
        }
        ExplosionUtils.pushEntitiesUpwards((class_1937)world, pos, state, false);
        boolean makeFallingBlocksFall = ConfigUtils.getRawBooleanSetting(ConfigUtils.MAKE_FALLING_BLOCKS_FALL);
        if (state.method_26204() instanceof class_2346) {
            ExplosionUtils.FALLING_BLOCK_SCHEDULE_TICK.set(makeFallingBlocksFall);
        }
        world.method_8501(pos, state);
        this.handleChestBlockIfNeeded(currentExplosionEvent, state, pos, server);
        boolean bl = healNbt = this.nbt != null && !stateReplaced;
        if (healNbt) {
            world.method_8438(class_2586.method_11005((class_2338)pos, (class_2680)state, (class_2487)this.nbt, (class_7225.class_7874)world.method_30349()));
        }
        ExplosionUtils.playBlockPlacementSoundEffect((class_1937)world, pos, state);
        ExplosionUtils.spawnParticles((class_1937)world, pos);
    }

    protected boolean shouldHealBlock(class_1937 world) {
        if (this.shouldForceHeal()) {
            return true;
        }
        return world.method_8320(this.blockPos).method_45474();
    }

    protected boolean shouldForceHeal() {
        boolean forceBlocksWithNbtToAlwaysHeal = ConfigUtils.getRawBooleanSetting(ConfigUtils.FORCE_BLOCKS_WITH_NBT_TO_ALWAYS_HEAL);
        return this.nbt != null && forceBlocksWithNbtToAlwaysHeal;
    }

    private void handleChestBlockIfNeeded(ExplosionEvent explosionEvent, class_2680 blockState, class_2338 chestPos, MinecraftServer server) {
        class_2338 otherHalfPos;
        if (!blockState.method_27852(class_2246.field_10034)) {
            return;
        }
        class_2745 chestType = (class_2745)blockState.method_11654((class_2769)class_2281.field_10770);
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2281.field_10768);
        block0 : switch (chestType) {
            default: {
                throw new MatchException(null, null);
            }
            case field_12569: {
                class_2338 class_23382 = null;
                break;
            }
            case field_12574: {
                class_2338 class_23382;
                switch (facing) {
                    case field_11043: {
                        class_23382 = chestPos.method_10078();
                        break block0;
                    }
                    case field_11034: {
                        class_23382 = chestPos.method_10072();
                        break block0;
                    }
                    case field_11035: {
                        class_23382 = chestPos.method_10067();
                        break block0;
                    }
                    case field_11039: {
                        class_23382 = chestPos.method_10095();
                        break block0;
                    }
                }
                class_23382 = null;
                break;
            }
            case field_12571: {
                class_2338 class_23382;
                switch (facing) {
                    case field_11043: {
                        class_23382 = chestPos.method_10067();
                        break block0;
                    }
                    case field_11034: {
                        class_23382 = chestPos.method_10095();
                        break block0;
                    }
                    case field_11035: {
                        class_23382 = chestPos.method_10078();
                        break block0;
                    }
                    case field_11039: {
                        class_23382 = chestPos.method_10072();
                        break block0;
                    }
                }
                class_23382 = otherHalfPos = null;
            }
        }
        if (otherHalfPos == null) {
            return;
        }
        List<AffectedBlock> affectedBlocks = explosionEvent.getAffectedBlocks().toList();
        for (AffectedBlock affectedBlock : affectedBlocks) {
            SingleAffectedBlock singleAffectedBlock;
            if (!(affectedBlock instanceof SingleAffectedBlock) || (singleAffectedBlock = (SingleAffectedBlock)affectedBlock).isPlaced()) continue;
            class_2680 affectedState = singleAffectedBlock.getBlockState();
            class_2338 affectedPosition = singleAffectedBlock.getBlockPos();
            if (!affectedState.method_27852(class_2246.field_10034) || !affectedPosition.equals((Object)otherHalfPos)) continue;
            singleAffectedBlock.tryHealing(server, explosionEvent);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleAffectedBlock)) {
            return false;
        }
        SingleAffectedBlock that = (SingleAffectedBlock)o;
        return Objects.equals(this.getBlockPos(), that.getBlockPos()) && Objects.equals(this.getBlockState(), that.getBlockState()) && Objects.equals(this.getWorldRegistryKey(), that.getWorldRegistryKey());
    }

    public int hashCode() {
        return Objects.hash(this.getBlockPos(), this.getBlockState(), this.getWorldRegistryKey());
    }

    public String toString() {
        return "SingleAffectedBlock(pos=%s, state=%s, world=%s, nbt=%s, timer=%s, placed=%s)".formatted(this.blockPos, this.blockState, this.worldRegistryKey, this.nbt != null ? this.nbt : "null", this.timer, this.placed);
    }
}

