/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.explosions.factories;

import io.github.arkosammy12.creeperhealing.blocks.AffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.DoubleAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.AbstractExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.DaytimeExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.DefaultExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionHealingMode;
import io.github.arkosammy12.creeperhealing.explosions.factories.ExplosionEventFactory;
import io.github.arkosammy12.creeperhealing.util.ExplosionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class DefaultExplosionFactory
implements ExplosionEventFactory<AbstractExplosionEvent> {
    private final Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities;
    private final class_3218 world;
    private final int blastRadius;
    private final Set<class_2338> affectedPositions = new HashSet<class_2338>();
    private final class_2338 center;
    private final List<class_2338> vanillaAffectedPositions;

    public DefaultExplosionFactory(Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities, List<class_2338> vanillaAffectedPositions, List<class_2338> indirectlyExplodedPositions, class_3218 world) {
        this.affectedStatesAndBlockEntities = affectedStatesAndBlockEntities;
        this.world = world;
        this.affectedPositions.addAll(vanillaAffectedPositions);
        this.affectedPositions.addAll(indirectlyExplodedPositions);
        this.blastRadius = ExplosionUtils.getMaxExplosionRadius(vanillaAffectedPositions);
        this.center = ExplosionUtils.calculateCenter(vanillaAffectedPositions);
        this.vanillaAffectedPositions = vanillaAffectedPositions;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent() {
        List<AffectedBlock> affectedBlocks = this.processAffectedPositions(new ArrayList<class_2338>(this.affectedPositions), this.world);
        if (affectedBlocks == null || affectedBlocks.isEmpty()) {
            return null;
        }
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getRawEnumSetting(ConfigUtils.MODE));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, this.blastRadius, this.center);
        };
        explosionEvent.setup(this.world);
        return explosionEvent;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<class_2338> affectedPositions, class_3218 world) {
        List<AffectedBlock> affectedBlocks = this.processAffectedPositions(affectedPositions, world);
        if (affectedBlocks == null || affectedBlocks.isEmpty()) {
            return null;
        }
        class_2338 center = ExplosionUtils.calculateCenter(affectedPositions);
        int radius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getRawEnumSetting(ConfigUtils.MODE));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, radius, center);
        };
        explosionEvent.setup(world);
        return explosionEvent;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer) {
        return this.createExplosionEvent((List)affectedBlocks, healTimer, ConfigUtils.getBlockPlacementDelay());
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, long blockHealDelay) {
        return this.createExplosionEvent(affectedBlocks, healTimer, blockHealDelay, 0);
    }

    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, long blockHealDelay, int blockCounter) {
        if (affectedBlocks.isEmpty()) {
            return null;
        }
        List<class_2338> affectedPositions = affectedBlocks.stream().map(AffectedBlock::getBlockPos).toList();
        class_2338 center = ExplosionUtils.calculateCenter(affectedPositions);
        int radius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocks(affectedBlocks, this.world);
        sortedAffectedBlocks.forEach(affectedBlock -> {
            if (affectedBlock instanceof SingleAffectedBlock) {
                SingleAffectedBlock singleAffectedBlock = (SingleAffectedBlock)affectedBlock;
                singleAffectedBlock.setTimer(blockHealDelay);
            }
        });
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getRawEnumSetting(ConfigUtils.MODE));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
        };
        explosionEvent.setup(this.world);
        return explosionEvent;
    }

    @Override
    public List<class_2338> getAffectedPositions() {
        return this.vanillaAffectedPositions;
    }

    @Override
    public class_3218 getWorld() {
        return this.world;
    }

    @Nullable
    private List<AffectedBlock> processAffectedPositions(List<class_2338> affectedPositions, class_3218 world) {
        List<class_2338> positionsToHeal = ExplosionUtils.filterPositionsToHeal(affectedPositions, pos -> (class_2680)this.affectedStatesAndBlockEntities.get(pos).method_15442());
        if (positionsToHeal.isEmpty()) {
            return null;
        }
        ArrayList<AffectedBlock> affectedBlocks = new ArrayList<AffectedBlock>();
        for (class_2338 pos2 : positionsToHeal) {
            if (affectedBlocks.stream().anyMatch(affectedBlock -> {
                DoubleAffectedBlock doubleAffectedBlock;
                return affectedBlock.getBlockPos().equals((Object)pos2) || affectedBlock instanceof DoubleAffectedBlock && (doubleAffectedBlock = (DoubleAffectedBlock)affectedBlock).getSecondHalfPos().equals((Object)pos2);
            })) continue;
            class_2680 affectedState = (class_2680)this.affectedStatesAndBlockEntities.get(pos2).method_15442();
            class_2586 affectedBlockEntity = (class_2586)this.affectedStatesAndBlockEntities.get(pos2).method_15441();
            class_2338 otherHalfPos = DoubleAffectedBlock.getOtherHalfPos(pos2, affectedState);
            AffectedBlock affectedBlock2 = null;
            if (otherHalfPos == null) {
                affectedBlock2 = AffectedBlock.newInstance(pos2, affectedState, affectedBlockEntity, (class_1937)world);
            } else {
                for (class_2338 otherPos : positionsToHeal) {
                    if (!otherPos.equals((Object)otherHalfPos)) continue;
                    class_2680 secondHalfState = (class_2680)this.affectedStatesAndBlockEntities.get(otherPos).method_15442();
                    class_2586 secondHalfBlockEntity = (class_2586)this.affectedStatesAndBlockEntities.get(otherPos).method_15441();
                    affectedBlock2 = AffectedBlock.newInstance(pos2, affectedState, affectedBlockEntity, otherHalfPos, secondHalfState, secondHalfBlockEntity, (class_1937)world);
                    break;
                }
                if (affectedBlock2 == null) {
                    affectedBlock2 = AffectedBlock.newInstance(pos2, affectedState, affectedBlockEntity, otherHalfPos, null, null, (class_1937)world);
                }
            }
            affectedBlocks.add(affectedBlock2);
        }
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocks(affectedBlocks, world);
        return sortedAffectedBlocks;
    }
}

