/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.blocks;

import io.github.arkosammy12.creeperhealing.blocks.DefaultSerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SerializedAffectedBlock;
import io.github.arkosammy12.creeperhealing.blocks.SingleAffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigSettings;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.config.SettingGroups;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import io.github.arkosammy12.creeperhealing.util.ExplosionUtils;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.monkeyconfig.groups.SettingGroup;
import xd.arkosammy.monkeyconfig.groups.maps.StringMapSettingGroup;
import xd.arkosammy.monkeyconfig.settings.BooleanSetting;

public class DoubleAffectedBlock
extends SingleAffectedBlock {
    private final class_2338 secondHalfPos;
    private final class_2680 secondHalfState;
    @Nullable
    private final class_2487 secondHalfNbt;
    public static final String TYPE = "double_affected_block";

    protected DoubleAffectedBlock(class_2338 firstHalfPos, class_2680 firstHalfState, @Nullable class_2487 firstHalfNbt, @Nullable class_2338 secondHalfPos, @Nullable class_2680 secondHalfState, @Nullable class_2487 secondHalfNbt, class_5321<class_1937> registryKey, long affectedBlockTimer, boolean placed) {
        super(firstHalfPos, firstHalfState, registryKey, firstHalfNbt, affectedBlockTimer, placed);
        this.secondHalfNbt = secondHalfNbt;
        if (secondHalfState == null) {
            if (firstHalfState.method_28498((class_2769)class_2741.field_12533)) {
                class_2756 secondHalf = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? class_2756.field_12607 : class_2756.field_12609;
                this.secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12533, (Comparable)secondHalf);
            } else if (firstHalfState.method_28498((class_2769)class_2741.field_12483)) {
                class_2742 secondBedPart = ((class_2742)firstHalfState.method_11654((class_2769)class_2741.field_12483)).equals((Object)class_2742.field_12560) ? class_2742.field_12557 : class_2742.field_12560;
                this.secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12483, (Comparable)secondBedPart);
            } else {
                this.secondHalfState = null;
            }
        } else {
            this.secondHalfState = secondHalfState;
        }
        this.secondHalfPos = secondHalfPos == null ? DoubleAffectedBlock.getOtherHalfPos(firstHalfPos, firstHalfState) : secondHalfPos;
    }

    @Override
    protected String getAffectedBlockType() {
        return TYPE;
    }

    public class_2680 getSecondHalfState() {
        return this.secondHalfState;
    }

    public class_2338 getSecondHalfPos() {
        return this.secondHalfPos;
    }

    @Nullable
    public class_2487 getSecondHalfNbt() {
        return this.secondHalfNbt;
    }

    @Override
    public SerializedAffectedBlock asSerialized() {
        return new DefaultSerializedAffectedBlock(this.getAffectedBlockType(), this.getBlockPos(), this.getBlockState(), this.getNbt(), this.getSecondHalfPos(), this.getSecondHalfState(), this.getSecondHalfNbt(), this.getWorldRegistryKey(), this.getBlockTimer(), this.isPlaced());
    }

    @Override
    protected boolean shouldHealBlock(class_1937 world) {
        return world.method_8320(this.getBlockPos()).method_45474() && world.method_8320(this.secondHalfPos).method_45474();
    }

    @Override
    protected boolean shouldForceHeal() {
        boolean forceBlocksWithNbtToAlwaysHeal = (Boolean)ConfigUtils.getSettingValue(ConfigSettings.FORCE_BLOCKS_WITH_NBT_TO_ALWAYS_HEAL.getSettingLocation(), BooleanSetting.class);
        return this.getNbt() != null && this.getSecondHalfNbt() != null && forceBlocksWithNbtToAlwaysHeal;
    }

    @Override
    public void tryHealing(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        boolean healSecondHalfNbt;
        boolean healFirstHalfNbt;
        StringMapSettingGroup replaceMapGroup;
        String replaceMapValue;
        if (this.secondHalfState == null) {
            super.tryHealing(server, currentExplosionEvent);
            return;
        }
        this.setPlaced();
        class_2680 firstHalfState = this.getBlockState();
        class_2338 firstHalfPos = this.getBlockPos();
        class_2680 secondHalfState = this.secondHalfState;
        class_2338 secondHalfPos = this.secondHalfPos;
        class_3218 world = this.getWorld(server);
        boolean stateReplaced = false;
        String blockIdentifier = class_7923.field_41175.method_10221((Object)firstHalfState.method_26204()).toString();
        SettingGroup settingGroup = ConfigUtils.getSettingGroup(SettingGroups.REPLACE_MAP.getName());
        if (settingGroup instanceof StringMapSettingGroup && (replaceMapValue = (String)(replaceMapGroup = (StringMapSettingGroup)settingGroup).get(blockIdentifier)) != null && (!this.shouldForceHeal() || firstHalfState.method_26164(class_3481.field_16443))) {
            firstHalfState = ((class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)replaceMapValue))).method_34725(firstHalfState);
            secondHalfState = ((class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)replaceMapValue))).method_34725(secondHalfState);
            stateReplaced = true;
        }
        if (!firstHalfState.method_28498((class_2769)class_2741.field_12533) && !firstHalfState.method_28498((class_2769)class_2741.field_12483)) {
            super.tryHealing(server, currentExplosionEvent);
            return;
        }
        if (!this.shouldHealBlock((class_1937)world)) {
            return;
        }
        ExplosionUtils.pushEntitiesUpwards((class_1937)world, firstHalfPos, firstHalfState, firstHalfState.method_28498((class_2769)class_2741.field_12533));
        boolean makeFallingBlocksFall = (Boolean)ConfigUtils.getSettingValue(ConfigSettings.MAKE_FALLING_BLOCKS_FALL.getSettingLocation(), BooleanSetting.class);
        if (firstHalfState.method_26204() instanceof class_2346) {
            ExplosionUtils.FALLING_BLOCK_SCHEDULE_TICK.set(makeFallingBlocksFall);
        }
        if (secondHalfState.method_26204() instanceof class_2346) {
            ExplosionUtils.FALLING_BLOCK_SCHEDULE_TICK.set(makeFallingBlocksFall);
        }
        world.method_8501(firstHalfPos, firstHalfState);
        world.method_8501(secondHalfPos, secondHalfState);
        boolean bl = healFirstHalfNbt = this.getNbt() != null && !stateReplaced;
        if (healFirstHalfNbt) {
            world.method_8438(class_2586.method_11005((class_2338)firstHalfPos, (class_2680)firstHalfState, (class_2487)this.getNbt(), (class_7225.class_7874)world.method_30349()));
        }
        boolean bl2 = healSecondHalfNbt = this.secondHalfNbt != null && !stateReplaced;
        if (healSecondHalfNbt) {
            world.method_8438(class_2586.method_11005((class_2338)secondHalfPos, (class_2680)secondHalfState, (class_2487)this.secondHalfNbt, (class_7225.class_7874)world.method_30349()));
        }
        ExplosionUtils.playBlockPlacementSoundEffect((class_1937)world, firstHalfPos, firstHalfState);
        ExplosionUtils.spawnParticles((class_1937)world, firstHalfPos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleAffectedBlock)) {
            return false;
        }
        DoubleAffectedBlock that = (DoubleAffectedBlock)o;
        return Objects.equals(this.getBlockPos(), that.getBlockPos()) && Objects.equals(this.getBlockState(), that.getBlockState()) && Objects.equals(this.getSecondHalfPos(), that.getSecondHalfPos()) && Objects.equals(this.getSecondHalfState(), that.getSecondHalfState()) && Objects.equals(this.getWorldRegistryKey(), that.getWorldRegistryKey());
    }

    @Override
    public String toString() {
        return "DoubleAffectedBlock(firstHalfPos=%s, firstHalfState=%s, firstHalfNbt=%s, secondHalfPos=%s, secondHalfState=%s, secondHalfNbt=%s, world=%s, timer=%s, placed=%s)".formatted(this.getBlockPos(), this.getBlockState(), this.getNbt(), this.secondHalfPos, this.secondHalfState, this.secondHalfNbt, this.getWorldRegistryKey(), this.getBlockTimer(), this.isPlaced());
    }

    @Nullable
    public static class_2338 getOtherHalfPos(class_2338 pos, class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            return DoubleAffectedBlock.getSecondDoubleBlockHalfPos(pos, state);
        }
        if (state.method_28498((class_2769)class_2741.field_12483)) {
            return DoubleAffectedBlock.getSecondBedBlockHalfPos(pos, state);
        }
        return null;
    }

    public static class_2338 getSecondDoubleBlockHalfPos(class_2338 firstHalfPos, class_2680 firstHalfState) {
        return ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? firstHalfPos.method_10074() : firstHalfPos.method_10084();
    }

    public static class_2338 getSecondBedBlockHalfPos(class_2338 firstHalfPos, class_2680 firstHalfState) {
        class_2742 secondBedPart = ((class_2742)firstHalfState.method_11654((class_2769)class_2741.field_12483)).equals((Object)class_2742.field_12560) ? class_2742.field_12557 : class_2742.field_12560;
        class_2350 firstBedPartOrientation = (class_2350)firstHalfState.method_11654((class_2769)class_2741.field_12481);
        return switch (secondBedPart) {
            default -> throw new MatchException(null, null);
            case class_2742.field_12560 -> {
                switch (firstBedPartOrientation) {
                    case field_11043: {
                        yield firstHalfPos.method_10095();
                    }
                    case field_11035: {
                        yield firstHalfPos.method_10072();
                    }
                    case field_11034: {
                        yield firstHalfPos.method_10078();
                    }
                }
                yield firstHalfPos.method_10067();
            }
            case class_2742.field_12557 -> {
                switch (firstBedPartOrientation) {
                    case field_11043: {
                        yield firstHalfPos.method_10072();
                    }
                    case field_11035: {
                        yield firstHalfPos.method_10095();
                    }
                    case field_11034: {
                        yield firstHalfPos.method_10067();
                    }
                }
                yield firstHalfPos.method_10078();
            }
        };
    }
}

