/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.config;

import io.github.arkosammy12.creeperhealing.config.groups.MutableDelaysGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import xd.arkosammy.monkeyconfig.groups.DefaultMutableSettingGroup;
import xd.arkosammy.monkeyconfig.groups.MutableSettingGroup;
import xd.arkosammy.monkeyconfig.groups.maps.MutableStringMapSettingGroup;

public enum SettingGroups {
    DELAYS(new MutableDelaysGroup("delays", "Configure the delays related to the healing of explosions.")),
    EXPLOSION_ITEM_DROPS((MutableSettingGroup)new DefaultMutableSettingGroup("explosion_item_drops", "Toggle whether certain explosion should drop items. Does not include items stored in container blocks.")),
    EXPLOSION_SOURCES((MutableSettingGroup)new DefaultMutableSettingGroup("explosion_sources", "Configure which explosions are allowed to heal.")),
    HEALING_MODE((MutableSettingGroup)new DefaultMutableSettingGroup("explosion_healing_mode", "Choose between different special modes for explosion healing. Note that certain healing modes will not follow the explosion delay and block delay settings.")),
    PREFERENCES((MutableSettingGroup)new DefaultMutableSettingGroup("preferences", "Toggleable settings for extra features.")),
    WHITELIST((MutableSettingGroup)new DefaultMutableSettingGroup("whitelist", "Use an optional whitelist to customize which blocks are allowed to heal. To add an entry, specify the block's namespace\nalong with its identifier, separated by a colon and enclosed in double quotes, and add it in-between the square brackets below. Separate each entry with a comma.\nExample entries:\nwhitelist_entries = [\"minecraft:grass\",  \"minecraft:stone\", \"minecraft:sand\"]", new ArrayList<E>(), true)),
    REPLACE_MAP((MutableSettingGroup)new MutableStringMapSettingGroup("replace_map", "Add your own replace entries to configure which blocks should be used to heal other blocks. The block on the right will be used to heal the block on the left.\nSpecify the block's namespace along with the block's name identifier, separated by a colon and enclosed in double quotes.\nExample entry:\n\"minecraft:gold_block\" = \"minecraft:stone\"\nWarning, the same key cannot appear more than once in the replace map! For example, the following will cause an error:\n\"minecraft:diamond_block\" = \"minecraft:stone\"\n\"minecraft:diamond_block\" = \"minecraft:air\" ", Map.of("minecraft:diamond_block", "minecraft:stone")));

    private final MutableSettingGroup settingGroup;

    private SettingGroups(MutableSettingGroup settingGroup) {
        this.settingGroup = settingGroup;
    }

    public String getName() {
        return this.settingGroup.getName();
    }

    public static List<MutableSettingGroup> getSettingGroups() {
        return Arrays.stream(SettingGroups.values()).map(e -> e.settingGroup).collect(Collectors.toList());
    }
}

