/*
 * Decompiled with CFR 0.152.
 */
package io.github.arkosammy12.creeperhealing.explosions;

import io.github.arkosammy12.creeperhealing.blocks.AffectedBlock;
import io.github.arkosammy12.creeperhealing.config.ConfigUtils;
import io.github.arkosammy12.creeperhealing.explosions.DefaultSerializedExplosion;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionEvent;
import io.github.arkosammy12.creeperhealing.explosions.ExplosionHealingMode;
import io.github.arkosammy12.creeperhealing.explosions.SerializedExplosionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractExplosionEvent
implements ExplosionEvent {
    private final List<AffectedBlock> affectedBlocks;
    protected long healTimer;
    private int blockCounter;
    protected boolean finished;
    private final int radius;
    private final class_2338 center;

    public AbstractExplosionEvent(List<AffectedBlock> affectedBlocks, int radius, class_2338 center) {
        this(affectedBlocks, ConfigUtils.getExplosionHealDelay(), 0, radius, center);
    }

    public AbstractExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, int blockCounter, int radius, class_2338 center) {
        this.affectedBlocks = affectedBlocks;
        this.healTimer = healTimer;
        this.blockCounter = blockCounter;
        this.center = center;
        this.radius = radius;
    }

    @Override
    public Stream<AffectedBlock> getAffectedBlocks() {
        return this.affectedBlocks.stream();
    }

    @Override
    public class_3218 getWorld(MinecraftServer server) {
        return server.method_3847(this.affectedBlocks.getFirst().getWorldRegistryKey());
    }

    @Override
    public long getHealTimer() {
        return this.healTimer;
    }

    public int getBlockCounter() {
        return this.blockCounter;
    }

    public class_2338 getCenter() {
        return this.center;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    protected final Optional<AffectedBlock> getCurrentAffectedBlock() {
        return this.blockCounter < this.affectedBlocks.size() ? Optional.of(this.affectedBlocks.get(this.blockCounter)) : Optional.empty();
    }

    protected final void incrementCounter() {
        ++this.blockCounter;
    }

    public final void setHealTimer(long timer) {
        this.healTimer = timer;
    }

    protected void updateFinishedStatus(class_1937 world) {
    }

    protected abstract ExplosionHealingMode getHealingMode();

    @Override
    public final void tick(MinecraftServer server) {
        if (this.isFinished()) {
            return;
        }
        --this.healTimer;
        if (this.healTimer >= 0L) {
            return;
        }
        Optional<AffectedBlock> optionalAffectedBlock = this.getCurrentAffectedBlock();
        if (optionalAffectedBlock.isEmpty()) {
            this.finished = true;
            return;
        }
        AffectedBlock currentAffectedBlock = optionalAffectedBlock.get();
        if (currentAffectedBlock.isPlaced()) {
            this.incrementCounter();
            return;
        }
        if (!currentAffectedBlock.canBePlaced(server)) {
            this.delayAffectedBlock(currentAffectedBlock, server);
            return;
        }
        this.updateFinishedStatus((class_1937)this.getWorld(server));
        if (this.isFinished()) {
            return;
        }
        currentAffectedBlock.tick(this, server);
        if (currentAffectedBlock.getBlockTimer() < 0L) {
            this.incrementCounter();
        }
    }

    private void delayAffectedBlock(AffectedBlock affectedBlockToDelay, MinecraftServer server) {
        int indexOfDelayedBlock = this.affectedBlocks.indexOf(affectedBlockToDelay);
        if (indexOfDelayedBlock < 0) {
            this.incrementCounter();
            affectedBlockToDelay.setPlaced();
            return;
        }
        int indexOfNextPlaceable = this.findNextPlaceableBlockIndex(server);
        if (indexOfNextPlaceable >= 0) {
            Collections.swap(this.affectedBlocks, indexOfDelayedBlock, indexOfNextPlaceable);
        } else {
            this.incrementCounter();
            affectedBlockToDelay.setPlaced();
        }
    }

    private int findNextPlaceableBlockIndex(MinecraftServer server) {
        for (int i = this.blockCounter; i < this.affectedBlocks.size(); ++i) {
            if (!this.affectedBlocks.get(i).canBePlaced(server)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public SerializedExplosionEvent asSerialized() {
        return new DefaultSerializedExplosion(this.getHealingMode().method_15434(), this.getAffectedBlocks().map(AffectedBlock::asSerialized).toList(), this.healTimer, this.blockCounter, this.radius, this.center);
    }

    public final void findAndMarkPlaced(class_2338 blockPos, class_2680 blockState, class_1937 world) {
        for (AffectedBlock affectedBlock : this.affectedBlocks) {
            if (!affectedBlock.getBlockState().equals(blockState) || !affectedBlock.getBlockPos().equals((Object)blockPos) || !affectedBlock.getWorldRegistryKey().equals((Object)world.method_27983())) continue;
            affectedBlock.setPlaced();
        }
    }
}

