/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.monkeyconfig.settings;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.monkeyconfig.MonkeyConfig;
import xd.arkosammy.monkeyconfig.settings.AbstractCommandControllableSetting;
import xd.arkosammy.monkeyconfig.settings.ConfigSetting;
import xd.arkosammy.monkeyconfig.settings.NumberSetting;
import xd.arkosammy.monkeyconfig.settings.NumberSettingKt;
import xd.arkosammy.monkeyconfig.types.NumberType;
import xd.arkosammy.monkeyconfig.util.SettingLocation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012 \u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0003:\u0001/BG\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u000b\u001a\u00028\u0000\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0011J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0011J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0011J%\u0010\u001b\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\bH\u0016\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\f\u001a\u0004\u0018\u00018\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\"R\u0016\u0010\r\u001a\u0004\u0018\u00018\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\"R$\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010*\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040'8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R&\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00028\u00000'8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011\u00a8\u00060"}, d2={"Lxd/arkosammy/monkeyconfig/settings/NumberSetting;", "", "T", "Lxd/arkosammy/monkeyconfig/settings/AbstractCommandControllableSetting;", "Lxd/arkosammy/monkeyconfig/types/NumberType;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Lxd/arkosammy/monkeyconfig/util/SettingLocation;", "settingLocation", "", "comment", "defaultValue", "value", "lowerBound", "upperBound", "<init>", "(Lxd/arkosammy/monkeyconfig/util/SettingLocation;Ljava/lang/String;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getByteArgumentType", "()Lcom/mojang/brigadier/arguments/ArgumentType;", "getShortArgumentType", "getIntegerArgumentType", "getLongArgumentType", "getFloatArgumentType", "getDoubleArgumentType", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "ctx", "argumentName", "getArgumentValue", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/Number;", "number", "convertNumberToTypeT", "(Ljava/lang/Number;)Ljava/lang/Number;", "toString", "()Ljava/lang/String;", "Ljava/lang/Number;", "getValue", "()Ljava/lang/Number;", "setValue", "(Ljava/lang/Number;)V", "Lkotlin/Function1;", "getValueToSerializedConverter", "()Lkotlin/jvm/functions/Function1;", "valueToSerializedConverter", "getSerializedToValueConverter", "serializedToValueConverter", "getArgumentType", "argumentType", "Builder", "monkeyconfig"})
public class NumberSetting<T extends Number>
extends AbstractCommandControllableSetting<T, NumberType<T>, ArgumentType<T>> {
    @Nullable
    private final T lowerBound;
    @Nullable
    private final T upperBound;

    @JvmOverloads
    public NumberSetting(@NotNull SettingLocation settingLocation, @Nullable String comment, @NotNull T defaultValue, @NotNull T value, @Nullable T lowerBound, @Nullable T upperBound) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super(settingLocation, comment, defaultValue, value);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public /* synthetic */ NumberSetting(SettingLocation settingLocation, String string, Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            number2 = number;
        }
        if ((n & 0x10) != 0) {
            number3 = null;
        }
        if ((n & 0x20) != 0) {
            number4 = null;
        }
        this(settingLocation, string, number, number2, number3, number4);
    }

    @Override
    @NotNull
    public T getValue() {
        return (T)((Number)super.getValue());
    }

    @Override
    public void setValue(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.lowerBound != null && NumberSettingKt.compareTo(value, this.lowerBound) < 0) {
            MonkeyConfig.INSTANCE.getLOGGER().error("Value " + value + " for setting " + this.getSettingLocation() + " is below the lower bound!");
            return;
        }
        if (this.upperBound != null && NumberSettingKt.compareTo(value, this.upperBound) > 0) {
            MonkeyConfig.INSTANCE.getLOGGER().error("Value " + value + " for setting " + this.getSettingLocation() + " is above the upper bound!");
            return;
        }
        super.setValue(this.convertNumberToTypeT((Number)value));
    }

    @Override
    @NotNull
    protected Function1<T, NumberType<T>> getValueToSerializedConverter() {
        return valueToSerializedConverter.1.INSTANCE;
    }

    @Override
    @NotNull
    protected Function1<NumberType<T>, T> getSerializedToValueConverter() {
        return serializedToValueConverter.1.INSTANCE;
    }

    @Override
    @NotNull
    public ArgumentType<T> getArgumentType() throws IllegalArgumentException {
        ArgumentType<T> argumentType;
        Number number = (Number)this.getDefaultValue();
        if (number instanceof Byte) {
            argumentType = this.getByteArgumentType();
        } else if (number instanceof Short) {
            argumentType = this.getShortArgumentType();
        } else if (number instanceof Integer) {
            argumentType = this.getIntegerArgumentType();
        } else if (number instanceof Long) {
            argumentType = this.getLongArgumentType();
        } else if (number instanceof Float) {
            argumentType = this.getFloatArgumentType();
        } else if (number instanceof Double) {
            argumentType = this.getDoubleArgumentType();
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + this.getDefaultValue().getClass());
        }
        return argumentType;
    }

    private final ArgumentType<T> getByteArgumentType() {
        int n = -128;
        T t = this.lowerBound;
        int n2 = t != null ? ((Number)t).intValue() : -128;
        int min = Math.max(n, n2);
        n2 = 127;
        T t2 = this.upperBound;
        int n3 = t2 != null ? ((Number)t2).intValue() : 127;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getShortArgumentType() {
        int n = Short.MIN_VALUE;
        T t = this.lowerBound;
        int n2 = t != null ? ((Number)t).intValue() : Short.MIN_VALUE;
        int min = Math.max(n, n2);
        n2 = Short.MAX_VALUE;
        T t2 = this.upperBound;
        int n3 = t2 != null ? ((Number)t2).intValue() : Short.MAX_VALUE;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getIntegerArgumentType() {
        int n = Integer.MIN_VALUE;
        T t = this.lowerBound;
        int n2 = t != null ? ((Number)t).intValue() : Integer.MIN_VALUE;
        int min = Math.max(n, n2);
        n2 = Integer.MAX_VALUE;
        T t2 = this.upperBound;
        int n3 = t2 != null ? ((Number)t2).intValue() : Integer.MAX_VALUE;
        int max = Math.min(n2, n3);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)min, (int)max);
        Intrinsics.checkNotNull((Object)integerArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)integerArgumentType;
    }

    private final ArgumentType<T> getLongArgumentType() {
        long l = Long.MIN_VALUE;
        T t = this.lowerBound;
        long l2 = t != null ? ((Number)t).longValue() : Long.MIN_VALUE;
        long min = Math.max(l, l2);
        l2 = Long.MAX_VALUE;
        T t2 = this.upperBound;
        long l3 = t2 != null ? ((Number)t2).longValue() : Long.MAX_VALUE;
        long max = Math.min(l2, l3);
        LongArgumentType longArgumentType = LongArgumentType.longArg((long)min, (long)max);
        Intrinsics.checkNotNull((Object)longArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)longArgumentType;
    }

    private final ArgumentType<T> getFloatArgumentType() {
        float f = Float.MIN_VALUE;
        T t = this.lowerBound;
        float f2 = t != null ? ((Number)t).floatValue() : Float.MIN_VALUE;
        float min = Math.max(f, f2);
        f2 = Float.MAX_VALUE;
        T t2 = this.upperBound;
        float f3 = t2 != null ? ((Number)t2).floatValue() : Float.MAX_VALUE;
        float max = Math.min(f2, f3);
        FloatArgumentType floatArgumentType = FloatArgumentType.floatArg((float)min, (float)max);
        Intrinsics.checkNotNull((Object)floatArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)floatArgumentType;
    }

    private final ArgumentType<T> getDoubleArgumentType() {
        double d = Double.MIN_VALUE;
        T t = this.lowerBound;
        double d2 = t != null ? ((Number)t).doubleValue() : Double.MIN_VALUE;
        double min = Math.max(d, d2);
        d2 = Double.MAX_VALUE;
        T t2 = this.upperBound;
        double d3 = t2 != null ? ((Number)t2).doubleValue() : Double.MAX_VALUE;
        double max = Math.min(d2, d3);
        DoubleArgumentType doubleArgumentType = DoubleArgumentType.doubleArg((double)min, (double)max);
        Intrinsics.checkNotNull((Object)doubleArgumentType, (String)"null cannot be cast to non-null type com.mojang.brigadier.arguments.ArgumentType<T of xd.arkosammy.monkeyconfig.settings.NumberSetting>");
        return (ArgumentType)doubleArgumentType;
    }

    @Override
    @NotNull
    public T getArgumentValue(@NotNull CommandContext<class_2168> ctx, @NotNull String argumentName) {
        Number number;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Number number2 = (Number)this.getDefaultValue();
        if (number2 instanceof Byte || number2 instanceof Short || number2 instanceof Integer) {
            number = IntegerArgumentType.getInteger(ctx, (String)argumentName);
        } else if (number2 instanceof Long) {
            number = LongArgumentType.getLong(ctx, (String)argumentName);
        } else if (number2 instanceof Float) {
            number = Float.valueOf(FloatArgumentType.getFloat(ctx, (String)argumentName));
        } else if (number2 instanceof Double) {
            number = DoubleArgumentType.getDouble(ctx, (String)argumentName);
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + this.getDefaultValue().getClass());
        }
        return (T)number;
    }

    private final T convertNumberToTypeT(Number number) {
        Number number2;
        Number number3 = (Number)this.getDefaultValue();
        if (number3 instanceof Byte) {
            number2 = number.byteValue();
        } else if (number3 instanceof Short) {
            number2 = number.shortValue();
        } else if (number3 instanceof Integer) {
            number2 = number.intValue();
        } else if (number3 instanceof Long) {
            number2 = number.longValue();
        } else if (number3 instanceof Float) {
            number2 = Float.valueOf(number.floatValue());
        } else if (number3 instanceof Double) {
            number2 = number.doubleValue();
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + this.getDefaultValue().getClass());
        }
        return (T)number2;
    }

    @Override
    @NotNull
    public String toString() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        String string2 = Reflection.getOrCreateKotlinClass(this.getValue().getClass()).getSimpleName();
        SettingLocation settingLocation = this.getSettingLocation();
        String string3 = this.getComment();
        if (string3 == null) {
            string3 = "null";
        }
        T t = this.lowerBound;
        T t2 = this.upperBound;
        return string + "{numType=" + string2 + ", location=" + settingLocation + ", comment=" + string3 + ", defaultValue=" + this.getDefaultValue() + "}, value=" + (Number)this.getValue() + ", serializedType=" + Reflection.getOrCreateKotlinClass(this.getSerializedDefaultValue().getClass()).getSimpleName() + ", lowerBound=" + (t != null ? (Serializable)t : (Serializable)((Object)"null")) + ", upperBound=" + (t2 != null ? (Serializable)t2 : (Serializable)((Object)"null")) + "}";
    }

    @JvmOverloads
    public NumberSetting(@NotNull SettingLocation settingLocation, @Nullable String comment, @NotNull T defaultValue, @NotNull T value, @Nullable T lowerBound) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this(settingLocation, comment, (Number)defaultValue, (Number)value, (Number)lowerBound, null, 32, null);
    }

    @JvmOverloads
    public NumberSetting(@NotNull SettingLocation settingLocation, @Nullable String comment, @NotNull T defaultValue, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this(settingLocation, comment, (Number)defaultValue, (Number)value, null, null, 48, null);
    }

    @JvmOverloads
    public NumberSetting(@NotNull SettingLocation settingLocation, @Nullable String comment, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        this(settingLocation, comment, (Number)defaultValue, null, null, null, 56, null);
    }

    @JvmOverloads
    public NumberSetting(@NotNull SettingLocation settingLocation, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        this(settingLocation, null, (Number)defaultValue, null, null, null, 58, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0002*\u00020\u00012 \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u0003B%\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R$\u0010\r\u001a\u0004\u0018\u00018\u00018\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0010\u001a\u0004\u0018\u00018\u00018\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lxd/arkosammy/monkeyconfig/settings/NumberSetting$Builder;", "", "T", "Lxd/arkosammy/monkeyconfig/settings/ConfigSetting$Builder;", "Lxd/arkosammy/monkeyconfig/settings/NumberSetting;", "Lxd/arkosammy/monkeyconfig/types/NumberType;", "Lxd/arkosammy/monkeyconfig/util/SettingLocation;", "settingLocation", "", "comment", "defaultValue", "<init>", "(Lxd/arkosammy/monkeyconfig/util/SettingLocation;Ljava/lang/String;Ljava/lang/Number;)V", "lowerBound", "withLowerBound", "(Ljava/lang/Number;)Lxd/arkosammy/monkeyconfig/settings/NumberSetting$Builder;", "upperBound", "withUpperBound", "build", "()Lxd/arkosammy/monkeyconfig/settings/NumberSetting;", "Ljava/lang/Number;", "getLowerBound", "()Ljava/lang/Number;", "setLowerBound", "(Ljava/lang/Number;)V", "getUpperBound", "setUpperBound", "monkeyconfig"})
    public static class Builder<T extends Number>
    extends ConfigSetting.Builder<NumberSetting<T>, T, NumberType<T>> {
        @Nullable
        private T lowerBound;
        @Nullable
        private T upperBound;

        @JvmOverloads
        public Builder(@NotNull SettingLocation settingLocation, @Nullable String comment, @NotNull T defaultValue) {
            Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            super(settingLocation, comment, defaultValue);
        }

        public /* synthetic */ Builder(SettingLocation settingLocation, String string, Number number, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(settingLocation, string, number);
        }

        @Nullable
        protected final T getLowerBound() {
            return this.lowerBound;
        }

        protected final void setLowerBound(@Nullable T t) {
            this.lowerBound = t;
        }

        @Nullable
        protected final T getUpperBound() {
            return this.upperBound;
        }

        protected final void setUpperBound(@Nullable T t) {
            this.upperBound = t;
        }

        @NotNull
        public final Builder<T> withLowerBound(@NotNull T lowerBound) {
            Intrinsics.checkNotNullParameter(lowerBound, (String)"lowerBound");
            this.lowerBound = lowerBound;
            return this;
        }

        @NotNull
        public final Builder<T> withUpperBound(@NotNull T upperBound) {
            Intrinsics.checkNotNullParameter(upperBound, (String)"upperBound");
            this.upperBound = upperBound;
            return this;
        }

        @Override
        @NotNull
        public NumberSetting<T> build() {
            return new NumberSetting<Number>(this.getSettingLocation(), this.getComment(), (Number)this.getDefaultValue(), (Number)this.getDefaultValue(), (Number)this.lowerBound, (Number)this.upperBound);
        }

        @JvmOverloads
        public Builder(@NotNull SettingLocation settingLocation, @NotNull T defaultValue) {
            Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            this(settingLocation, null, (Number)defaultValue, 2, null);
        }
    }
}

