/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.explosions.factories.ExplosionEventFactory;
import xd.arkosammy.creeperhealing.managers.ExplosionManager;
import xd.arkosammy.creeperhealing.util.ExplosionContext;

public final class ExplosionManagerRegistrar {
    private static ExplosionManagerRegistrar instance;
    private final List<ExplosionManager> explosionManagers = new ArrayList<ExplosionManager>();

    public static ExplosionManagerRegistrar getInstance() {
        if (instance == null) {
            instance = new ExplosionManagerRegistrar();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExplosionManager(ExplosionManager explosionManager) {
        List<ExplosionManager> list = this.explosionManagers;
        synchronized (list) {
            class_2960 explosionManagerId = explosionManager.getId();
            for (ExplosionManager manager : this.explosionManagers) {
                if (!manager.getId().equals((Object)explosionManagerId)) continue;
                throw new IllegalArgumentException("Cannot register ExplosionManager with ID \"%s\" as an ExplosionManager with that ID has already been registered!".formatted(explosionManagerId));
            }
            this.explosionManagers.add(explosionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitExplosionContext(class_2960 explosionManagerId, ExplosionContext explosionContext) {
        List<ExplosionManager> list = this.explosionManagers;
        synchronized (list) {
            for (ExplosionManager explosionManager : this.explosionManagers) {
                if (!explosionManager.getId().equals((Object)explosionManagerId)) continue;
                ExplosionEventFactory<?> explosionEventFactory = explosionManager.getExplosionContextToEventFactoryFunction().apply(explosionContext);
                explosionManager.addExplosionEvent(explosionEventFactory);
                return;
            }
            CreeperHealing.LOGGER.warn("Found no ExplosionManager with ID {}. An explosion will not be healed", (Object)explosionManagerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnServerStarting(MinecraftServer server) {
        List<ExplosionManager> list = this.explosionManagers;
        synchronized (list) {
            for (ExplosionManager explosionManager : this.explosionManagers) {
                explosionManager.onServerStarting(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnServerStopping(MinecraftServer server) {
        List<ExplosionManager> list = this.explosionManagers;
        synchronized (list) {
            for (ExplosionManager explosionManager : this.explosionManagers) {
                explosionManager.onServerStopping(server);
            }
        }
    }
}

