/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.blocks.DoubleAffectedBlock;
import xd.arkosammy.creeperhealing.blocks.SerializedAffectedBlock;
import xd.arkosammy.creeperhealing.blocks.SingleAffectedBlock;

public record DefaultSerializedAffectedBlock(String affectedBlockType, class_2338 pos, class_2680 state, class_5321<class_1937> worldRegistryKey, @Nullable class_2487 nbt, long blockTimer, boolean placed) implements SerializedAffectedBlock
{
    public static final Codec<SerializedAffectedBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("affected_block_type").forGetter(SerializedAffectedBlock::getAffectedBlockTypeName), (App)class_2338.field_25064.fieldOf("block_pos").forGetter(SerializedAffectedBlock::getBlockPos), (App)class_2680.field_24734.fieldOf("block_state").forGetter(SerializedAffectedBlock::getBlockState), (App)class_1937.field_25178.fieldOf("world").forGetter(SerializedAffectedBlock::getWorldRegistryKey), (App)class_2487.field_25128.optionalFieldOf("nbt_data").forGetter(serializedAffectedBlock -> serializedAffectedBlock.getCustomData("nbt", class_2487.class)), (App)Codec.LONG.fieldOf("affected_block_timer").forGetter(SerializedAffectedBlock::getBlockTimer), (App)Codec.BOOL.fieldOf("is_placed").forGetter(SerializedAffectedBlock::isPlaced)).apply((Applicative)instance, (affectedBlockType, blockPos, blockState, world, optionalNbt, affectedBlockTimer, isPlaced) -> new DefaultSerializedAffectedBlock((String)affectedBlockType, (class_2338)blockPos, (class_2680)blockState, (class_5321<class_1937>)world, optionalNbt.orElse(null), (long)affectedBlockTimer, (boolean)isPlaced)));

    @Override
    public String getAffectedBlockTypeName() {
        return this.affectedBlockType;
    }

    @Override
    public class_2338 getBlockPos() {
        return this.pos;
    }

    @Override
    public class_2680 getBlockState() {
        return this.state;
    }

    @Override
    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    @Override
    public long getBlockTimer() {
        return this.blockTimer;
    }

    @Override
    public boolean isPlaced() {
        return this.placed;
    }

    @Override
    public <T> Optional<T> getCustomData(String name, Class<T> clazz) {
        class_2487 data;
        switch (name) {
            case "nbt": {
                class_2487 class_24872 = this.nbt;
                break;
            }
            default: {
                CreeperHealing.LOGGER.warn("Tried to get unexpected property of name \"{}\" while serializing an affected block!", (Object)name);
                class_2487 class_24872 = data = null;
            }
        }
        if (clazz.isInstance(data)) {
            return Optional.of(data);
        }
        if (data == null) {
            return Optional.empty();
        }
        CreeperHealing.LOGGER.error("Unsuccessfully tried to cast property with name \"{}\" of type \"{}\" to \"{}\" while serializing an affected block!", new Object[]{name, data.getClass().getSimpleName(), clazz.getSimpleName()});
        return Optional.empty();
    }

    @Override
    public AffectedBlock asDeserialized() {
        return switch (this.affectedBlockType) {
            case "double_affected_block" -> new DoubleAffectedBlock(this.pos, this.state(), this.worldRegistryKey(), this.getBlockTimer(), this.placed());
            default -> new SingleAffectedBlock(this.pos(), this.state(), this.worldRegistryKey(), this.nbt(), this.getBlockTimer(), this.placed());
        };
    }
}

