/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.blocks;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.blocks.SingleAffectedBlock;
import xd.arkosammy.creeperhealing.config.ConfigUtils;
import xd.arkosammy.creeperhealing.config.SettingGroups;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;
import xd.arkosammy.monkeyconfig.groups.SettingGroup;
import xd.arkosammy.monkeyconfig.groups.maps.StringMapSettingGroup;

public class DoubleAffectedBlock
extends SingleAffectedBlock {
    public static final String TYPE = "double_affected_block";

    protected DoubleAffectedBlock(class_2338 pos, class_2680 state, class_5321<class_1937> registryKey, long affectedBlockTimer, boolean placed) {
        super(pos, state, registryKey, null, affectedBlockTimer, placed);
    }

    @Override
    protected String getAffectedBlockType() {
        return TYPE;
    }

    @Override
    public void tryHealing(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        StringMapSettingGroup replaceMapGroup;
        String replaceMapValue;
        class_2680 state = this.getBlockState();
        String blockIdentifier = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        SettingGroup settingGroup = ConfigUtils.getSettingGroup(SettingGroups.REPLACE_MAP.getName());
        if (settingGroup instanceof StringMapSettingGroup && (replaceMapValue = (String)(replaceMapGroup = (StringMapSettingGroup)settingGroup).get(blockIdentifier)) != null) {
            super.tryHealing(server, currentExplosionEvent);
            return;
        }
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            this.handleDoubleBlocks(server, currentExplosionEvent);
        } else if (state.method_28498((class_2769)class_2741.field_12483)) {
            this.handleBedPart(server, currentExplosionEvent);
        } else {
            super.tryHealing(server, currentExplosionEvent);
        }
    }

    private void handleDoubleBlocks(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2680 firstHalfState = this.getBlockState();
        class_2338 firstHalfPos = this.getBlockPos();
        class_1937 world = this.getWorld(server);
        class_2756 secondHalf = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? class_2756.field_12607 : class_2756.field_12609;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12533, (Comparable)secondHalf);
        class_2338 class_23382 = secondHalfPos = ((class_2756)secondHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? firstHalfPos.method_10084() : firstHalfPos.method_10074();
        if (!this.shouldHealBlock(world, secondHalfPos)) {
            return;
        }
        class_2680 stateToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfState : secondHalfState;
        class_2338 posToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfPos : firstHalfPos.method_10074();
        ExplosionUtils.pushEntitiesUpwards(world, posToPushFrom, stateToPushFrom, true);
        this.placeDoubleBlock((class_3545<class_2338, class_2680>)new class_3545((Object)firstHalfPos, (Object)firstHalfState), (class_3545<class_2338, class_2680>)new class_3545((Object)secondHalfPos, (Object)secondHalfState), world);
        if (currentExplosionEvent instanceof AbstractExplosionEvent) {
            AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)currentExplosionEvent;
            abstractExplosionEvent.findAndMarkPlaced(secondHalfPos, secondHalfState, world);
        }
    }

    private void handleBedPart(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2680 firstHalfState = this.getBlockState();
        class_2338 firstHalfPos = this.getBlockPos();
        class_1937 world = this.getWorld(server);
        class_2742 secondBedPart = ((class_2742)firstHalfState.method_11654((class_2769)class_2741.field_12483)).equals((Object)class_2742.field_12560) ? class_2742.field_12557 : class_2742.field_12560;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12483, (Comparable)secondBedPart);
        class_2350 firstBedPartOrientation = (class_2350)firstHalfState.method_11654((class_2769)class_2741.field_12481);
        block0 : switch (secondBedPart) {
            default: {
                throw new MatchException(null, null);
            }
            case field_12560: {
                class_2338 class_23382;
                switch (firstBedPartOrientation) {
                    case field_11043: {
                        class_23382 = firstHalfPos.method_10095();
                        break block0;
                    }
                    case field_11035: {
                        class_23382 = firstHalfPos.method_10072();
                        break block0;
                    }
                    case field_11034: {
                        class_23382 = firstHalfPos.method_10078();
                        break block0;
                    }
                }
                class_23382 = firstHalfPos.method_10067();
                break;
            }
            case field_12557: {
                class_2338 class_23382;
                switch (firstBedPartOrientation) {
                    case field_11043: {
                        class_23382 = firstHalfPos.method_10072();
                        break block0;
                    }
                    case field_11035: {
                        class_23382 = firstHalfPos.method_10095();
                        break block0;
                    }
                    case field_11034: {
                        class_23382 = firstHalfPos.method_10067();
                        break block0;
                    }
                }
                class_23382 = secondHalfPos = firstHalfPos.method_10078();
            }
        }
        if (!this.shouldHealBlock(world, secondHalfPos)) {
            return;
        }
        ExplosionUtils.pushEntitiesUpwards(world, firstHalfPos, firstHalfState, false);
        ExplosionUtils.pushEntitiesUpwards(world, secondHalfPos, secondHalfState, false);
        this.placeDoubleBlock((class_3545<class_2338, class_2680>)new class_3545((Object)firstHalfPos, (Object)firstHalfState), (class_3545<class_2338, class_2680>)new class_3545((Object)secondHalfPos, (Object)secondHalfState), world);
        if (currentExplosionEvent instanceof AbstractExplosionEvent) {
            AbstractExplosionEvent abstractExplosionEvent = (AbstractExplosionEvent)currentExplosionEvent;
            abstractExplosionEvent.findAndMarkPlaced(secondHalfPos, secondHalfState, world);
        }
    }

    private void placeDoubleBlock(class_3545<class_2338, class_2680> first, class_3545<class_2338, class_2680> second, class_1937 world) {
        world.method_8501((class_2338)first.method_15442(), (class_2680)first.method_15441());
        world.method_8501((class_2338)second.method_15442(), (class_2680)second.method_15441());
        ExplosionUtils.playBlockPlacementSoundEffect(world, (class_2338)first.method_15442(), (class_2680)first.method_15441());
        ExplosionUtils.spawnParticles(world, (class_2338)first.method_15442());
    }

    @Override
    protected boolean shouldHealBlock(class_1937 world, class_2338 secondBlockPos) {
        return world.method_8320(this.getBlockPos()).method_45474() && world.method_8320(secondBlockPos).method_45474();
    }

    @Override
    public String toString() {
        return "DoubleAffectedBlock(pos=%s, state=%s, world=%s, timer=%s, placed=%s)".formatted(this.getBlockPos(), this.getBlockState(), this.getWorldRegistryKey(), this.getBlockTimer(), this.isPlaced());
    }
}

