/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.ConfigSettings;
import xd.arkosammy.monkeyconfig.groups.SettingGroup;
import xd.arkosammy.monkeyconfig.managers.ConfigManager;
import xd.arkosammy.monkeyconfig.managers.ConfigManagerExtensionsKt;
import xd.arkosammy.monkeyconfig.settings.ConfigSetting;
import xd.arkosammy.monkeyconfig.settings.EnumSetting;
import xd.arkosammy.monkeyconfig.settings.NumberSetting;
import xd.arkosammy.monkeyconfig.util.SettingLocation;

public final class ConfigUtils {
    public static double DEFAULT_EXPLOSION_HEAL_DELAY = 3.0;
    public static double DEFAULT_BLOCK_PLACEMENT_DELAY = 1.0;

    private ConfigUtils() {
    }

    public static SettingGroup getSettingGroup(String groupName) {
        SettingGroup settingGroup = CreeperHealing.CONFIG_MANAGER.getSettingGroup(groupName);
        if (settingGroup == null) {
            throw new IllegalArgumentException("No setting group with name " + groupName + " was found on Config Manager for file" + CreeperHealing.CONFIG_MANAGER.getConfigName());
        }
        return settingGroup;
    }

    public static <V, T extends ConfigSetting<V, ?>> V getSettingValue(SettingLocation settingLocation, Class<T> clazz) {
        ConfigSetting setting = CreeperHealing.CONFIG_MANAGER.getTypedSetting(settingLocation, clazz);
        if (setting == null) {
            throw new IllegalArgumentException("No setting with location " + String.valueOf(settingLocation) + " with type " + clazz.getSimpleName() + " was found on Config Manager for file " + CreeperHealing.CONFIG_MANAGER.getConfigName());
        }
        return (V)setting.getValue();
    }

    public static <E extends Enum<E>> E getEnumSettingValue(SettingLocation settingLocation) {
        EnumSetting enumSetting = ConfigManagerExtensionsKt.getAsEnumSetting((ConfigManager)CreeperHealing.CONFIG_MANAGER, (SettingLocation)settingLocation);
        if (enumSetting == null) {
            throw new IllegalArgumentException("No enum setting with location " + String.valueOf(settingLocation) + " was found on Config Manager for file " + CreeperHealing.CONFIG_MANAGER.getConfigName());
        }
        return (E)((Enum)enumSetting.getValue());
    }

    public static long getExplosionHealDelay() {
        NumberSetting explosionHealDelaySetting = ConfigManagerExtensionsKt.getAsDoubleSetting((ConfigManager)CreeperHealing.CONFIG_MANAGER, (SettingLocation)ConfigSettings.EXPLOSION_HEAL_DELAY.getSettingLocation());
        double healDelay = explosionHealDelaySetting == null ? DEFAULT_EXPLOSION_HEAL_DELAY : (Double)explosionHealDelaySetting.getValue();
        long rounded = Math.round(Math.max(0.0, healDelay) * 20.0);
        return rounded == 0L ? 20L : rounded;
    }

    public static long getBlockPlacementDelay() {
        NumberSetting blockPlacementDelaySetting = ConfigManagerExtensionsKt.getAsDoubleSetting((ConfigManager)CreeperHealing.CONFIG_MANAGER, (SettingLocation)ConfigSettings.BLOCK_PLACEMENT_DELAY.getSettingLocation());
        double blockPlacementDelay = blockPlacementDelaySetting == null ? DEFAULT_BLOCK_PLACEMENT_DELAY : (Double)blockPlacementDelaySetting.getValue();
        long rounded = Math.round(Math.max(0.0, blockPlacementDelay) * 20.0);
        return rounded == 0L ? 20L : rounded;
    }
}

