/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.blocks.DefaultSerializedAffectedBlock;
import xd.arkosammy.creeperhealing.blocks.SerializedAffectedBlock;
import xd.arkosammy.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DaytimeExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DefaultExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.explosions.SerializedExplosionEvent;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;

public record DefaultSerializedExplosion(String healingMode, List<SerializedAffectedBlock> serializedAffectedBlocks, long healTimer, int blockCounter, int radius, class_2338 center) implements SerializedExplosionEvent
{
    public static final Codec<SerializedExplosionEvent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("healing_mode").forGetter(SerializedExplosionEvent::getExplosionTypeName), (App)Codec.list(DefaultSerializedAffectedBlock.CODEC).fieldOf("affected_blocks").forGetter(SerializedExplosionEvent::getSerializedAffectedBlocks), (App)Codec.LONG.fieldOf("heal_timer").forGetter(SerializedExplosionEvent::getHealTimer), (App)Codec.INT.fieldOf("block_counter").forGetter(serializedExplosionEvent -> serializedExplosionEvent.getCustomData("blockCounter", Integer.class).orElse(0)), (App)Codec.INT.fieldOf("radius").forGetter(serializedExplosionEvent -> serializedExplosionEvent.getCustomData("radius", Integer.class).orElse(3)), (App)class_2338.field_25064.fieldOf("center").forGetter(serializedExplosionEvent -> serializedExplosionEvent.getCustomData("center", class_2338.class).orElse(ExplosionUtils.calculateCenter(serializedExplosionEvent.getSerializedAffectedBlocks().stream().map(SerializedAffectedBlock::getBlockPos).toList())))).apply((Applicative)instance, DefaultSerializedExplosion::new));

    @Override
    public String getExplosionTypeName() {
        return this.healingMode;
    }

    @Override
    public List<SerializedAffectedBlock> getSerializedAffectedBlocks() {
        return this.serializedAffectedBlocks;
    }

    @Override
    public long getHealTimer() {
        return this.healTimer;
    }

    @Override
    public <T> Optional<T> getCustomData(String name, Class<T> clazz) {
        Object data;
        switch (name) {
            case "blockCounter": {
                Object object = this.blockCounter;
                break;
            }
            case "radius": {
                Object object = this.radius;
                break;
            }
            case "center": {
                Object object = this.center;
                break;
            }
            default: {
                CreeperHealing.LOGGER.warn("Tried to get unexpected property of name \"{}\" while serializing an explosion event!", (Object)name);
                Object object = data = null;
            }
        }
        if (clazz.isInstance(data)) {
            return Optional.of(data);
        }
        if (data == null) {
            return Optional.empty();
        }
        CreeperHealing.LOGGER.error("Unsuccessfully tried to cast property with name \"{}\" of type \"{}\" to \"{}\" while serializing an explosion event!", new Object[]{name, data.getClass().getSimpleName(), clazz.getSimpleName()});
        return Optional.empty();
    }

    @Override
    public ExplosionEvent asDeserialized() {
        ExplosionHealingMode healingMode = ExplosionHealingMode.getFromName(this.healingMode);
        List<AffectedBlock> affectedBlocks = this.serializedAffectedBlocks.stream().map(SerializedAffectedBlock::asDeserialized).collect(Collectors.toList());
        return switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter, this.radius, this.center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter, this.radius, this.center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter, this.radius, this.center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter, this.radius, this.center);
        };
    }
}

