/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions.factories;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.blocks.SingleAffectedBlock;
import xd.arkosammy.creeperhealing.config.ConfigSettings;
import xd.arkosammy.creeperhealing.config.ConfigUtils;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DaytimeExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DefaultExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.explosions.factories.ExplosionEventFactory;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;

public class DefaultExplosionFactory
implements ExplosionEventFactory<AbstractExplosionEvent> {
    private final Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities;
    private final class_1937 world;
    private final int blastRadius;
    private final Set<class_2338> affectedPositions = new HashSet<class_2338>();
    private final class_2338 center;
    private final List<class_2338> vanillaAffectedPositions;

    public DefaultExplosionFactory(Map<class_2338, class_3545<class_2680, class_2586>> affectedStatesAndBlockEntities, List<class_2338> vanillaAffectedPositions, List<class_2338> indirectlyExplodedPositions, class_1937 world) {
        this.affectedStatesAndBlockEntities = affectedStatesAndBlockEntities;
        this.world = world;
        this.affectedPositions.addAll(vanillaAffectedPositions);
        this.affectedPositions.addAll(indirectlyExplodedPositions);
        this.blastRadius = ExplosionUtils.getMaxExplosionRadius(vanillaAffectedPositions);
        this.center = ExplosionUtils.calculateCenter(vanillaAffectedPositions);
        this.vanillaAffectedPositions = vanillaAffectedPositions;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent() {
        List<AffectedBlock> affectedBlocks = this.processAffectedPositions(new ArrayList<class_2338>(this.affectedPositions), this.world);
        if (affectedBlocks == null || affectedBlocks.isEmpty()) {
            return null;
        }
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getEnumSettingValue(ConfigSettings.MODE.getSettingLocation()));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, this.blastRadius, this.center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, this.blastRadius, this.center);
        };
        explosionEvent.setup(this.world);
        return explosionEvent;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<class_2338> affectedPositions, class_1937 world) {
        List<AffectedBlock> affectedBlocks = this.processAffectedPositions(affectedPositions, world);
        if (affectedBlocks == null || affectedBlocks.isEmpty()) {
            return null;
        }
        class_2338 center = ExplosionUtils.calculateCenter(affectedPositions);
        int radius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getEnumSettingValue(ConfigSettings.MODE.getSettingLocation()));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, radius, center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, radius, center);
        };
        explosionEvent.setup(world);
        return explosionEvent;
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer) {
        return this.createExplosionEvent((List)affectedBlocks, healTimer, ConfigUtils.getBlockPlacementDelay());
    }

    @Override
    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, long blockHealDelay) {
        return this.createExplosionEvent(affectedBlocks, healTimer, blockHealDelay, 0);
    }

    @Nullable
    public AbstractExplosionEvent createExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, long blockHealDelay, int blockCounter) {
        if (affectedBlocks.isEmpty()) {
            return null;
        }
        List<class_2338> affectedPositions = affectedBlocks.stream().map(AffectedBlock::getBlockPos).toList();
        class_2338 center = ExplosionUtils.calculateCenter(affectedPositions);
        int radius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocks(affectedBlocks, this.world);
        sortedAffectedBlocks.forEach(affectedBlock -> {
            if (affectedBlock instanceof SingleAffectedBlock) {
                SingleAffectedBlock singleAffectedBlock = (SingleAffectedBlock)affectedBlock;
                singleAffectedBlock.setTimer(blockHealDelay);
            }
        });
        ExplosionHealingMode healingMode = (ExplosionHealingMode)((Object)ConfigUtils.getEnumSettingValue(ConfigSettings.MODE.getSettingLocation()));
        AbstractExplosionEvent explosionEvent = switch (healingMode) {
            default -> throw new MatchException(null, null);
            case ExplosionHealingMode.DEFAULT_MODE -> new DefaultExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(sortedAffectedBlocks, healTimer, blockCounter, radius, center);
        };
        explosionEvent.setup(this.world);
        return explosionEvent;
    }

    @Override
    public List<class_2338> getAffectedPositions() {
        return this.vanillaAffectedPositions;
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    @Nullable
    private List<AffectedBlock> processAffectedPositions(List<class_2338> affectedPositions, class_1937 world) {
        List<class_2338> positionsToHeal = ExplosionUtils.filterPositionsToHeal(affectedPositions, pos -> (class_2680)this.affectedStatesAndBlockEntities.get(pos).method_15442());
        if (positionsToHeal.isEmpty()) {
            return null;
        }
        ArrayList<AffectedBlock> affectedBlocks = new ArrayList<AffectedBlock>();
        for (class_2338 pos2 : positionsToHeal) {
            class_2680 affectedState = (class_2680)this.affectedStatesAndBlockEntities.get(pos2).method_15442();
            class_2586 affectedBlockEntity = (class_2586)this.affectedStatesAndBlockEntities.get(pos2).method_15441();
            AffectedBlock affectedBlock = AffectedBlock.newInstance(pos2, affectedState, affectedBlockEntity, world);
            affectedBlocks.add(affectedBlock);
        }
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocks(affectedBlocks, world);
        return sortedAffectedBlocks;
    }
}

