/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.config.ConfigSettings;
import xd.arkosammy.creeperhealing.config.ConfigUtils;
import xd.arkosammy.creeperhealing.util.ExcludedBlocks;
import xd.arkosammy.monkeyconfig.settings.BooleanSetting;
import xd.arkosammy.monkeyconfig.settings.list.StringListSetting;

public final class ExplosionUtils {
    public static final ThreadLocal<Boolean> DROP_BLOCK_ITEMS = ThreadLocal.withInitial(() -> true);
    public static final ThreadLocal<Boolean> DROP_CONTAINER_INVENTORY_ITEMS = ThreadLocal.withInitial(() -> true);
    public static final ThreadLocal<Boolean> FALLING_BLOCK_SCHEDULE_TICK = ThreadLocal.withInitial(() -> true);

    private ExplosionUtils() {
        throw new AssertionError();
    }

    public static void pushEntitiesUpwards(class_1937 world, class_2338 pos, class_2680 state, boolean isTallBlock) {
        if (!state.method_26212((class_1922)world, pos)) {
            return;
        }
        int amountToPush = isTallBlock ? 2 : 1;
        for (class_1297 entity : world.method_8390(class_1309.class, new class_238(pos), class_1297::method_5805)) {
            if (!ExplosionUtils.areAboveBlocksFree(world, pos, entity, amountToPush)) continue;
            entity.method_29495(entity.method_19538().method_38499(class_2350.class_2351.field_11052, (double)(entity.method_31478() + amountToPush)));
        }
    }

    private static boolean areAboveBlocksFree(class_1937 world, class_2338 pos, class_1297 entity, int amountToPush) {
        for (int i = pos.method_10264(); i < pos.method_30513(class_2350.class_2351.field_11052, (int)Math.ceil(entity.method_5751())).method_10264(); ++i) {
            class_2338 currentPos = pos.method_33096(i + amountToPush);
            if (!world.method_8320(currentPos).method_26212((class_1922)world, currentPos)) continue;
            return false;
        }
        return true;
    }

    public static List<class_2338> filterPositionsToHeal(Collection<class_2338> positions, Function<class_2338, class_2680> positionToStateMapper) {
        ArrayList<class_2338> affectedPositions = new ArrayList<class_2338>();
        boolean whitelistEnabled = (Boolean)ConfigUtils.getSettingValue(ConfigSettings.ENABLE_WHITELIST.getSettingLocation(), BooleanSetting.class);
        List whitelist = (List)ConfigUtils.getSettingValue(ConfigSettings.WHITELIST.getSettingLocation(), StringListSetting.class);
        for (class_2338 affectedPosition : positions) {
            boolean stateCannotHeal;
            class_2680 affectedState = positionToStateMapper.apply(affectedPosition);
            if (ExcludedBlocks.isExcluded(affectedState)) continue;
            boolean bl = stateCannotHeal = affectedState.method_26215() || affectedState.method_27852(class_2246.field_10375) || affectedState.method_26164(class_3481.field_21952);
            if (stateCannotHeal) continue;
            String affectedBlockIdentifier = class_7923.field_41175.method_10221((Object)affectedState.method_26204()).toString();
            boolean whitelistContainsIdentifier = whitelist.contains(affectedBlockIdentifier);
            if (whitelistEnabled && !whitelistContainsIdentifier) continue;
            affectedPositions.add(affectedPosition);
        }
        return affectedPositions;
    }

    @NotNull
    public static List<AffectedBlock> sortAffectedBlocks(@NotNull List<AffectedBlock> affectedBlocksList, class_1937 world) {
        ArrayList<AffectedBlock> sortedAffectedBlocks = new ArrayList<AffectedBlock>(affectedBlocksList);
        List<class_2338> affectedBlocksAsPositions = sortedAffectedBlocks.stream().map(AffectedBlock::getBlockPos).collect(Collectors.toList());
        int centerX = ExplosionUtils.getCenterXCoordinate(affectedBlocksAsPositions);
        int centerZ = ExplosionUtils.getCenterZCoordinate(affectedBlocksAsPositions);
        Comparator<AffectedBlock> distanceToCenterComparator = Comparator.comparingInt(affectedBlock -> (int)(-Math.round(Math.pow(affectedBlock.getBlockPos().method_10263() - centerX, 2.0) + Math.pow(affectedBlock.getBlockPos().method_10260() - centerZ, 2.0))));
        sortedAffectedBlocks.sort(distanceToCenterComparator);
        Comparator<AffectedBlock> yLevelComparator = Comparator.comparingInt(affectedBlock -> affectedBlock.getBlockPos().method_10264());
        sortedAffectedBlocks.sort(yLevelComparator);
        Comparator transparencyComparator = (currentAffectedBlock, nextAffectedBlock) -> {
            boolean isCurrentAffectedBlockTransparent = currentAffectedBlock.getBlockState().method_26167((class_1922)world, currentAffectedBlock.getBlockPos());
            boolean isNextAffectedBlockTransparent = nextAffectedBlock.getBlockState().method_26167((class_1922)world, nextAffectedBlock.getBlockPos());
            return Boolean.compare(isCurrentAffectedBlockTransparent, isNextAffectedBlockTransparent);
        };
        sortedAffectedBlocks.sort(transparencyComparator);
        return sortedAffectedBlocks;
    }

    public static class_2338 calculateCenter(Collection<class_2338> affectedPositions) {
        int centerX = ExplosionUtils.getCenterXCoordinate(affectedPositions);
        int centerY = ExplosionUtils.getCenterYCoordinate(affectedPositions);
        int centerZ = ExplosionUtils.getCenterZCoordinate(affectedPositions);
        return new class_2338(centerX, centerY, centerZ);
    }

    public static int getCenterXCoordinate(Collection<class_2338> affectedCoordinates) {
        int maxX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).max().orElse(0);
        int minX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).min().orElse(0);
        return (maxX + minX) / 2;
    }

    public static int getCenterYCoordinate(Collection<class_2338> affectedCoordinates) {
        int maxY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).max().orElse(0);
        int minY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).min().orElse(0);
        return (maxY + minY) / 2;
    }

    public static int getCenterZCoordinate(Collection<class_2338> affectedCoordinates) {
        int maxZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        int minZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).min().orElse(0);
        return (maxZ + minZ) / 2;
    }

    public static int getMaxExplosionRadius(Collection<class_2338> affectedCoordinates) {
        int[] radii = new int[3];
        int maxX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).max().orElse(0);
        int minX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).min().orElse(0);
        radii[0] = (maxX - minX) / 2;
        int maxY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).max().orElse(0);
        int minY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).min().orElse(0);
        radii[1] = (maxY - minY) / 2;
        int maxZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        int minZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).min().orElse(0);
        radii[2] = (maxZ - minZ) / 2;
        return Arrays.stream(radii).max().orElse(0);
    }

    public static void playBlockPlacementSoundEffect(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        boolean doPlacementSoundEffect;
        boolean placementSoundEffectSetting = (Boolean)ConfigUtils.getSettingValue(ConfigSettings.BLOCK_PLACEMENT_SOUND_EFFECT.getSettingLocation(), BooleanSetting.class);
        boolean bl = doPlacementSoundEffect = placementSoundEffectSetting && !world.method_8608() && !blockState.method_26215();
        if (!doPlacementSoundEffect) {
            return;
        }
        world.method_8396(null, blockPos, blockState.method_26231().method_10598(), class_3419.field_15245, blockState.method_26231().method_10597(), blockState.method_26231().method_10599());
    }

    public static void spawnParticles(class_1937 world, class_2338 blockPos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        boolean blockPlacementParticlesSetting = (Boolean)ConfigUtils.getSettingValue(ConfigSettings.BLOCK_PLACEMENT_PARTICLES.getSettingLocation(), BooleanSetting.class);
        if (!blockPlacementParticlesSetting) {
            return;
        }
        serverWorld.method_14199((class_2394)class_2398.field_11204, (double)blockPos.method_10263(), (double)(blockPos.method_10264() + 2), (double)blockPos.method_10260(), 1, 0.0, 1.0, 0.0, 0.001);
    }
}

