/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.monkeyconfig.managers;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.monkeyconfig.MonkeyConfig;
import xd.arkosammy.monkeyconfig.groups.DefaultMutableSettingGroup;
import xd.arkosammy.monkeyconfig.groups.MutableSettingGroup;
import xd.arkosammy.monkeyconfig.groups.SettingGroup;
import xd.arkosammy.monkeyconfig.managers.ConfigManager;
import xd.arkosammy.monkeyconfig.settings.ConfigSetting;
import xd.arkosammy.monkeyconfig.util.SettingLocation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fBQ\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0004\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\u0004\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJA\u0010\"\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u001b\"\u0012\b\u0001\u0010\u001d*\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016\u00a2\u0006\u0004\b\"\u0010#J#\u0010'\u001a\u00020\u00142\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00140$H\u0004\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00112\u0006\u0010)\u001a\u00020%H\u0004\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b,\u0010\u0013J\u000f\u0010-\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b-\u0010.R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010/\u001a\u0004\b0\u00101R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00102\u001a\u0004\b3\u0010.R*\u00106\u001a\u0012\u0012\u0006\b\u0001\u0012\u000205\u0012\u0006\b\u0001\u0012\u00020%048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\t8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lxd/arkosammy/monkeyconfig/managers/AbstractConfigManager;", "Lxd/arkosammy/monkeyconfig/managers/ConfigManager;", "", "configName", "", "Lxd/arkosammy/monkeyconfig/groups/SettingGroup;", "settingGroups", "Lcom/electronwill/nightconfig/core/ConfigFormat;", "configFormat", "Ljava/nio/file/Path;", "configPath", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/electronwill/nightconfig/core/ConfigFormat;Ljava/nio/file/Path;)V", "Lxd/arkosammy/monkeyconfig/groups/MutableSettingGroup;", "Lxd/arkosammy/monkeyconfig/settings/ConfigSetting$Builder;", "settingBuilders", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/electronwill/nightconfig/core/ConfigFormat;Ljava/nio/file/Path;)V", "", "initialize", "()V", "", "reloadFromFile", "()Z", "saveToFile", "groupName", "getSettingGroup", "(Ljava/lang/String;)Lxd/arkosammy/monkeyconfig/groups/SettingGroup;", "V", "Lxd/arkosammy/monkeyconfig/settings/ConfigSetting;", "T", "Lxd/arkosammy/monkeyconfig/util/SettingLocation;", "settingLocation", "Ljava/lang/Class;", "settingClass", "getTypedSetting", "(Lxd/arkosammy/monkeyconfig/util/SettingLocation;Ljava/lang/Class;)Lxd/arkosammy/monkeyconfig/settings/ConfigSetting;", "Lkotlin/Function1;", "Lcom/electronwill/nightconfig/core/file/FileConfig;", "fileConfigFunction", "ifConfigPresent", "(Lkotlin/jvm/functions/Function1;)Z", "fileConfig", "createNewConfigFile", "(Lcom/electronwill/nightconfig/core/file/FileConfig;)V", "checkForSettingNameUniqueness", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getSettingGroups", "()Ljava/util/List;", "Ljava/lang/String;", "getConfigName", "Lcom/electronwill/nightconfig/core/file/GenericBuilder;", "Lcom/electronwill/nightconfig/core/Config;", "configBuilder", "Lcom/electronwill/nightconfig/core/file/GenericBuilder;", "getConfigBuilder", "()Lcom/electronwill/nightconfig/core/file/GenericBuilder;", "configFilePath", "Ljava/nio/file/Path;", "getConfigFilePath", "()Ljava/nio/file/Path;", "monkeyconfig"})
@SourceDebugExtension(value={"SMAP\nAbstractConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractConfigManager.kt\nxd/arkosammy/monkeyconfig/managers/AbstractConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,220:1\n1557#2:221\n1628#2,3:222\n1485#2:225\n1510#2,3:226\n1513#2,3:236\n1755#2,3:239\n1557#2:242\n1628#2,3:243\n381#3,7:229\n*S KotlinDebug\n*F\n+ 1 AbstractConfigManager.kt\nxd/arkosammy/monkeyconfig/managers/AbstractConfigManager\n*L\n84#1:221\n84#1:222,3\n84#1:225\n84#1:226,3\n84#1:236,3\n89#1:239,3\n96#1:242\n96#1:243,3\n84#1:229,7\n*E\n"})
public abstract class AbstractConfigManager
implements ConfigManager {
    @NotNull
    private final List<SettingGroup> settingGroups;
    @NotNull
    private final String configName;
    @NotNull
    private final GenericBuilder<? extends Config, ? extends FileConfig> configBuilder;
    @NotNull
    private final Path configFilePath;

    @Override
    @NotNull
    public final List<SettingGroup> getSettingGroups() {
        return this.settingGroups;
    }

    @Override
    @NotNull
    public final String getConfigName() {
        return this.configName;
    }

    @NotNull
    protected final GenericBuilder<? extends Config, ? extends FileConfig> getConfigBuilder() {
        return this.configBuilder;
    }

    @NotNull
    protected final Path getConfigFilePath() {
        return this.configFilePath;
    }

    public AbstractConfigManager(@NotNull String configName, @NotNull List<? extends SettingGroup> settingGroups, @NotNull ConfigFormat<?> configFormat, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter(settingGroups, (String)"settingGroups");
        Intrinsics.checkNotNullParameter(configFormat, (String)"configFormat");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.configName = configName;
        this.configFilePath = configPath;
        this.configBuilder = FileConfig.builder((Path)this.configFilePath, configFormat).preserveInsertionOrder().sync();
        this.settingGroups = CollectionsKt.toList((Iterable)settingGroups);
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public AbstractConfigManager(@NotNull String configName, @Nullable List<? extends MutableSettingGroup> settingGroups, @NotNull List<? extends ConfigSetting.Builder<?, ?, ?>> settingBuilders, @NotNull ConfigFormat<?> configFormat, @NotNull Path configPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String groupName;
        Map.Entry $this$groupByTo$iv$iv2;
        void $this$groupBy$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter(settingBuilders, (String)"settingBuilders");
        Intrinsics.checkNotNullParameter(configFormat, (String)"configFormat");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.configName = configName;
        this.configFilePath = configPath;
        this.configBuilder = FileConfig.builder((Path)this.configFilePath, configFormat).preserveInsertionOrder().sync();
        Iterable $this$map$iv2 = settingBuilders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void settingBuilder;
            ConfigSetting.Builder builder = (ConfigSetting.Builder)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(settingBuilder.build());
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$groupBy22 = false;
        $this$mapTo$iv$iv2 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object element$iv$iv = iterator.next();
            ConfigSetting setting = (ConfigSetting)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = setting.getSettingLocation().groupName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object groupSettingsByGroupName = destination$iv$iv;
        List list = settingGroups;
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List newGroups = list;
        for (Map.Entry $this$groupByTo$iv$iv2 : groupSettingsByGroupName.entrySet()) {
            boolean bl;
            List settingList;
            block10: {
                groupName = (String)$this$groupByTo$iv$iv2.getKey();
                settingList = (List)$this$groupByTo$iv$iv2.getValue();
                Iterable $this$any$iv = newGroups;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MutableSettingGroup settingGroup = (MutableSettingGroup)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)settingGroup.getName(), (Object)groupName)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            MutableSettingGroup newGroup = new DefaultMutableSettingGroup(groupName, null, CollectionsKt.toMutableList((Collection)settingList), false, false, 26, null);
            newGroups.add(newGroup);
        }
        Iterable $i$f$groupBy22 = CollectionsKt.toList((Iterable)newGroups);
        object = this;
        boolean $i$f$map2 = false;
        groupName = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void mutableSettingGroup;
            MutableSettingGroup element$iv = (MutableSettingGroup)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(mutableSettingGroup.toImmutable((List)groupSettingsByGroupName.get(mutableSettingGroup.getName())));
        }
        ((AbstractConfigManager)object).settingGroups = (List)destination$iv$iv2;
        this.initialize();
    }

    public /* synthetic */ AbstractConfigManager(String string, List list, List list2, ConfigFormat configFormat, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = null;
        }
        this(string, list, list2, configFormat, path);
    }

    private final void initialize() {
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        for (SettingGroup settingGroup : this.settingGroups) {
            settingGroup.setAsRegistered();
            settingGroup.onRegistered();
        }
        this.checkForSettingNameUniqueness();
        this.ifConfigPresent((Function1<? super FileConfig, Boolean>)((Function1)arg_0 -> AbstractConfigManager.initialize$lambda$4(this, arg_0)));
    }

    @Override
    public boolean reloadFromFile() {
        return this.ifConfigPresent((Function1<? super FileConfig, Boolean>)((Function1)arg_0 -> AbstractConfigManager.reloadFromFile$lambda$5(this, arg_0)));
    }

    @Override
    public boolean saveToFile() {
        return this.ifConfigPresent((Function1<? super FileConfig, Boolean>)((Function1)arg_0 -> AbstractConfigManager.saveToFile$lambda$7(this, arg_0)));
    }

    @Override
    @Nullable
    public SettingGroup getSettingGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        for (SettingGroup settingGroup : this.settingGroups) {
            if (!Intrinsics.areEqual((Object)settingGroup.getName(), (Object)groupName)) continue;
            return settingGroup;
        }
        return null;
    }

    @Override
    @Nullable
    public <V, T extends ConfigSetting<V, ?>> T getTypedSetting(@NotNull SettingLocation settingLocation, @NotNull Class<T> settingClass) {
        Intrinsics.checkNotNullParameter((Object)settingLocation, (String)"settingLocation");
        Intrinsics.checkNotNullParameter(settingClass, (String)"settingClass");
        String groupName = settingLocation.groupName();
        String settingName = settingLocation.settingName();
        for (SettingGroup settingGroup : this.settingGroups) {
            if (!Intrinsics.areEqual((Object)settingGroup.getName(), (Object)groupName)) continue;
            for (ConfigSetting<?, ?> setting : settingGroup.getConfigSettings()) {
                if (!settingClass.isInstance(setting) || !Intrinsics.areEqual((Object)setting.getSettingLocation().settingName(), (Object)settingName)) continue;
                Intrinsics.checkNotNull(setting, (String)"null cannot be cast to non-null type T of xd.arkosammy.monkeyconfig.managers.AbstractConfigManager.getTypedSetting");
                return (T)setting;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean ifConfigPresent(@NotNull Function1<? super FileConfig, Boolean> fileConfigFunction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(fileConfigFunction, (String)"fileConfigFunction");
        boolean fileExists = Files.exists(this.configFilePath, new LinkOption[0]);
        AutoCloseable autoCloseable = (AutoCloseable)this.configBuilder.build();
        Throwable throwable = null;
        try {
            FileConfig fileConfig = (FileConfig)autoCloseable;
            boolean bl2 = false;
            if (fileExists) {
                FileConfig fileConfig2;
                if (fileConfig == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = (Boolean)fileConfigFunction.invoke((Object)fileConfig2);
                return bl4;
            }
            MonkeyConfig.INSTANCE.getLOGGER().warn("Found no preexisting configuration file for use. Creating a new configuration file at " + this.configFilePath);
            Intrinsics.checkNotNull((Object)fileConfig);
            this.createNewConfigFile(fileConfig);
            bl = false;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    protected final void createNewConfigFile(@NotNull FileConfig fileConfig) {
        Intrinsics.checkNotNullParameter((Object)fileConfig, (String)"fileConfig");
        for (SettingGroup settingGroup : this.settingGroups) {
            settingGroup.setDefaultValues(fileConfig);
        }
        fileConfig.save();
    }

    private final void checkForSettingNameUniqueness() {
        Set settingNames = new LinkedHashSet();
        for (SettingGroup settingGroup : this.settingGroups) {
            for (ConfigSetting<?, ?> setting : settingGroup.getConfigSettings()) {
                if (settingNames.contains(setting.getSettingLocation().settingName())) {
                    throw new IllegalArgumentException("Setting name " + setting.getSettingLocation() + " is not unique");
                }
                settingNames.add(setting.getSettingLocation().settingName());
            }
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "{name=" + this.configName + ", path=" + this.configFilePath + ", tableAmount=" + this.settingGroups.size() + "}";
    }

    @Override
    public boolean containsSettingGroupName(@NotNull String settingGroupName) {
        return ConfigManager.DefaultImpls.containsSettingGroupName(this, settingGroupName);
    }

    private static final boolean initialize$lambda$4(AbstractConfigManager this$0, FileConfig fileConfig) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)fileConfig, (String)"fileConfig");
        for (SettingGroup settingGroup : this$0.settingGroups) {
            fileConfig.load();
            settingGroup.loadValues(fileConfig);
            settingGroup.onLoaded();
        }
        this$0.saveToFile();
        MonkeyConfig.INSTANCE.getLOGGER().info("Found existing configuration file for " + Reflection.getOrCreateKotlinClass(this$0.getClass()).getSimpleName() + " with name " + this$0.configName + ". Loaded values from " + this$0.configFilePath);
        return true;
    }

    private static final boolean reloadFromFile$lambda$5(AbstractConfigManager this$0, FileConfig fileConfig) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)fileConfig, (String)"fileConfig");
        fileConfig.load();
        for (SettingGroup settingGroup : this$0.settingGroups) {
            settingGroup.loadValues(fileConfig);
            settingGroup.onLoaded();
        }
        return true;
    }

    private static final boolean saveToFile$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean saveToFile$lambda$7(AbstractConfigManager this$0, FileConfig fileConfig) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)fileConfig, (String)"fileConfig");
        fileConfig.load();
        for (SettingGroup settingGroup : this$0.settingGroups) {
            if (settingGroup.getLoadBeforeSave()) {
                settingGroup.loadValues(fileConfig);
            }
            settingGroup.setValues(fileConfig);
        }
        fileConfig.entrySet().removeIf(arg_0 -> AbstractConfigManager.saveToFile$lambda$7$lambda$6((Function1)new Function1<?, Boolean>(this$0, fileConfig){
            final /* synthetic */ AbstractConfigManager this$0;
            final /* synthetic */ FileConfig $fileConfig;
            {
                this.this$0 = $receiver;
                this.$fileConfig = $fileConfig;
            }

            public final Boolean invoke(Config.Entry settingGroupEntry) {
                boolean bl;
                String string = ((UnmodifiableConfig.Entry)settingGroupEntry).getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                if (!this.this$0.containsSettingGroupName(string)) {
                    ((Config)this.$fileConfig.get(((UnmodifiableConfig.Entry)settingGroupEntry).getKey())).entrySet().clear();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }, arg_0));
        fileConfig.save();
        for (SettingGroup settingGroup : this$0.settingGroups) {
            settingGroup.onSavedToFile();
        }
        return true;
    }
}

