/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.blocks;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.blocks.DoubleAffectedBlock;
import xd.arkosammy.creeperhealing.config.ConfigManager;
import xd.arkosammy.creeperhealing.config.ReplaceMapTable;
import xd.arkosammy.creeperhealing.config.settings.BlockPlacementDelaySetting;
import xd.arkosammy.creeperhealing.config.settings.ConfigSettings;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;
import xd.arkosammy.creeperhealing.util.SerializedAffectedBlock;

public class AffectedBlock {
    public static final String TYPE = "single_affected_block";
    private final class_2338 pos;
    private final class_2680 state;
    private final class_5321<class_1937> worldRegistryKey;
    @Nullable
    private final class_2487 nbt;
    private long timer;
    private boolean placed;

    public AffectedBlock(class_2338 pos, class_2680 state, class_5321<class_1937> registryKey, @Nullable class_2487 nbt, long timer, boolean placed) {
        this.pos = pos;
        this.state = state;
        this.worldRegistryKey = registryKey;
        this.nbt = nbt;
        this.placed = placed;
        this.timer = timer;
    }

    public static AffectedBlock newAffectedBlock(class_2338 pos, class_2680 state, class_1937 world) {
        if (state.method_28498((class_2769)class_2741.field_12533) || state.method_28498((class_2769)class_2741.field_12483)) {
            return new DoubleAffectedBlock(pos, state, (class_5321<class_1937>)world.method_27983(), BlockPlacementDelaySetting.getAsTicks(), false);
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null && ((Boolean)ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.RESTORE_BLOCK_NBT.getId()).getValue()).booleanValue()) {
            return new AffectedBlock(pos, state, (class_5321<class_1937>)world.method_27983(), blockEntity.method_38243((class_7225.class_7874)world.method_30349()), BlockPlacementDelaySetting.getAsTicks(), false);
        }
        return new AffectedBlock(pos, state, (class_5321<class_1937>)world.method_27983(), null, BlockPlacementDelaySetting.getAsTicks(), false);
    }

    public void setTimer(long delay) {
        this.timer = delay;
    }

    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public class_1937 getWorld(@NotNull MinecraftServer server) {
        return server.method_3847(this.getWorldRegistryKey());
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setPlaced() {
        this.placed = true;
    }

    public long getTimer() {
        return this.timer;
    }

    public boolean isPlaced() {
        return this.placed;
    }

    public void tickAffectedBlock() {
        --this.timer;
    }

    public boolean canBePlaced(MinecraftServer server) {
        if (this.shouldForceHeal()) {
            return true;
        }
        return this.getState().method_26184((class_4538)this.getWorld(server), this.getPos());
    }

    String getAffectedBlockType() {
        return TYPE;
    }

    public SerializedAffectedBlock toSerialized() {
        return new SerializedAffectedBlock(this.getAffectedBlockType(), this.pos, this.state, this.worldRegistryKey, Optional.ofNullable(this.nbt), this.timer, this.placed);
    }

    public void tryHealing(MinecraftServer server, AbstractExplosionEvent currentExplosionEvent) {
        class_2680 state = this.getState();
        class_2338 pos = this.getPos();
        class_1937 world = this.getWorld(server);
        boolean stateReplaced = false;
        String blockIdentifier = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        Optional<String> replaceMapValueOptional = ReplaceMapTable.getFromKey(blockIdentifier);
        if (replaceMapValueOptional.isPresent() && !this.shouldForceHeal()) {
            String replaceMapValue = replaceMapValueOptional.get();
            state = ((class_2248)class_7923.field_41175.method_10223(new class_2960(replaceMapValue))).method_34725(state);
            stateReplaced = true;
        }
        if (!this.shouldHealBlock(world, this.pos)) {
            return;
        }
        if (state.method_26212((class_1922)world, pos)) {
            ExplosionUtils.pushEntitiesUpwards(world, pos, false);
        }
        if (state.method_26204() instanceof class_2346) {
            ExplosionUtils.FALLING_BLOCK_SCHEDULE_TICK.set((Boolean)ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.MAKE_FALLING_BLOCKS_FALL.getId()).getValue());
        }
        world.method_8501(pos, state);
        if (this.nbt != null && !stateReplaced) {
            world.method_8438(class_2586.method_11005((class_2338)pos, (class_2680)state, (class_2487)this.nbt, (class_7225.class_7874)world.method_30349()));
        }
        if (ExplosionUtils.shouldPlayBlockPlacementSound(world, state)) {
            world.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, state.method_26231().method_10597(), state.method_26231().method_10599());
        }
    }

    boolean shouldHealBlock(class_1937 world, class_2338 pos) {
        if (this.shouldForceHeal()) {
            return true;
        }
        return world.method_8320(pos).method_45474();
    }

    private boolean shouldForceHeal() {
        return this.nbt != null && (Boolean)ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.FORCE_BLOCKS_WITH_NBT_TO_ALWAYS_HEAL.getId()).getValue() != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AffectedBlock)) {
            return false;
        }
        AffectedBlock that = (AffectedBlock)o;
        return Objects.equals(this.getPos(), that.getPos()) && Objects.equals(this.getState(), that.getState()) && Objects.equals(this.getWorldRegistryKey(), that.getWorldRegistryKey());
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getState(), this.getWorldRegistryKey());
    }
}

