/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.ConfigTable;
import xd.arkosammy.creeperhealing.config.ConfigTables;
import xd.arkosammy.creeperhealing.config.settings.BooleanSetting;
import xd.arkosammy.creeperhealing.config.settings.ConfigSetting;
import xd.arkosammy.creeperhealing.config.settings.DoubleSetting;
import xd.arkosammy.creeperhealing.config.settings.StringListSetting;
import xd.arkosammy.creeperhealing.config.settings.StringSetting;
import xd.arkosammy.creeperhealing.config.util.SettingIdentifier;
import xd.arkosammy.creeperhealing.util.ExplosionManager;

public class ConfigManager {
    private static ConfigManager INSTANCE;
    private final Path configPath;
    private final GenericBuilder<CommentedConfig, CommentedFileConfig> CONFIG_BUILDER;
    private final List<ConfigTable> configTables = new ArrayList<ConfigTable>();
    private boolean isInitialized = false;

    private ConfigManager(String configName) {
        GenericBuilder builder;
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve(configName + ".toml");
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        try {
            builder = CommentedFileConfig.builder((Path)this.configPath, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().concurrent().sync();
        }
        catch (Throwable throwable) {
            builder = null;
            CreeperHealing.LOGGER.error("Unable to initialize CommentedConfigBuilder: {}. Config will be unavailable.", (Object)throwable.getMessage());
        }
        this.CONFIG_BUILDER = builder;
    }

    public static ConfigManager getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("ConfigManager has not been initialized");
        }
        return INSTANCE;
    }

    public static void init(List<ConfigTable> configTables, List<ConfigSetting.Builder<?, ?>> settingBuilders, String configName) {
        INSTANCE = new ConfigManager(configName);
        ConfigManager.getInstance().registerConfigSettings(configTables, settingBuilders);
        ConfigManager.getInstance().checkForSettingNameUniqueness();
        ConfigManager.getInstance().ifConfigPresent(fileConfig -> {
            if (!Files.exists(ConfigManager.getInstance().configPath, new LinkOption[0])) {
                CreeperHealing.LOGGER.warn("Found no preexisting configuration file. Creating a new configuration file with default values in {}", (Object)ConfigManager.getInstance().configPath);
                ConfigManager.getInstance().createNewConfigFile((CommentedFileConfig)fileConfig);
            } else {
                fileConfig.load();
                ConfigManager.getInstance().configTables.forEach(table -> table.loadValues((CommentedFileConfig)fileConfig));
                ConfigManager.getInstance().saveToFile();
                CreeperHealing.LOGGER.info("Found existing configuration file. Loaded values from {}", (Object)ConfigManager.getInstance().configPath);
            }
            return true;
        });
        ConfigManager.getInstance().isInitialized = true;
    }

    private void registerConfigSettings(List<ConfigTable> configTables, List<ConfigSetting.Builder<?, ?>> settingBuilders) {
        if (this.isInitialized) {
            throw new IllegalStateException("ConfigManager has already been initialized");
        }
        this.configTables.addAll(configTables);
        block0: for (ConfigSetting.Builder<?, ?> settingBuilder : settingBuilders) {
            String tableName = settingBuilder.getTableName();
            for (ConfigTable configTable : this.configTables) {
                if (!configTable.getName().equals(tableName)) continue;
                Object setting = settingBuilder.build();
                configTable.addConfigSetting((ConfigSetting<?>)setting);
                continue block0;
            }
        }
        this.configTables.forEach(ConfigTable::setAsRegistered);
    }

    private boolean ifConfigPresent(Function<CommentedFileConfig, Boolean> fileConfigFunction) {
        if (this.CONFIG_BUILDER == null) {
            return false;
        }
        try (CommentedFileConfig fileConfig = (CommentedFileConfig)this.CONFIG_BUILDER.build();){
            if (fileConfig != null) {
                boolean bl = fileConfigFunction.apply(fileConfig);
                return bl;
            }
        }
        return false;
    }

    public boolean reloadFromFile() {
        return this.ifConfigPresent(fileConfig -> {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                return false;
            }
            fileConfig.load();
            this.configTables.forEach(table -> table.loadValues((CommentedFileConfig)fileConfig));
            ExplosionManager.getInstance().updateAffectedBlocksTimers();
            return true;
        });
    }

    public void saveToFile() {
        this.ifConfigPresent(fileConfig -> {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                CreeperHealing.LOGGER.warn("Found no preexisting configuration file to save settings to. Creating a new configuration file with default values in {}", (Object)this.configPath);
                this.createNewConfigFile((CommentedFileConfig)fileConfig);
            } else {
                fileConfig.load();
                this.getConfigTable(ConfigTables.REPLACE_MAP_TABLE.getName()).loadValues((CommentedFileConfig)fileConfig);
                this.getConfigTable(ConfigTables.WHITELIST_TABLE.getName()).loadValues((CommentedFileConfig)fileConfig);
                this.configTables.forEach(table -> table.setValues((CommentedFileConfig)fileConfig));
                fileConfig.save();
            }
            return true;
        });
    }

    public ConfigTable getConfigTable(String tableName) {
        for (ConfigTable configTable : this.configTables) {
            if (!configTable.getName().equals(tableName)) continue;
            return configTable;
        }
        throw new IllegalArgumentException("Config table not found: " + tableName);
    }

    public ConfigSetting<?> getSetting(SettingIdentifier settingId) {
        for (ConfigTable configTable : this.configTables) {
            if (!configTable.getName().equals(settingId.tableName())) continue;
            for (ConfigSetting<?> setting : configTable.getConfigSettings()) {
                if (!setting.getName().equals(settingId.settingName())) continue;
                return setting;
            }
        }
        throw new IllegalArgumentException("Setting " + settingId.settingName() + " not found in table " + settingId.tableName());
    }

    public DoubleSetting getAsDoubleSetting(SettingIdentifier settingId) {
        ConfigSetting<?> configSetting = this.getSetting(settingId);
        if (!(configSetting instanceof DoubleSetting)) {
            throw new IllegalArgumentException("Setting " + settingId.settingName() + " is not a double setting");
        }
        DoubleSetting doubleSetting = (DoubleSetting)configSetting;
        return doubleSetting;
    }

    public BooleanSetting getAsBooleanSetting(SettingIdentifier settingId) {
        ConfigSetting<?> configSetting = this.getSetting(settingId);
        if (!(configSetting instanceof BooleanSetting)) {
            throw new IllegalArgumentException("Setting " + settingId.settingName() + " is not a boolean setting");
        }
        BooleanSetting booleanSetting = (BooleanSetting)configSetting;
        return booleanSetting;
    }

    public StringSetting getAsStringSetting(SettingIdentifier settingId) {
        ConfigSetting<?> configSetting = this.getSetting(settingId);
        if (!(configSetting instanceof StringSetting)) {
            throw new IllegalArgumentException("Setting " + settingId.settingName() + " is not a string setting");
        }
        StringSetting stringSetting = (StringSetting)configSetting;
        return stringSetting;
    }

    public StringListSetting getAsStringListSetting(SettingIdentifier settingId) {
        ConfigSetting<?> configSetting = this.getSetting(settingId);
        if (!(configSetting instanceof StringListSetting)) {
            throw new IllegalArgumentException("Setting " + settingId.settingName() + " is not a string list setting");
        }
        StringListSetting stringListSetting = (StringListSetting)configSetting;
        return stringListSetting;
    }

    private void createNewConfigFile(CommentedFileConfig fileConfig) {
        this.configTables.forEach(table -> table.setDefaultValues(fileConfig));
        fileConfig.save();
    }

    private void checkForSettingNameUniqueness() {
        HashSet<String> settingNames = new HashSet<String>();
        for (ConfigTable table : this.configTables) {
            for (ConfigSetting<?> setting : table.getConfigSettings()) {
                if (settingNames.add(setting.getName())) continue;
                throw new IllegalArgumentException("Duplicate config setting name found: " + setting.getName());
            }
        }
    }
}

