/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.config.ConfigManager;
import xd.arkosammy.creeperhealing.config.settings.ConfigSettings;

public final class ExplosionUtils {
    public static final ThreadLocal<Boolean> DROP_EXPLOSION_ITEMS = ThreadLocal.withInitial(() -> true);
    public static final ThreadLocal<Boolean> DROP_BLOCK_INVENTORY_ITEMS = ThreadLocal.withInitial(() -> true);
    public static final ThreadLocal<Boolean> FALLING_BLOCK_SCHEDULE_TICK = ThreadLocal.withInitial(() -> true);

    private ExplosionUtils() {
    }

    public static void pushEntitiesUpwards(class_1937 world, class_2338 pos, boolean isTallBlock) {
        int amountToPush = isTallBlock ? 2 : 1;
        for (class_1297 entity : world.method_8390(class_1309.class, new class_238(pos), class_1297::method_5805)) {
            if (!ExplosionUtils.areAboveBlocksFree(world, pos, entity, amountToPush)) continue;
            entity.method_29495(entity.method_19538().method_38499(class_2350.class_2351.field_11052, (double)(entity.method_31478() + amountToPush)));
        }
    }

    private static boolean areAboveBlocksFree(class_1937 world, class_2338 pos, class_1297 entity, int amountToPush) {
        for (int i = pos.method_10264(); i < pos.method_30513(class_2350.class_2351.field_11052, (int)Math.ceil(entity.method_5751())).method_10264(); ++i) {
            class_2338 currentPos = pos.method_33096(i + amountToPush);
            if (!world.method_8320(currentPos).method_26212((class_1922)world, currentPos)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static List<AffectedBlock> sortAffectedBlocksList(@NotNull List<AffectedBlock> affectedBlocksList, class_1937 world) {
        ArrayList<AffectedBlock> sortedAffectedBlocks = new ArrayList<AffectedBlock>(affectedBlocksList);
        List<class_2338> affectedBlocksAsPositions = sortedAffectedBlocks.stream().map(AffectedBlock::getPos).collect(Collectors.toList());
        int centerX = ExplosionUtils.getCenterXCoordinate(affectedBlocksAsPositions);
        int centerZ = ExplosionUtils.getCenterZCoordinate(affectedBlocksAsPositions);
        Comparator<AffectedBlock> distanceToCenterComparator = Comparator.comparingInt(affectedBlock -> (int)(-Math.round(Math.pow(affectedBlock.getPos().method_10263() - centerX, 2.0) + Math.pow(affectedBlock.getPos().method_10260() - centerZ, 2.0))));
        sortedAffectedBlocks.sort(distanceToCenterComparator);
        Comparator<AffectedBlock> yLevelComparator = Comparator.comparingInt(affectedBlock -> affectedBlock.getPos().method_10264());
        sortedAffectedBlocks.sort(yLevelComparator);
        Comparator transparencyComparator = (affectedBlock1, affectedBlock2) -> {
            boolean isAffectedBlock1Transparent = affectedBlock1.getState().method_26167((class_1922)world, affectedBlock1.getPos());
            boolean isAffectedBlock2Transparent = affectedBlock2.getState().method_26167((class_1922)world, affectedBlock2.getPos());
            return Boolean.compare(isAffectedBlock1Transparent, isAffectedBlock2Transparent);
        };
        sortedAffectedBlocks.sort(transparencyComparator);
        return sortedAffectedBlocks;
    }

    static int getCenterXCoordinate(List<class_2338> affectedCoordinates) {
        int maxX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).max().orElse(0);
        int minX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).min().orElse(0);
        return (maxX + minX) / 2;
    }

    static int getCenterYCoordinate(List<class_2338> affectedCoordinates) {
        int maxY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).max().orElse(0);
        int minY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).min().orElse(0);
        return (maxY + minY) / 2;
    }

    static int getCenterZCoordinate(List<class_2338> affectedCoordinates) {
        int maxZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        int minZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).min().orElse(0);
        return (maxZ + minZ) / 2;
    }

    static int getMaxExplosionRadius(List<class_2338> affectedCoordinates) {
        int[] radii = new int[3];
        int maxX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).max().orElse(0);
        int minX = affectedCoordinates.stream().mapToInt(class_2382::method_10263).min().orElse(0);
        radii[0] = (maxX - minX) / 2;
        int maxY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).max().orElse(0);
        int minY = affectedCoordinates.stream().mapToInt(class_2382::method_10264).min().orElse(0);
        radii[1] = (maxY - minY) / 2;
        int maxZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).max().orElse(0);
        int minZ = affectedCoordinates.stream().mapToInt(class_2382::method_10260).min().orElse(0);
        radii[2] = (maxZ - minZ) / 2;
        return Arrays.stream(radii).max().orElse(0);
    }

    public static boolean shouldPlayBlockPlacementSound(class_1937 world, class_2680 state) {
        return !world.field_9236 && !state.method_26215() && (Boolean)ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.BLOCK_PLACEMENT_SOUND_EFFECT.getId()).getValue() != false;
    }
}

