/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.ConfigManager;
import xd.arkosammy.creeperhealing.config.ConfigTable;
import xd.arkosammy.creeperhealing.config.ConfigTables;
import xd.arkosammy.creeperhealing.config.settings.ConfigSetting;
import xd.arkosammy.creeperhealing.config.settings.StringSetting;
import xd.arkosammy.creeperhealing.config.util.SettingIdentifier;

public class ReplaceMapTable
implements ConfigTable {
    private final String name = "replace_map";
    private final String comment = "Add your own replace entries to configure which blocks should be used to heal other blocks. The block on the right will be used to heal the block on the left.\nSpecify the block's namespace along with the block's name identifier, separated by a colon and enclosed in double quotes.\nExample entry:\n\"minecraft:gold_block\" = \"minecraft:stone\"\nWarning, the same key cannot appear more than once in the replace map! For example, the following will cause an error:\n\"minecraft:diamond_block\" = \"minecraft:stone\"\n\"minecraft:diamond_block\" = \"minecraft:air\" ";
    private final List<ConfigSetting<?>> configSettings = new ArrayList();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getComment() {
        return Optional.of(this.comment);
    }

    @Override
    public List<ConfigSetting<?>> getConfigSettings() {
        return this.configSettings;
    }

    @Override
    public void setAsRegistered() {
    }

    @Override
    public boolean isRegistered() {
        return false;
    }

    public static Optional<String> getFromKey(String key) {
        ConfigTable table = ConfigManager.getInstance().getConfigTable(ConfigTables.REPLACE_MAP_TABLE.getName());
        if (!(table instanceof ReplaceMapTable)) {
            CreeperHealing.LOGGER.error("Failed to get Replace Map Table.");
            return Optional.empty();
        }
        ReplaceMapTable replaceMapTable = (ReplaceMapTable)table;
        for (ConfigSetting<?> setting : replaceMapTable.configSettings) {
            Object value;
            if (!setting.getName().equals(key) || !((value = setting.getValue()) instanceof String)) continue;
            String stringValue = (String)value;
            return Optional.of(stringValue);
        }
        return Optional.empty();
    }

    @Override
    public void setDefaultValues(CommentedFileConfig fileConfig) {
        this.configSettings.clear();
        StringSetting defaultSetting = new StringSetting.Builder(new SettingIdentifier(ConfigTables.REPLACE_MAP_TABLE.getName(), "minecraft:diamond_block"), "minecraft:stone").build();
        this.configSettings.add(defaultSetting);
        this.setValues(fileConfig);
    }

    @Override
    public void setValues(CommentedFileConfig fileConfig) {
        if (!this.configSettings.isEmpty()) {
            for (ConfigSetting<?> setting : this.configSettings) {
                fileConfig.set(this.getName() + "." + setting.getName(), setting.getValue());
            }
        } else {
            fileConfig.set(this.getName() + ".minecraft:placeholder_key", (Object)"minecraft:placeholder_value");
        }
        fileConfig.setComment(this.getName(), this.comment);
    }

    @Override
    public void loadValues(CommentedFileConfig fileConfig) {
        CommentedConfig replaceMapConfig = (CommentedConfig)fileConfig.get(this.getName());
        ArrayList<StringSetting> tempReplaceMap = new ArrayList<StringSetting>();
        for (CommentedConfig.Entry entry : replaceMapConfig.entrySet()) {
            if (entry.getValue() instanceof String && entry.getKey() != null) {
                StringSetting stringSetting = new StringSetting.Builder(new SettingIdentifier(ConfigTables.REPLACE_MAP_TABLE.getName(), entry.getKey()), (String)entry.getValue()).build();
                tempReplaceMap.add(stringSetting);
                continue;
            }
            if (!(entry.getValue() instanceof String)) {
                CreeperHealing.LOGGER.error("Failed to read Replace Map: Invalid value in replace map for key: {}", (Object)entry.getKey());
                continue;
            }
            if (entry.getKey() != null) continue;
            CreeperHealing.LOGGER.error("Failed to read Replace Map: Invalid key found in replace map.");
        }
        this.configSettings.clear();
        this.configSettings.addAll(tempReplaceMap);
    }
}

