/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config.settings;

import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.config.ConfigManager;
import xd.arkosammy.creeperhealing.config.settings.ConfigSettings;
import xd.arkosammy.creeperhealing.config.settings.DoubleSetting;
import xd.arkosammy.creeperhealing.config.util.SettingIdentifier;

public class HealDelaySetting
extends DoubleSetting {
    HealDelaySetting(String name, double value, @Nullable Double lowerBound, @Nullable Double upperBound, String comment) {
        super(name, value, lowerBound, upperBound, comment);
    }

    public static long getAsTicks() {
        DoubleSetting setting = ConfigManager.getInstance().getAsDoubleSetting(ConfigSettings.EXPLOSION_HEAL_DELAY.getId());
        if (!(setting instanceof HealDelaySetting)) {
            throw new IllegalStateException("Retrieved setting is not an instance of BlockPlacementDelaySetting");
        }
        HealDelaySetting healDelaySetting = (HealDelaySetting)setting;
        return healDelaySetting.asTicks();
    }

    public long asTicks() {
        long rounded = Math.round(Math.max(0.0, (Double)this.getValue()) * 20.0);
        return rounded == 0L ? 20L : rounded;
    }

    public static class Builder
    extends DoubleSetting.Builder {
        public Builder(SettingIdentifier id, double defaultValue) {
            super(id, defaultValue);
        }

        @Override
        public HealDelaySetting build() {
            return new HealDelaySetting(this.id.settingName(), (Double)this.defaultValue, this.lowerBound, this.upperBound, this.comment);
        }
    }
}

