/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import xd.arkosammy.creeperhealing.config.ConfigManager;
import xd.arkosammy.creeperhealing.config.settings.ConfigSettings;

public final class PreferencesCommands {
    private PreferencesCommands() {
    }

    static void register(LiteralCommandNode<class_2168> creeperHealingNode) {
        LiteralCommandNode settingsNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"preferences").requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode restoreBlockNbtNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore_block_nbt").executes(PreferencesCommands::getRestoreBlockNbtCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode forceBlocksToHealNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"force_blocks_to_heal").executes(PreferencesCommands::getForceBlocksToHealCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode makeFallingBlocksFallNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"make_falling_blocks_fall").executes(PreferencesCommands::getMakeFallingBlocksFallCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode shouldPlaySoundOnBlockPlacementNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"block_placement_sound_effect").executes(PreferencesCommands::getShouldPlaySoundOnBlockPlacementCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode healOnHealingPotionSplashNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"heal_on_healing_potion_splash").executes(PreferencesCommands::getHealOnHealingPotionSplashCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode healOnRegenerationPotionSplash = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"heal_on_regeneration_potion_splash").executes(PreferencesCommands::getHealOnRegenerationPotionSplashCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        LiteralCommandNode enableWhitelistNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enable_whitelist").requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(PreferencesCommands::getEnableWhitelistCommand)).build();
        ArgumentCommandNode restoreBlockNbtArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setRestoreBlockNbtCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode forceBlocksToHealArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setForceBlocksToHealCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode makeFallingBlocksFallArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setMakeFallingBlocksFallCommands)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode playSoundOnBlockPlacementArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setPlaySoundOnBlockPlacementCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode healOnHealingPotionSplashArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setHealOnHealingPotionSplashCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode healOnRegenerationPotionSplashArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setHealOnRegenerationPotionSplashCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        ArgumentCommandNode enableWhitelistArgumentNode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(PreferencesCommands::setEnableWhitelistCommand)).requires(serverCommandSource -> serverCommandSource.method_9259(4))).build();
        creeperHealingNode.addChild((CommandNode)settingsNode);
        settingsNode.addChild((CommandNode)restoreBlockNbtNode);
        settingsNode.addChild((CommandNode)forceBlocksToHealNode);
        settingsNode.addChild((CommandNode)makeFallingBlocksFallNode);
        settingsNode.addChild((CommandNode)shouldPlaySoundOnBlockPlacementNode);
        settingsNode.addChild((CommandNode)healOnHealingPotionSplashNode);
        settingsNode.addChild((CommandNode)healOnRegenerationPotionSplash);
        settingsNode.addChild((CommandNode)enableWhitelistNode);
        restoreBlockNbtNode.addChild((CommandNode)restoreBlockNbtArgumentNode);
        forceBlocksToHealNode.addChild((CommandNode)forceBlocksToHealArgumentNode);
        makeFallingBlocksFallNode.addChild((CommandNode)makeFallingBlocksFallArgumentNode);
        shouldPlaySoundOnBlockPlacementNode.addChild((CommandNode)playSoundOnBlockPlacementArgumentNode);
        healOnHealingPotionSplashNode.addChild((CommandNode)healOnHealingPotionSplashArgumentNode);
        healOnRegenerationPotionSplash.addChild((CommandNode)healOnRegenerationPotionSplashArgumentNode);
        enableWhitelistNode.addChild((CommandNode)enableWhitelistArgumentNode);
    }

    private static int setRestoreBlockNbtCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.RESTORE_BLOCK_NBT.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Restore block nbt data has been set to: " + value)));
        return 1;
    }

    private static int setForceBlocksToHealCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.FORCE_BLOCKS_WITH_NBT_TO_ALWAYS_HEAL.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Force blocks with nbt to always heal has been set to: " + value)));
        return 1;
    }

    private static int setMakeFallingBlocksFallCommands(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.MAKE_FALLING_BLOCKS_FALL.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Make falling blocks fall has been set to: " + value)));
        return 1;
    }

    private static int setPlaySoundOnBlockPlacementCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.BLOCK_PLACEMENT_SOUND_EFFECT.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Play sound on block placement has been set to: " + value)));
        return 1;
    }

    private static int setHealOnHealingPotionSplashCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.HEAL_ON_HEALING_POTION_SPLASH.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Heal on Healing potion splash set to: " + value)));
        return 1;
    }

    private static int setHealOnRegenerationPotionSplashCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.HEAL_ON_REGENERATION_POTION_SPLASH.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Heal on Regeneration potion splash set to: " + value)));
        return 1;
    }

    private static int setEnableWhitelistCommand(CommandContext<class_2168> ctx) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.ENABLE_WHITELIST.getId()).setValue(value);
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("The whitelist has been " + value)));
        return 1;
    }

    private static int getRestoreBlockNbtCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Restore block nbt data currently set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.RESTORE_BLOCK_NBT.getId()).getValue()))));
        return 1;
    }

    private static int getForceBlocksToHealCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Force blocks with nbt to always heal currently set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.FORCE_BLOCKS_WITH_NBT_TO_ALWAYS_HEAL.getId()).getValue()))));
        return 1;
    }

    private static int getMakeFallingBlocksFallCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Make falling blocks fall currently set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.MAKE_FALLING_BLOCKS_FALL.getId()).getValue()))));
        return 1;
    }

    private static int getShouldPlaySoundOnBlockPlacementCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Play sound on block placement currently set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.BLOCK_PLACEMENT_SOUND_EFFECT.getId()).getValue()))));
        return 1;
    }

    private static int getHealOnHealingPotionSplashCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Heal on Healing potion splash set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.HEAL_ON_HEALING_POTION_SPLASH.getId()).getValue()))));
        return 1;
    }

    private static int getHealOnRegenerationPotionSplashCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Heal on Regeneration potion splash set to: " + String.valueOf(ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.HEAL_ON_REGENERATION_POTION_SPLASH.getId()).getValue()))));
        return 1;
    }

    private static int getEnableWhitelistCommand(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("The whitelist is currently " + ((Boolean)ConfigManager.getInstance().getAsBooleanSetting(ConfigSettings.ENABLE_WHITELIST.getId()).getValue() != false ? "enabled" : "disabled"))));
        return 1;
    }
}

