/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.List;
import java.util.Optional;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.settings.ConfigSetting;

public interface ConfigTable {
    public String getName();

    public Optional<String> getComment();

    public List<ConfigSetting<?>> getConfigSettings();

    public void setAsRegistered();

    public boolean isRegistered();

    default public void addConfigSetting(ConfigSetting<?> setting) {
        if (this.isRegistered()) {
            return;
        }
        this.getConfigSettings().add(setting);
    }

    default public void setDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigSetting<?> setting : this.getConfigSettings()) {
            setting.resetValue();
        }
        this.setValues(fileConfig);
    }

    default public void setValues(CommentedFileConfig fileConfig) {
        for (ConfigSetting<?> setting : this.getConfigSettings()) {
            String settingAddress = this.getName() + "." + setting.getName();
            fileConfig.set(settingAddress, setting.getValue());
            setting.getComment().ifPresent(comment -> fileConfig.setComment(settingAddress, comment));
        }
        this.getComment().ifPresent(comment -> fileConfig.setComment(this.getName(), comment));
        CommentedConfig tableConfig = (CommentedConfig)fileConfig.get(this.getName());
        if (tableConfig != null) {
            tableConfig.entrySet().removeIf(entry -> !this.containsSettingName(entry.getKey()));
        }
    }

    default public void loadValues(CommentedFileConfig fileConfig) {
        for (ConfigSetting<?> setting : this.getConfigSettings()) {
            String settingAddress = this.getName() + "." + setting.getName();
            Object value = fileConfig.getOrElse(settingAddress, setting.getDefaultValue());
            this.setValueSafely(setting, value);
        }
    }

    private <T> void setValueSafely(ConfigSetting<T> setting, Object value) {
        if (setting.getDefaultValue().getClass().equals(Integer.class) && value instanceof Number) {
            Number number = (Number)value;
            value = number.intValue();
        } else if (setting.getDefaultValue().getClass().equals(Double.class) && value instanceof Number) {
            Number number = (Number)value;
            value = number.doubleValue();
        }
        if (!setting.getDefaultValue().getClass().isInstance(value)) {
            CreeperHealing.LOGGER.error("Failed to load value for setting {} in table {}. Expected {} but got {}. Using default value instead.", new Object[]{setting.getName(), this.getName(), setting.getDefaultValue().getClass().getName(), value.getClass().getName()});
            return;
        }
        setting.setValue(value);
    }

    default public boolean containsSettingName(String settingName) {
        for (ConfigSetting<?> setting : this.getConfigSettings()) {
            if (!setting.getName().equals(settingName)) continue;
            return true;
        }
        return false;
    }
}

