/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DaytimeExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DefaultExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.util.SerializedAffectedBlock;

public record SerializedExplosionEvent(String healingMode, List<SerializedAffectedBlock> serializedAffectedBlocks, long healTimer, int blockCounter) {
    static final Codec<SerializedExplosionEvent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("healing_mode").forGetter(SerializedExplosionEvent::healingMode), (App)Codec.list(SerializedAffectedBlock.CODEC).fieldOf("affected_blocks").forGetter(SerializedExplosionEvent::serializedAffectedBlocks), (App)Codec.LONG.fieldOf("heal_timer").forGetter(SerializedExplosionEvent::healTimer), (App)Codec.INT.fieldOf("block_counter").forGetter(SerializedExplosionEvent::blockCounter)).apply((Applicative)instance, SerializedExplosionEvent::new));

    AbstractExplosionEvent toDeserialized() {
        List<AffectedBlock> affectedBlocks = this.serializedAffectedBlocks.stream().map(SerializedAffectedBlock::toDeserialized).collect(Collectors.toList());
        ExplosionHealingMode explosionHealingMode = ExplosionHealingMode.getFromName(this.healingMode);
        return switch (explosionHealingMode) {
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter);
            default -> new DefaultExplosionEvent(affectedBlocks, this.healTimer, this.blockCounter);
        };
    }
}

