/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.configuration;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.tables.DelaysConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ExplosionItemDropConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ExplosionSourceConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ModeConfig;
import xd.arkosammy.creeperhealing.configuration.tables.PreferencesConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ReplaceMapConfig;
import xd.arkosammy.creeperhealing.configuration.tables.WhitelistConfig;
import xd.arkosammy.creeperhealing.explosions.AffectedBlock;

public final class CreeperHealingConfig {
    private static final Path CONFIG_PATH;
    @Nullable
    private static final GenericBuilder<CommentedConfig, CommentedFileConfig> CONFIG_BUILDER;

    private CreeperHealingConfig() {
    }

    public static void initializeConfig() {
        if (CONFIG_BUILDER != null) {
            try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    CreeperHealing.LOGGER.warn("Found no preexisting config to load settings from. Creating a new config with default values in " + CONFIG_PATH);
                    CreeperHealing.LOGGER.warn("Change the settings in the config file, then reload the config by using /creeper-healing reload_config, or restart the server.");
                    CreeperHealingConfig.saveDefaultConfigSettingsToFile(fileConfig);
                    fileConfig.save();
                } else {
                    fileConfig.load();
                    CreeperHealingConfig.loadConfigSettingsToMemory(fileConfig);
                    CreeperHealingConfig.updateConfigFile();
                    if (Math.round(Math.max(DelaysConfig.EXPLOSION_HEAL_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                        CreeperHealing.LOGGER.warn("Explosion heal delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file");
                    }
                    if (Math.round(Math.max(DelaysConfig.BLOCK_PLACEMENT_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                        CreeperHealing.LOGGER.warn("Block placement delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file");
                    }
                    CreeperHealing.LOGGER.info("Applied custom config settings");
                }
            }
        }
    }

    public static void updateConfigFile() {
        if (CONFIG_BUILDER != null) {
            try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    fileConfig.load();
                    ReplaceMapConfig.loadReplaceMapToMemory(fileConfig);
                    WhitelistConfig.loadWhitelistToMemory(fileConfig);
                    CreeperHealingConfig.saveConfigSettingsToFile(fileConfig);
                    fileConfig.save();
                } else {
                    CreeperHealing.LOGGER.warn("Found no preexisting config to load settings from. Creating a new config with default values in " + CONFIG_PATH);
                    CreeperHealing.LOGGER.warn("Change the settings in the config file, then reload the config by using /creeper-healing reload_config, or restart the server.");
                    CreeperHealingConfig.saveDefaultConfigSettingsToFile(fileConfig);
                    fileConfig.save();
                }
            }
        }
    }

    public static boolean reloadConfigSettingsInMemory(CommandContext<class_2168> ctx) {
        if (CONFIG_BUILDER != null) {
            try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    CreeperHealing.setHealerHandlerLock(false);
                    fileConfig.load();
                    CreeperHealingConfig.loadConfigSettingsToMemory(fileConfig);
                    CreeperHealing.setHealerHandlerLock(true);
                    AffectedBlock.updateAffectedBlocksTimers();
                    if (Math.round(Math.max(DelaysConfig.EXPLOSION_HEAL_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Explosion heal delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file").method_27692(class_124.field_1054));
                    }
                    if (Math.round(Math.max(DelaysConfig.BLOCK_PLACEMENT_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Block placement delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file").method_27692(class_124.field_1054));
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    private static void saveDefaultConfigSettingsToFile(CommentedFileConfig fileConfig) {
        ModeConfig.saveToFileWithDefaultValues(fileConfig);
        ExplosionSourceConfig.saveToFileWithDefaultValues(fileConfig);
        ExplosionItemDropConfig.saveToFileWithDefaultValues(fileConfig);
        DelaysConfig.saveToFileWithDefaultValues(fileConfig);
        PreferencesConfig.saveToFileWithDefaultValues(fileConfig);
        WhitelistConfig.saveToFileWithDefaultValues(fileConfig);
        ReplaceMapConfig.saveToFileWithDefaultValues(fileConfig);
    }

    private static void saveConfigSettingsToFile(CommentedFileConfig fileConfig) {
        ModeConfig.saveSettingsToFile(fileConfig);
        ExplosionSourceConfig.saveSettingsToFile(fileConfig);
        ExplosionItemDropConfig.saveSettingsToFile(fileConfig);
        DelaysConfig.saveSettingsToFile(fileConfig);
        PreferencesConfig.saveSettingsToFile(fileConfig);
        WhitelistConfig.saveWhitelistToFile(fileConfig);
        ReplaceMapConfig.saveReplaceMapToFile(fileConfig);
    }

    private static void loadConfigSettingsToMemory(CommentedFileConfig fileConfig) {
        ModeConfig.loadSettingsToMemory(fileConfig);
        ExplosionSourceConfig.loadSettingsToMemory(fileConfig);
        ExplosionItemDropConfig.loadSettingsToMemory(fileConfig);
        DelaysConfig.loadSettingsToMemory(fileConfig);
        PreferencesConfig.loadSettingsToMemory(fileConfig);
        WhitelistConfig.loadWhitelistToMemory(fileConfig);
        ReplaceMapConfig.loadReplaceMapToMemory(fileConfig);
    }

    static {
        GenericBuilder builder;
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("creeper-healing.toml");
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        try {
            builder = CommentedFileConfig.builder((Path)CONFIG_PATH, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().concurrent().sync();
        }
        catch (Throwable throwable) {
            CreeperHealing.LOGGER.info("Unable to initialize config: {}", (Object)throwable.getMessage());
            CreeperHealing.LOGGER.info("The config will be unable to be used.");
            builder = null;
        }
        CONFIG_BUILDER = builder;
    }
}

