/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.configuration.tables;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.ConfigEntry;

public enum DelaysConfig {
    EXPLOSION_HEAL_DELAY(new ConfigEntry<Double>("explosion_heal_delay", 3.0, "(Default = 3) Change the delay in seconds between each explosion and its corresponding healing process.")),
    BLOCK_PLACEMENT_DELAY(new ConfigEntry<Double>("block_placement_delay", 1.0, "(Default = 1) Change the delay in seconds between each block placement during the explosion healing process."));

    private final ConfigEntry<Double> entry;
    private static final String TABLE_NAME = "delays";
    private static final String TABLE_COMMENT = "Configure the delays related to the healing of explosions.";

    private DelaysConfig(ConfigEntry<Double> entry) {
        this.entry = entry;
    }

    public ConfigEntry<Double> getEntry() {
        return this.entry;
    }

    public static long getExplosionHealDelayAsTicks() {
        long rounded = Math.round(Math.max(EXPLOSION_HEAL_DELAY.getEntry().getValue(), 0.0) * 20.0);
        return rounded == 0L ? 20L : rounded;
    }

    public static long getBlockPlacementDelayAsTicks() {
        long rounded = Math.round(Math.max(BLOCK_PLACEMENT_DELAY.getEntry().getValue(), 0.0) * 20.0);
        return rounded == 0L ? 20L : rounded;
    }

    public static void saveToFileWithDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(DelaysConfig.values()).map(DelaysConfig::getEntry).toList()) {
            configEntry.resetValue();
        }
        DelaysConfig.saveSettingsToFile(fileConfig);
    }

    public static void saveSettingsToFile(CommentedFileConfig fileConfig) {
        for (ConfigEntry entry : Arrays.stream(DelaysConfig.values()).map(DelaysConfig::getEntry).toList()) {
            fileConfig.set("delays." + entry.getName(), entry.getValue());
            String entryComment = entry.getComment();
            if (entryComment == null) continue;
            fileConfig.setComment("delays." + entry.getName(), entryComment);
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
    }

    public static void loadSettingsToMemory(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(DelaysConfig.values()).map(DelaysConfig::getEntry).toList()) {
            Object value = fileConfig.getOrElse("delays." + configEntry.getName(), (Object)((Double)configEntry.getDefaultValue()));
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                configEntry.setValue(numberValue.doubleValue());
                continue;
            }
            CreeperHealing.LOGGER.error("Invalid value in config file for setting: " + configEntry.getName());
        }
    }
}

