/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.configuration.tables;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.ConfigEntry;

public enum ExplosionSourceConfig {
    HEAL_CREEPER_EXPLOSIONS(new ConfigEntry<Boolean>("heal_creeper_explosions", true, "(Default = true) Heal explosions caused by Creepers.")),
    HEAL_GHAST_EXPLOSIONS(new ConfigEntry<Boolean>("heal_ghast_explosions", false, "(Default = false) Heal explosions caused by Ghasts.")),
    HEAL_WITHER_EXPLOSIONS(new ConfigEntry<Boolean>("heal_wither_explosions", false, "(Default = false) Heal explosions caused by Withers.")),
    HEAL_TNT_EXPLOSIONS(new ConfigEntry<Boolean>("heal_tnt_explosions", false, "(Default = false) Heal explosions caused by TNT blocks.")),
    HEAL_TNT_MINECART_EXPLOSIONS(new ConfigEntry<Boolean>("heal_tnt_minecart_explosions", false, "(Default = false) Heal explosions caused by TNT minecarts.")),
    HEAL_BED_AND_RESPAWN_ANCHOR_EXPLOSIONS(new ConfigEntry<Boolean>("heal_bed_and_respawn_anchor_explosions", false, "(Default = false) Heal explosions caused by beds and respawn anchors.")),
    HEAL_END_CRYSTAL_EXPLOSIONS(new ConfigEntry<Boolean>("heal_end_crystal_explosions", false, "(Default = false) Heal explosions caused by end crystals."));

    private final ConfigEntry<Boolean> entry;
    private static final String TABLE_NAME = "explosion_sources";
    private static final String TABLE_COMMENT = "Configure which explosions are allowed to heal.";

    private ExplosionSourceConfig(ConfigEntry<Boolean> entry) {
        this.entry = entry;
    }

    public ConfigEntry<Boolean> getEntry() {
        return this.entry;
    }

    public static void saveToFileWithDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ExplosionSourceConfig.values()).map(ExplosionSourceConfig::getEntry).toList()) {
            configEntry.resetValue();
        }
        ExplosionSourceConfig.saveSettingsToFile(fileConfig);
    }

    public static void saveSettingsToFile(CommentedFileConfig fileConfig) {
        for (ConfigEntry entry : Arrays.stream(ExplosionSourceConfig.values()).map(ExplosionSourceConfig::getEntry).toList()) {
            fileConfig.set("explosion_sources." + entry.getName(), entry.getValue());
            String entryComment = entry.getComment();
            if (entryComment == null) continue;
            fileConfig.setComment("explosion_sources." + entry.getName(), entryComment);
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
    }

    public static void loadSettingsToMemory(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ExplosionSourceConfig.values()).map(ExplosionSourceConfig::getEntry).toList()) {
            Object value = fileConfig.getOrElse("explosion_sources." + configEntry.getName(), (Object)((Boolean)configEntry.getDefaultValue()));
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                configEntry.setValue(boolValue);
                continue;
            }
            CreeperHealing.LOGGER.error("Invalid value in config file for setting: " + configEntry.getName());
        }
    }
}

