/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.configuration.tables;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.ConfigEntry;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;

public enum ModeConfig {
    MODE(new ConfigEntry<String>("mode", ExplosionHealingMode.DEFAULT_MODE.getName(), "(Default = \"default_mode\") Select between any of the following healing modes by copying the string (the text enclosed by the double quotes along with the double quotes)\nand pasting it into the value of the \"mode\" setting below:\n[\"default_mode\", \"daytime_healing_mode\", \"difficulty_based_healing_mode\", \"blast_resistance_based_healing_mode\"] "));

    private final ConfigEntry<String> entry;
    private static final String TABLE_NAME = "explosion_healing_mode";
    private static final String TABLE_COMMENT = "Choose between different special modes for explosion healing.";

    private ModeConfig(ConfigEntry<String> entry) {
        this.entry = entry;
    }

    public ConfigEntry<String> getEntry() {
        return this.entry;
    }

    public static void saveToFileWithDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            configEntry.resetValue();
        }
        ModeConfig.saveSettingsToFile(fileConfig);
    }

    public static void saveSettingsToFile(CommentedFileConfig fileConfig) {
        for (ConfigEntry entry : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            fileConfig.set("explosion_healing_mode." + entry.getName(), entry.getValue());
            String entryComment = entry.getComment();
            if (entryComment == null) continue;
            fileConfig.setComment("explosion_healing_mode." + entry.getName(), entryComment);
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
    }

    public static void loadSettingsToMemory(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            Object value = fileConfig.getOrElse("explosion_healing_mode." + configEntry.getName(), (Object)((String)configEntry.getDefaultValue()));
            if (value instanceof String) {
                String stringValue = (String)value;
                configEntry.setValue(stringValue);
                continue;
            }
            CreeperHealing.LOGGER.error("Invalid value in config file for setting: " + configEntry.getName());
        }
    }
}

