/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.configuration.tables;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.HashMap;
import java.util.Map;
import xd.arkosammy.creeperhealing.CreeperHealing;

public final class ReplaceMapConfig {
    private static final HashMap<String, String> replaceMap = new HashMap();
    private static final String TABLE_NAME = "replace_map";
    private static final String TABLE_COMMENT = "Add your own replace settings to configure which blocks should be used to heal other blocks. The block on the right will be used to heal the block on the left.\nSpecify the block's namespace along with the block's name identifier, separated by a colon.\nExample entry:\n\"minecraft:gold_block\" = \"minecraft:stone\"\nWarning, the same key cannot appear more than once in the replace map! For example, the following will cause an error:\n\"minecraft:diamond_block\" = \"minecraft:stone\"\n\"minecraft:diamond_block\" = \"minecraft:air\" ";

    private ReplaceMapConfig() {
    }

    public static HashMap<String, String> getReplaceMap() {
        return replaceMap;
    }

    public static void saveToFileWithDefaultValues(CommentedFileConfig fileConfig) {
        replaceMap.clear();
        replaceMap.put("minecraft:diamond_block", "minecraft:stone");
        ReplaceMapConfig.saveReplaceMapToFile(fileConfig);
    }

    public static void saveReplaceMapToFile(CommentedFileConfig fileConfig) {
        if (!replaceMap.isEmpty()) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                fileConfig.set("replace_map." + entry.getKey(), (Object)entry.getValue());
            }
        } else {
            fileConfig.set("replace_map.minecraft:placeholder_key", (Object)"minecraft:placeholder_value");
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
    }

    public static void loadReplaceMapToMemory(CommentedFileConfig fileConfig) {
        CommentedConfig replaceMapConfig = (CommentedConfig)fileConfig.get(TABLE_NAME);
        HashMap<String, String> tempReplaceMap = new HashMap<String, String>();
        for (CommentedConfig.Entry entry : replaceMapConfig.entrySet()) {
            if (entry.getValue() instanceof String && entry.getKey() != null) {
                tempReplaceMap.put(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof String)) {
                CreeperHealing.LOGGER.error("Failed to read Replace Map: Invalid value in replace map for key: " + entry.getKey());
                continue;
            }
            if (entry.getKey() != null) continue;
            CreeperHealing.LOGGER.error("Failed to read Replace Map: Invalid key found in replace map.");
        }
        replaceMap.clear();
        replaceMap.putAll(tempReplaceMap);
    }
}

