/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.tables.DelaysConfig;
import xd.arkosammy.creeperhealing.configuration.tables.PreferencesConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ReplaceMapConfig;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.explosions.ExplosionUtils;
import xd.arkosammy.creeperhealing.handlers.DoubleBlockHandler;
import xd.arkosammy.creeperhealing.handlers.ExplosionListHandler;

public class AffectedBlock {
    private final class_2338 pos;
    private final class_2680 state;
    private final class_5321<class_1937> worldRegistryKey;
    private long affectedBlockTimer;
    private boolean placed;
    private static final Codec<AffectedBlock> AFFECTED_BLOCK_CODEC = RecordCodecBuilder.create(affectedBlockInstance -> affectedBlockInstance.group((App)class_2338.field_25064.fieldOf("Block_Position").forGetter(AffectedBlock::getPos), (App)class_2680.field_24734.fieldOf("Block_State").forGetter(AffectedBlock::getState), (App)class_1937.field_25178.fieldOf("World").forGetter(AffectedBlock::getWorldRegistryKey), (App)Codec.LONG.fieldOf("Block_Timer").forGetter(AffectedBlock::getAffectedBlockTimer), (App)Codec.BOOL.fieldOf("Placed").forGetter(AffectedBlock::isAlreadyPlaced)).apply((Applicative)affectedBlockInstance, AffectedBlock::new));

    private AffectedBlock(class_2338 pos, class_2680 state, class_5321<class_1937> registryKey, long affectedBlockTimer, boolean placed) {
        this.pos = pos;
        this.state = state;
        this.worldRegistryKey = registryKey;
        this.setPlaced(placed);
        this.setAffectedBlockTimer(affectedBlockTimer);
    }

    public static AffectedBlock newAffectedBlock(class_2338 pos, class_1937 world) {
        return new AffectedBlock(pos, world.method_8320(pos), (class_5321<class_1937>)world.method_27983(), DelaysConfig.getBlockPlacementDelayAsTicks(), false);
    }

    public void setAffectedBlockTimer(long delay) {
        this.affectedBlockTimer = delay;
    }

    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public class_1937 getWorld(@NotNull MinecraftServer server) {
        return server.method_3847(this.getWorldRegistryKey());
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setPlaced(boolean placed) {
        this.placed = placed;
    }

    public long getAffectedBlockTimer() {
        return this.affectedBlockTimer;
    }

    public boolean isAlreadyPlaced() {
        return this.placed;
    }

    public void tickAffectedBlock() {
        --this.affectedBlockTimer;
    }

    public boolean canBePlaced(MinecraftServer server) {
        return this.getState().method_26184((class_4538)this.getWorld(server), this.getPos());
    }

    static Codec<AffectedBlock> getCodec() {
        return AFFECTED_BLOCK_CODEC;
    }

    public void tryHealing(MinecraftServer server, ExplosionEvent currentExplosionEvent) {
        class_2680 state = this.getState();
        class_2338 pos = this.getPos();
        class_1937 world = this.getWorld(server);
        String blockIdentifier = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        if (ReplaceMapConfig.getReplaceMap().containsKey(blockIdentifier)) {
            state = ((class_2248)class_7923.field_41175.method_10223(new class_2960(ReplaceMapConfig.getReplaceMap().get(blockIdentifier)))).method_34725(state);
        }
        if (DoubleBlockHandler.isDoubleBlock(state)) {
            DoubleBlockHandler.handleDoubleBlock(world, state, pos, currentExplosionEvent);
            return;
        }
        if (this.shouldHealBlock(server)) {
            if (state.method_26212((class_1922)world, pos)) {
                ExplosionUtils.pushEntitiesUpwards(world, pos, false);
            }
            world.method_8501(pos, state);
            if (ExplosionUtils.shouldPlaySoundOnBlockHeal(world, state)) {
                world.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, state.method_26231().method_10597(), state.method_26231().method_10599());
            }
        }
    }

    private boolean shouldHealBlock(MinecraftServer server) {
        class_2680 blockState = this.getWorld(server).method_8320(this.pos);
        class_3610 fluidState = blockState.method_26227();
        if (ExplosionUtils.isStateAirOrFire(blockState)) {
            return true;
        }
        if (fluidState.method_15772().equals(class_3612.field_15909) && PreferencesConfig.HEAL_ON_FLOWING_WATER.getEntry().getValue().booleanValue() || fluidState.method_15772().equals(class_3612.field_15910) && PreferencesConfig.HEAL_ON_SOURCE_WATER.getEntry().getValue().booleanValue()) {
            return true;
        }
        return fluidState.method_15772().equals(class_3612.field_15907) && PreferencesConfig.HEAL_ON_FLOWING_LAVA.getEntry().getValue() != false || fluidState.method_15772().equals(class_3612.field_15908) && PreferencesConfig.HEAL_ON_SOURCE_LAVA.getEntry().getValue() != false;
    }

    public static void updateAffectedBlocksTimers() {
        CreeperHealing.setHealerHandlerLock(false);
        for (ExplosionEvent explosionEvent : ExplosionListHandler.getExplosionEventList()) {
            if (explosionEvent.getExplosionMode() != ExplosionHealingMode.DEFAULT_MODE) continue;
            for (int i = explosionEvent.getAffectedBlockCounter() + 1; i < explosionEvent.getAffectedBlocksList().size(); ++i) {
                explosionEvent.getAffectedBlocksList().get(i).setAffectedBlockTimer(DelaysConfig.getBlockPlacementDelayAsTicks());
            }
        }
        CreeperHealing.setHealerHandlerLock(true);
    }
}

