/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_1267;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.configuration.tables.DelaysConfig;
import xd.arkosammy.creeperhealing.configuration.tables.ModeConfig;
import xd.arkosammy.creeperhealing.explosions.AffectedBlock;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.explosions.ExplosionUtils;
import xd.arkosammy.creeperhealing.handlers.ExplosionListHandler;

public class ExplosionEvent {
    private final List<AffectedBlock> affectedBlocksList;
    private long explosionTimer;
    private int affectedBlockCounter;
    private final ExplosionHealingMode explosionMode;
    private static final Codec<ExplosionEvent> EXPLOSION_EVENT_CODEC = RecordCodecBuilder.create(creeperExplosionEventInstance -> creeperExplosionEventInstance.group((App)Codec.list(AffectedBlock.getCodec()).fieldOf("Affected_Blocks_List").forGetter(ExplosionEvent::getAffectedBlocksList), (App)Codec.STRING.optionalFieldOf("Explosion_Mode", (Object)ExplosionHealingMode.DEFAULT_MODE.getName()).forGetter(explosionEvent -> explosionEvent.getExplosionMode().getName()), (App)Codec.LONG.fieldOf("Explosion_Timer").forGetter(ExplosionEvent::getExplosionTimer), (App)Codec.INT.fieldOf("Current_Block_Counter").forGetter(ExplosionEvent::getCurrentAffectedBlockCounter)).apply((Applicative)creeperExplosionEventInstance, ExplosionEvent::new));

    private ExplosionEvent(List<AffectedBlock> affectedBlocksList, String explosionModeName, long creeperExplosionTimer, int currentIndex) {
        this.affectedBlockCounter = currentIndex;
        this.affectedBlocksList = new CopyOnWriteArrayList<AffectedBlock>(affectedBlocksList);
        this.setExplosionTimer(creeperExplosionTimer);
        this.explosionMode = ExplosionHealingMode.getFromName(explosionModeName);
    }

    public static ExplosionEvent newExplosionEvent(List<AffectedBlock> affectedBlocksList, class_1937 world) {
        ExplosionEvent explosionEvent = new ExplosionEvent(ExplosionUtils.sortAffectedBlocksList(affectedBlocksList, world.method_8503()), ModeConfig.MODE.getEntry().getValue(), DelaysConfig.getExplosionHealDelayAsTicks(), 0);
        explosionEvent.setUpExplosionHealingMode(world);
        Set<ExplosionEvent> collidingExplosions = ExplosionUtils.getCollidingWaitingExplosions(affectedBlocksList.stream().map(AffectedBlock::getPos).toList());
        if (collidingExplosions.isEmpty()) {
            return explosionEvent;
        }
        ExplosionListHandler.getExplosionEventList().removeIf(collidingExplosions::contains);
        collidingExplosions.add(explosionEvent);
        return ExplosionEvent.combineCollidingExplosions(collidingExplosions, explosionEvent, world);
    }

    public void setExplosionTimer(long delay) {
        this.explosionTimer = delay;
    }

    public void incrementCounter() {
        ++this.affectedBlockCounter;
    }

    public List<AffectedBlock> getAffectedBlocksList() {
        return this.affectedBlocksList;
    }

    public long getExplosionTimer() {
        return this.explosionTimer;
    }

    int getAffectedBlockCounter() {
        return this.affectedBlockCounter;
    }

    public ExplosionHealingMode getExplosionMode() {
        return this.explosionMode;
    }

    private int getCurrentAffectedBlockCounter() {
        return this.affectedBlockCounter;
    }

    static Codec<ExplosionEvent> getCodec() {
        return EXPLOSION_EVENT_CODEC;
    }

    public static void tickExplosions() {
        for (ExplosionEvent explosionEvent : ExplosionListHandler.getExplosionEventList()) {
            --explosionEvent.explosionTimer;
        }
    }

    public Optional<AffectedBlock> getCurrentAffectedBlock() {
        if (this.affectedBlockCounter < this.getAffectedBlocksList().size()) {
            return Optional.of(this.getAffectedBlocksList().get(this.affectedBlockCounter));
        }
        return Optional.empty();
    }

    public void delayAffectedBlock(AffectedBlock affectedBlockToDelay, MinecraftServer server) {
        int indexOfPostponed = this.getAffectedBlocksList().indexOf(affectedBlockToDelay);
        if (indexOfPostponed != -1) {
            Optional<Integer> indexOfNextPlaceableOptional = this.findNextPlaceableBlock(server);
            if (indexOfNextPlaceableOptional.isPresent()) {
                int indexOfNextPlaceable = indexOfNextPlaceableOptional.get();
                Collections.swap(this.getAffectedBlocksList(), indexOfPostponed, indexOfNextPlaceable);
            } else {
                this.incrementCounter();
                affectedBlockToDelay.setPlaced(true);
            }
        } else {
            this.incrementCounter();
            affectedBlockToDelay.setPlaced(true);
        }
    }

    private Optional<Integer> findNextPlaceableBlock(MinecraftServer server) {
        for (int i = this.getCurrentAffectedBlockCounter(); i < this.getAffectedBlocksList().size(); ++i) {
            if (!this.getAffectedBlocksList().get(i).canBePlaced(server)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private void setUpExplosionHealingMode(class_1937 world) {
        switch (this.getExplosionMode()) {
            case DAYTIME_HEALING_MODE: {
                this.setupDayTimeHealingMode(world);
                break;
            }
            case DIFFICULTY_BASED_HEALING_MODE: {
                this.setupDifficultyBasedHealingMode(world);
                break;
            }
            case BLAST_RESISTANCE_BASED_HEALING_MODE: {
                this.setupBlastResistanceBasedHealingMode(world);
            }
        }
    }

    private void setupDayTimeHealingMode(class_1937 world) {
        this.setExplosionTimer(24000L - world.method_8532() % 24000L);
        int daylightBasedBlockPlacementDelay = 13000 / Math.max(this.getAffectedBlocksList().size(), 1);
        for (AffectedBlock affectedBlock : this.getAffectedBlocksList()) {
            affectedBlock.setAffectedBlockTimer(daylightBasedBlockPlacementDelay);
        }
    }

    public boolean hasEnoughLightIfDaytimeHealingMode(MinecraftServer server) {
        if (this.getAffectedBlockCounter() > 0 || this.getExplosionMode() != ExplosionHealingMode.DAYTIME_HEALING_MODE) {
            return true;
        }
        return this.getAffectedBlocksList().stream().anyMatch(affectedBlock -> affectedBlock.getWorld(server).method_8314(class_1944.field_9282, affectedBlock.getPos()) > 0 || affectedBlock.getWorld(server).method_8314(class_1944.field_9284, affectedBlock.getPos()) > 0);
    }

    private void setupDifficultyBasedHealingMode(class_1937 world) {
        int difficultyOffset = switch (world.method_8407()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1267.field_5801 -> -2;
            case class_1267.field_5805 -> -1;
            case class_1267.field_5802 -> 1;
            case class_1267.field_5807 -> 2;
        };
        long finalOffset = Math.max(1L, DelaysConfig.getBlockPlacementDelayAsTicks() + (long)(difficultyOffset * 20));
        long finalOffsetExplosion = Math.max(1L, DelaysConfig.getExplosionHealDelayAsTicks() + (long)(difficultyOffset * 20));
        this.setExplosionTimer(finalOffsetExplosion);
        this.getAffectedBlocksList().forEach(affectedBlock -> affectedBlock.setAffectedBlockTimer(finalOffset));
    }

    public boolean shouldKeepHealingIfDifficultyBasedHealingMode(class_1937 world) {
        if (this.getExplosionMode() != ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE || world.method_8407() != class_1267.field_5807) {
            return true;
        }
        class_5819 random = world.method_8409();
        return random.method_39332(0, 50) != 25;
    }

    private void setupBlastResistanceBasedHealingMode(class_1937 world) {
        class_5819 random = world.method_8409();
        this.getAffectedBlocksList().forEach(affectedBlock -> {
            double randomOffset = random.method_39332(-2, 2);
            double affectedBlockBlastResistance = Math.min(affectedBlock.getState().method_26204().method_9520(), 9.0f);
            int offset = (int)(class_3532.method_16436((double)(affectedBlockBlastResistance / 9.0), (double)-2.0, (double)2.0) + randomOffset);
            long finalOffset = Math.max(1L, DelaysConfig.getBlockPlacementDelayAsTicks() + (long)offset * 20L);
            affectedBlock.setAffectedBlockTimer(finalOffset);
        });
    }

    private static ExplosionEvent combineCollidingExplosions(Set<ExplosionEvent> collidingExplosions, ExplosionEvent newestExplosion, class_1937 world) {
        List<AffectedBlock> combinedAffectedBlockList = collidingExplosions.stream().flatMap(explosionEvent -> explosionEvent.getAffectedBlocksList().stream()).collect(Collectors.toList());
        ExplosionEvent explosionEvent2 = new ExplosionEvent(ExplosionUtils.sortAffectedBlocksList(combinedAffectedBlockList, world.method_8503()), newestExplosion.getExplosionMode().getName(), newestExplosion.getExplosionTimer(), newestExplosion.getCurrentAffectedBlockCounter());
        long newestExplosionBlockTimers = DelaysConfig.getBlockPlacementDelayAsTicks();
        explosionEvent2.getAffectedBlocksList().forEach(affectedBlock -> affectedBlock.setAffectedBlockTimer(newestExplosionBlockTimers));
        explosionEvent2.setUpExplosionHealingMode(world);
        return explosionEvent2;
    }

    public void markAffectedBlockAsPlaced(class_2680 secondHalfState, class_2338 secondHalfPos, class_1937 world) {
        CreeperHealing.setHealerHandlerLock(false);
        for (AffectedBlock affectedBlock : this.getAffectedBlocksList()) {
            if (!affectedBlock.getState().equals(secondHalfState) || !affectedBlock.getPos().equals((Object)secondHalfPos) || !affectedBlock.getWorldRegistryKey().equals((Object)world.method_27983())) continue;
            affectedBlock.setPlaced(true);
        }
        CreeperHealing.setHealerHandlerLock(true);
    }
}

